/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.internal.util.counters.MwCounter;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.sql.SqlExpectedResultType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.AbstractSqlResult;
import com.hazelcast.sql.impl.NodeServiceProviderImpl;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.SqlInternalService;
import com.hazelcast.sql.impl.optimizer.DisabledSqlOptimizer;
import com.hazelcast.sql.impl.optimizer.OptimizationTask;
import com.hazelcast.sql.impl.optimizer.PlanKey;
import com.hazelcast.sql.impl.optimizer.SqlOptimizer;
import com.hazelcast.sql.impl.optimizer.SqlPlan;
import com.hazelcast.sql.impl.plan.cache.PlanCache;
import com.hazelcast.sql.impl.plan.cache.PlanCacheChecker;
import com.hazelcast.sql.impl.schema.SqlCatalog;
import com.hazelcast.sql.impl.security.NoOpSqlSecurityContext;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import com.hazelcast.sql.impl.state.QueryResultRegistry;
import java.lang.reflect.Constructor;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nonnull;

public class SqlServiceImpl
implements SqlService {
    private static final String OPTIMIZER_CLASS_PROPERTY_NAME = "hazelcast.sql.optimizerClass";
    private static final String SQL_MODULE_OPTIMIZER_CLASS = "com.hazelcast.jet.sql.impl.CalciteSqlOptimizer";
    private static final long STATE_CHECK_FREQUENCY = 1000L;
    private static final int PLAN_CACHE_SIZE = 10000;
    private final ILogger logger;
    private final NodeEngineImpl nodeEngine;
    private final NodeServiceProviderImpl nodeServiceProvider;
    private final PlanCache planCache = new PlanCache(10000);
    private final long queryTimeout;
    private SqlOptimizer optimizer;
    private SqlInternalService internalService;
    private final Counter sqlQueriesSubmitted = MwCounter.newMwCounter();
    private final Counter sqlStreamingQueriesExecuted = MwCounter.newMwCounter();

    public SqlServiceImpl(NodeEngineImpl nodeEngine) {
        this.logger = nodeEngine.getLogger(this.getClass());
        this.nodeEngine = nodeEngine;
        this.nodeServiceProvider = new NodeServiceProviderImpl(nodeEngine);
        long queryTimeout = nodeEngine.getConfig().getSqlConfig().getStatementTimeoutMillis();
        assert (queryTimeout >= 0L);
        this.queryTimeout = queryTimeout;
    }

    public void start() {
        if (!Util.isJetEnabled(this.nodeEngine)) {
            return;
        }
        QueryResultRegistry resultRegistry = new QueryResultRegistry();
        this.optimizer = this.createOptimizer(this.nodeEngine, resultRegistry);
        String instanceName = this.nodeEngine.getHazelcastInstance().getName();
        PlanCacheChecker planCacheChecker = new PlanCacheChecker(this.nodeEngine, this.planCache, this.optimizer.tableResolvers());
        this.internalService = new SqlInternalService(resultRegistry, instanceName, this.nodeServiceProvider, 1000L, planCacheChecker);
        this.internalService.start();
    }

    public void reset() {
        if (!Util.isJetEnabled(this.nodeEngine)) {
            return;
        }
        this.planCache.clear();
    }

    public void shutdown() {
        if (!Util.isJetEnabled(this.nodeEngine)) {
            return;
        }
        this.planCache.clear();
        if (this.internalService != null) {
            this.internalService.shutdown();
        }
    }

    public SqlInternalService getInternalService() {
        return this.internalService;
    }

    public long getSqlQueriesSubmittedCount() {
        return this.sqlQueriesSubmitted.get();
    }

    public long getSqlStreamingQueriesExecutedCount() {
        return this.sqlStreamingQueriesExecuted.get();
    }

    public SqlOptimizer getOptimizer() {
        return this.optimizer;
    }

    public PlanCache getPlanCache() {
        return this.planCache;
    }

    @Override
    @Nonnull
    public SqlResult execute(@Nonnull SqlStatement statement) {
        return this.execute(statement, NoOpSqlSecurityContext.INSTANCE);
    }

    public SqlResult execute(@Nonnull SqlStatement statement, SqlSecurityContext securityContext) {
        return this.execute(statement, securityContext, null);
    }

    public SqlResult execute(@Nonnull SqlStatement statement, SqlSecurityContext securityContext, QueryId queryId) {
        return this.execute(statement, securityContext, queryId, false);
    }

    public SqlResult execute(@Nonnull SqlStatement statement, SqlSecurityContext securityContext, QueryId queryId, boolean skipStats) {
        Preconditions.checkNotNull(statement, "Query cannot be null");
        if (!skipStats) {
            this.sqlQueriesSubmitted.inc();
        }
        try {
            if (this.nodeEngine.getLocalMember().isLiteMember()) {
                throw QueryException.error("SQL queries cannot be executed on lite members");
            }
            Util.checkJetIsEnabled(this.nodeEngine);
            long timeout2 = statement.getTimeoutMillis();
            if (timeout2 == -1L) {
                timeout2 = this.queryTimeout;
            }
            if (queryId == null) {
                queryId = QueryId.create(this.nodeServiceProvider.getLocalMemberId());
            }
            SqlResult sqlResult = this.query0(queryId, statement.getSchema(), statement.getSql(), statement.getParameters(), timeout2, statement.getCursorBufferSize(), statement.getExpectedResultType(), securityContext);
            if (!skipStats) {
                this.updateSqlStreamingQueriesExecuted(sqlResult);
            }
            return sqlResult;
        }
        catch (AccessControlException e) {
            throw e;
        }
        catch (Exception e) {
            throw QueryUtils.toPublicException(e, this.nodeServiceProvider.getLocalMemberId());
        }
    }

    private void updateSqlStreamingQueriesExecuted(SqlResult sqlResult) {
        if (sqlResult instanceof AbstractSqlResult && ((AbstractSqlResult)sqlResult).isInfiniteRows()) {
            this.sqlStreamingQueriesExecuted.inc();
        }
    }

    private SqlResult query0(QueryId queryId, String schema, String sql, List<Object> args2, long timeout2, int pageSize, SqlExpectedResultType expectedResultType, SqlSecurityContext securityContext) {
        if (sql == null || sql.isEmpty()) {
            throw QueryException.error("SQL statement cannot be empty.");
        }
        ArrayList<Object> args0 = new ArrayList<Object>(args2);
        if (timeout2 < 0L) {
            throw QueryException.error("Timeout cannot be negative: " + timeout2);
        }
        if (pageSize <= 0) {
            throw QueryException.error("Page size must be positive: " + pageSize);
        }
        SqlPlan plan = this.prepare(schema, sql, args0, expectedResultType);
        if (securityContext.isSecurityEnabled()) {
            plan.checkPermissions(securityContext);
        }
        return plan.execute(queryId, args0, timeout2);
    }

    private SqlPlan prepare(String schema, String sql, List<Object> arguments, SqlExpectedResultType expectedResultType) {
        SqlCatalog catalog;
        List<List<String>> searchPaths = this.prepareSearchPaths(schema);
        PlanKey planKey = new PlanKey(searchPaths, sql);
        SqlPlan plan = this.planCache.get(planKey);
        if (plan == null && (plan = this.optimizer.prepare(new OptimizationTask(sql, arguments, searchPaths, catalog = new SqlCatalog(this.optimizer.tableResolvers())))).isCacheable()) {
            this.planCache.put(planKey, plan);
        }
        this.checkReturnType(plan, expectedResultType);
        return plan;
    }

    private void checkReturnType(SqlPlan plan, SqlExpectedResultType expectedResultType) {
        if (expectedResultType == SqlExpectedResultType.ANY) {
            return;
        }
        boolean producesRows = plan.producesRows();
        if (producesRows && expectedResultType == SqlExpectedResultType.UPDATE_COUNT) {
            throw QueryException.error("The statement doesn't produce update count");
        }
        if (!producesRows && expectedResultType == SqlExpectedResultType.ROWS) {
            throw QueryException.error("The statement doesn't produce rows");
        }
    }

    private List<List<String>> prepareSearchPaths(String schema) {
        List<List<String>> currentSearchPaths = schema == null || schema.isEmpty() ? Collections.emptyList() : Collections.singletonList(Arrays.asList("hazelcast", schema));
        return QueryUtils.prepareSearchPaths(currentSearchPaths, this.optimizer.tableResolvers());
    }

    public String mappingDdl(String name) {
        return this.optimizer.mappingDdl(name);
    }

    private SqlOptimizer createOptimizer(NodeEngine nodeEngine, QueryResultRegistry resultRegistry) {
        Constructor<?> constructor;
        Class<?> clazz;
        String className = System.getProperty(OPTIMIZER_CLASS_PROPERTY_NAME, SQL_MODULE_OPTIMIZER_CLASS);
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(SQL_MODULE_OPTIMIZER_CLASS.equals(className) ? Level.FINE : Level.WARNING, "Optimizer class \"" + className + "\" not found, falling back to " + DisabledSqlOptimizer.class.getName());
            return new DisabledSqlOptimizer();
        }
        catch (Exception e) {
            throw new HazelcastException("Failed to resolve optimizer class " + className + ": " + e.getMessage(), e);
        }
        try {
            constructor = clazz.getConstructor(NodeEngine.class, QueryResultRegistry.class);
        }
        catch (ReflectiveOperationException e) {
            throw new HazelcastException("Failed to get the constructor for the optimizer class " + className + ": " + e.getMessage(), e);
        }
        try {
            return (SqlOptimizer)constructor.newInstance(nodeEngine, resultRegistry);
        }
        catch (ReflectiveOperationException e) {
            throw new HazelcastException("Failed to instantiate the optimizer class " + className + ": " + e.getMessage(), e);
        }
    }

    public void closeOnError(QueryId queryId) {
        if (!Util.isJetEnabled(this.nodeEngine)) {
            return;
        }
        this.getInternalService().getClientStateRegistry().closeOnError(queryId);
    }
}

