/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.HazelcastOverloadException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.diagnostics.InvocationProfilerPlugin;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.metrics.StaticMetricsProvider;
import com.hazelcast.internal.util.LatencyDistribution;
import com.hazelcast.internal.util.RuntimeAvailableProcessors;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationAccessor;
import com.hazelcast.spi.impl.operationservice.impl.Invocation;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionIteratingOperation;
import com.hazelcast.spi.impl.sequence.CallIdSequence;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InvocationRegistry
implements Iterable<Invocation>,
StaticMetricsProvider {
    private static final int CORE_SIZE_CHECK = 8;
    private static final int CORE_SIZE_FACTOR = 4;
    private static final int CONCURRENCY_LEVEL = 16;
    private static final int INITIAL_CAPACITY = 1000;
    private static final float LOAD_FACTOR = 0.75f;
    private static final double HUNDRED_PERCENT = 100.0;
    @Probe(name="invocations.pending", level=ProbeLevel.MANDATORY)
    private final ConcurrentMap<Long, Invocation> invocations;
    private final ILogger logger;
    private final CallIdSequence callIdSequence;
    private final boolean profilerEnabled;
    private final ConcurrentMap<Class, LatencyDistribution> latencyDistributions = new ConcurrentHashMap<Class, LatencyDistribution>();
    private volatile boolean alive = true;

    public InvocationRegistry(ILogger logger2, CallIdSequence callIdSequence, HazelcastProperties properties) {
        this.logger = logger2;
        this.callIdSequence = callIdSequence;
        int coreSize = RuntimeAvailableProcessors.get();
        boolean reallyMultiCore = coreSize >= 8;
        int concurrencyLevel = reallyMultiCore ? coreSize * 4 : 16;
        this.invocations = new ConcurrentHashMap<Long, Invocation>(1000, 0.75f, concurrencyLevel);
        this.profilerEnabled = properties.getInteger(InvocationProfilerPlugin.PERIOD_SECONDS) > 0;
    }

    @Override
    public void provideStaticMetrics(MetricsRegistry registry) {
        registry.registerStaticMetrics(this, "operation");
    }

    @Probe(name="invocations.usedPercentage", unit=ProbeUnit.PERCENT)
    private double invocationsUsedPercentage() {
        int maxConcurrentInvocations = this.callIdSequence.getMaxConcurrentInvocations();
        if (maxConcurrentInvocations == Integer.MAX_VALUE) {
            return 0.0;
        }
        return 100.0 * (double)this.invocations.size() / (double)maxConcurrentInvocations;
    }

    @Probe(name="invocations.lastCallId")
    long getLastCallId() {
        return this.callIdSequence.getLastCallId();
    }

    public boolean register(Invocation invocation) {
        long callId;
        boolean force = invocation.op.isUrgent() || invocation.isRetryCandidate();
        try {
            callId = force ? this.callIdSequence.forceNext() : this.callIdSequence.next();
        }
        catch (HazelcastOverloadException e) {
            throw new HazelcastOverloadException("Failed to start invocation due to overload: " + invocation, e);
        }
        try {
            OperationAccessor.setCallId(invocation.op, callId);
        }
        catch (IllegalStateException e) {
            this.callIdSequence.complete();
            throw e;
        }
        this.invocations.put(callId, invocation);
        if (!this.alive) {
            invocation.notifyError(new HazelcastInstanceNotActiveException());
            return false;
        }
        return true;
    }

    public boolean deregister(Invocation invocation) {
        if (!OperationAccessor.deactivate(invocation.op)) {
            return false;
        }
        this.invocations.remove(invocation.op.getCallId());
        this.callIdSequence.complete();
        return true;
    }

    public void retire(Invocation invocation) {
        if (!this.profilerEnabled) {
            return;
        }
        Operation op = invocation.op;
        Class<?> c = op.getClass();
        if (op instanceof PartitionIteratingOperation) {
            c = ((PartitionIteratingOperation)op).getOperationFactory().getClass();
        }
        LatencyDistribution distribution = this.latencyDistributions.computeIfAbsent(c, k -> new LatencyDistribution());
        distribution.done(invocation.firstInvocationTimeNanos);
    }

    public final ConcurrentMap<Class, LatencyDistribution> latencyDistributions() {
        return this.latencyDistributions;
    }

    public int size() {
        return this.invocations.size();
    }

    @Override
    public Iterator<Invocation> iterator() {
        return this.invocations.values().iterator();
    }

    public Set<Map.Entry<Long, Invocation>> entrySet() {
        return this.invocations.entrySet();
    }

    public Invocation get(long callId) {
        return (Invocation)this.invocations.get(callId);
    }

    public void reset(Throwable cause) {
        for (Invocation invocation : this) {
            try {
                invocation.notifyError(new MemberLeftException(cause));
            }
            catch (Throwable e) {
                this.logger.warning(invocation + " could not be notified with reset message -> " + e.getMessage());
            }
        }
    }

    public void shutdown() {
        this.alive = false;
        for (Invocation invocation : this) {
            try {
                invocation.notifyError(new HazelcastInstanceNotActiveException());
            }
            catch (Throwable e) {
                this.logger.warning(invocation + " could not be notified with shutdown message -> " + e.getMessage(), e);
            }
        }
    }
}

