/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.spi.impl.DelegatingCompletableFuture;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class DeserializingCompletableFuture<V>
extends InternalCompletableFuture<V> {
    private final InternalSerializationService serializationService;
    private final Executor defaultAsyncExecutor;
    private final boolean deserialize;

    public DeserializingCompletableFuture() {
        this(null, ConcurrencyUtil.getDefaultAsyncExecutor(), false);
    }

    public DeserializingCompletableFuture(Executor defaultAsyncExecutor) {
        this(null, defaultAsyncExecutor, false);
    }

    public DeserializingCompletableFuture(SerializationService serializationService, boolean deserialize) {
        this(serializationService, ConcurrencyUtil.getDefaultAsyncExecutor(), deserialize);
    }

    public DeserializingCompletableFuture(SerializationService serializationService, Executor defaultAsyncExecutor, boolean deserialize) {
        this.serializationService = (InternalSerializationService)serializationService;
        this.defaultAsyncExecutor = defaultAsyncExecutor;
        this.deserialize = deserialize;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.resolve(super.get());
    }

    @Override
    public V get(long timeout2, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.resolve(super.get(timeout2, unit));
    }

    @Override
    public V getNow(V valueIfAbsent) {
        V value = super.getNow(valueIfAbsent);
        return (V)(this.deserialize && value instanceof Data ? this.serializationService.toObject(value) : value);
    }

    @Override
    public V join() {
        return this.resolve(super.join());
    }

    @Override
    public V joinInternal() {
        return this.resolve(super.joinInternal());
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super V, ? extends U> fn) {
        return super.thenApply(new DeserializingFunction<V, U>(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super V, ? extends U> fn) {
        return super.thenApplyAsync(new DeserializingFunction<V, U>(fn), this.defaultAsyncExecutor);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super V, ? extends U> fn, Executor executor) {
        return super.thenApplyAsync(new DeserializingFunction<V, U>(fn), executor);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super V> action) {
        return super.thenAccept(new DeserializingConsumer<V>(action));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super V> action) {
        return super.thenAcceptAsync(new DeserializingConsumer<V>(action), this.defaultAsyncExecutor);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super V> action, Executor executor) {
        return super.thenAcceptAsync(new DeserializingConsumer<V>(action), executor);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return super.thenRun(action);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return super.thenRunAsync(action, this.defaultAsyncExecutor);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return super.thenRunAsync(action, executor);
    }

    @Override
    public <U, V1> CompletableFuture<V1> thenCombine(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn) {
        return super.thenCombine((CompletionStage)other, new DeserializingBiFunction<V, U, V1>(fn));
    }

    @Override
    public <U, V1> CompletableFuture<V1> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn) {
        return super.thenCombineAsync((CompletionStage)other, new DeserializingBiFunction<V, U, V1>(fn), this.defaultAsyncExecutor);
    }

    @Override
    public <U, V1> CompletableFuture<V1> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn, Executor executor) {
        return super.thenCombineAsync((CompletionStage)other, new DeserializingBiFunction<V, U, V1>(fn), executor);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action) {
        return super.thenAcceptBoth((CompletionStage)other, new DeserializingBiConsumer<V, U>(action));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action) {
        return super.thenAcceptBothAsync((CompletionStage)other, new DeserializingBiConsumer<V, U>(action), this.defaultAsyncExecutor);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action, Executor executor) {
        return super.thenAcceptBothAsync((CompletionStage)other, new DeserializingBiConsumer<V, U>(action), executor);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return super.runAfterBoth((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return super.runAfterBothAsync((CompletionStage)other, action, this.defaultAsyncExecutor);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return super.runAfterBothAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends V> other, Function<? super V, U> fn) {
        return super.applyToEither((CompletionStage)other, new DeserializingFunction<V, U>(fn));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends V> other, Function<? super V, U> fn) {
        return super.applyToEitherAsync(other, new DeserializingFunction<V, U>(fn), this.defaultAsyncExecutor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends V> other, Function<? super V, U> fn, Executor executor) {
        return super.applyToEitherAsync(other, new DeserializingFunction<V, U>(fn), executor);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends V> other, Consumer<? super V> action) {
        return super.acceptEither((CompletionStage)other, new DeserializingConsumer<V>(action));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends V> other, Consumer<? super V> action) {
        return super.acceptEitherAsync(other, new DeserializingConsumer<V>(action), this.defaultAsyncExecutor);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends V> other, Consumer<? super V> action, Executor executor) {
        return super.acceptEitherAsync(other, new DeserializingConsumer<V>(action), executor);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return super.runAfterEither((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return super.runAfterEitherAsync((CompletionStage)other, action, this.defaultAsyncExecutor);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return super.runAfterEitherAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super V, ? extends CompletionStage<U>> fn) {
        return super.thenCompose(new DeserializingFunction<V, CompletionStage<U>>(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> fn) {
        return super.thenComposeAsync(new DeserializingFunction<V, CompletionStage<U>>(fn), this.defaultAsyncExecutor);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> fn, Executor executor) {
        return super.thenComposeAsync(new DeserializingFunction<V, CompletionStage<U>>(fn), executor);
    }

    @Override
    public CompletableFuture<V> whenComplete(BiConsumer<? super V, ? super Throwable> action) {
        if (!this.deserialize) {
            return super.whenComplete(new DeserializingBiConsumer<V, Throwable>(action));
        }
        return new DelegatingCompletableFuture(this.serializationService, (CompletableFuture)super.whenComplete(new DeserializingBiConsumer<V, Throwable>(action)));
    }

    @Override
    public CompletableFuture<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> action) {
        if (!this.deserialize) {
            return super.whenCompleteAsync(new DeserializingBiConsumer<V, Throwable>(action), this.defaultAsyncExecutor);
        }
        return new DelegatingCompletableFuture(this.serializationService, (CompletableFuture)super.whenCompleteAsync(new DeserializingBiConsumer<V, Throwable>(action), this.defaultAsyncExecutor));
    }

    @Override
    public CompletableFuture<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> action, Executor executor) {
        if (!this.deserialize) {
            return super.whenCompleteAsync(new DeserializingBiConsumer<V, Throwable>(action), executor);
        }
        return new DelegatingCompletableFuture(this.serializationService, (CompletableFuture)super.whenCompleteAsync(new DeserializingBiConsumer<V, Throwable>(action), executor));
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super V, Throwable, ? extends U> fn) {
        return super.handle(new DeserializingBiFunction<V, Throwable, U>(fn));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> fn) {
        return super.handleAsync(new DeserializingBiFunction<V, Throwable, U>(fn), this.defaultAsyncExecutor);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> fn, Executor executor) {
        return super.handleAsync(new DeserializingBiFunction<V, Throwable, U>(fn), executor);
    }

    @Override
    public CompletableFuture<V> exceptionally(Function<Throwable, ? extends V> fn) {
        if (!this.deserialize) {
            return super.exceptionally(fn);
        }
        return new DelegatingCompletableFuture(this.serializationService, (CompletableFuture)super.exceptionally(fn));
    }

    private V resolve(Object object) {
        if (this.deserialize && object instanceof Data) {
            Data data = (Data)object;
            object = this.serializationService.toObject(data);
            this.serializationService.disposeData(data);
        }
        return (V)object;
    }

    class DeserializingBiConsumer<T, U>
    implements BiConsumer<T, U> {
        private final BiConsumer<T, U> delegate;

        DeserializingBiConsumer(BiConsumer<T, U> delegate) {
            if (delegate == null) {
                throw new NullPointerException();
            }
            this.delegate = delegate;
        }

        @Override
        public void accept(T t, U u) {
            this.delegate.accept(DeserializingCompletableFuture.this.deserialize ? DeserializingCompletableFuture.this.serializationService.toObject(t) : t, DeserializingCompletableFuture.this.deserialize ? DeserializingCompletableFuture.this.serializationService.toObject(u) : u);
        }
    }

    class DeserializingBiFunction<T, U, R>
    implements BiFunction<T, U, R> {
        private final BiFunction<T, U, R> delegate;

        DeserializingBiFunction(BiFunction<T, U, R> delegate) {
            if (delegate == null) {
                throw new NullPointerException();
            }
            this.delegate = delegate;
        }

        @Override
        public R apply(T t, U u) {
            return this.delegate.apply(DeserializingCompletableFuture.this.deserialize ? DeserializingCompletableFuture.this.serializationService.toObject(t) : t, DeserializingCompletableFuture.this.deserialize ? DeserializingCompletableFuture.this.serializationService.toObject(u) : u);
        }
    }

    class DeserializingConsumer<E>
    implements Consumer<E> {
        private final Consumer<E> delegate;

        DeserializingConsumer(Consumer<E> delegate) {
            if (delegate == null) {
                throw new NullPointerException();
            }
            this.delegate = delegate;
        }

        @Override
        public void accept(E e) {
            this.delegate.accept(DeserializingCompletableFuture.this.deserialize ? DeserializingCompletableFuture.this.serializationService.toObject(e) : e);
        }
    }

    class DeserializingFunction<E, R>
    implements Function<E, R> {
        private final Function<E, R> delegate;

        DeserializingFunction(Function<E, R> delegate) {
            if (delegate == null) {
                throw new NullPointerException();
            }
            this.delegate = delegate;
        }

        @Override
        public R apply(E e) {
            return this.delegate.apply(DeserializingCompletableFuture.this.deserialize ? DeserializingCompletableFuture.this.serializationService.toObject(e) : e);
        }
    }
}

