/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl.function;

import com.hazelcast.cache.EventJournalCacheEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.journal.EventJournalReader;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.ToResultSetFunction;
import com.hazelcast.jet.impl.connector.ReadIListP;
import com.hazelcast.jet.impl.connector.ReadJdbcP;
import com.hazelcast.jet.impl.connector.StreamFilesP;
import com.hazelcast.jet.impl.connector.StreamSocketP;
import com.hazelcast.jet.impl.connector.UpdateMapP;
import com.hazelcast.jet.impl.connector.UpdateMapWithEntryProcessorP;
import com.hazelcast.jet.impl.connector.WriteFileP;
import com.hazelcast.jet.json.JsonUtil;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.EventJournalMapEvent;
import com.hazelcast.map.IMap;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.security.PermissionsUtil;
import com.hazelcast.security.permission.CachePermission;
import com.hazelcast.security.permission.ConnectorPermission;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.security.permission.ReliableTopicPermission;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import com.hazelcast.topic.ITopic;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Permission;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.sql.DataSource;

public final class SecuredFunctions {
    private SecuredFunctions() {
    }

    public static <K, V> FunctionEx<? super ProcessorSupplier.Context, IMap<K, V>> iMapFn(final String name) {
        return new FunctionEx<ProcessorSupplier.Context, IMap<K, V>>(){

            @Override
            public IMap<K, V> applyEx(ProcessorSupplier.Context context) {
                return context.hazelcastInstance().getMap(name);
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(new MapPermission(name, "create", "read"));
            }
        };
    }

    public static <K, V> FunctionEx<HazelcastInstance, EventJournalReader<EventJournalMapEvent<K, V>>> mapEventJournalReaderFn(final String name) {
        return new FunctionEx<HazelcastInstance, EventJournalReader<EventJournalMapEvent<K, V>>>(){

            @Override
            public EventJournalReader<EventJournalMapEvent<K, V>> applyEx(HazelcastInstance instance) {
                return (EventJournalReader)((Object)instance.getMap(name));
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(new MapPermission(name, "create", "read"));
            }
        };
    }

    public static <K, V> FunctionEx<HazelcastInstance, EventJournalReader<EventJournalCacheEvent<K, V>>> cacheEventJournalReaderFn(final String name) {
        return new FunctionEx<HazelcastInstance, EventJournalReader<EventJournalCacheEvent<K, V>>>(){

            @Override
            public EventJournalReader<EventJournalCacheEvent<K, V>> applyEx(HazelcastInstance instance) {
                return (EventJournalReader)((Object)instance.getCacheManager().getCache(name));
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(new CachePermission(name, "create", "read"));
            }
        };
    }

    public static <K, V> FunctionEx<? super ProcessorSupplier.Context, ReplicatedMap<K, V>> replicatedMapFn(final String name) {
        return new FunctionEx<ProcessorSupplier.Context, ReplicatedMap<K, V>>(){

            @Override
            public ReplicatedMap<K, V> applyEx(ProcessorSupplier.Context context) {
                return context.hazelcastInstance().getReplicatedMap(name);
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(new ReplicatedMapPermission(name, "create", "read"));
            }
        };
    }

    public static SupplierEx<Processor> readListProcessorFn(final String name, final String clientXml) {
        return new SupplierEx<Processor>(){

            @Override
            public Processor getEx() {
                return new ReadIListP(name, clientXml);
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(PermissionsUtil.listReadPermission(clientXml, name));
            }
        };
    }

    public static <E> FunctionEx<Processor.Context, ITopic<E>> reliableTopicFn(final String name) {
        return new FunctionEx<Processor.Context, ITopic<E>>(){

            @Override
            public ITopic<E> applyEx(Processor.Context context) {
                return context.hazelcastInstance().getReliableTopic(name);
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(new ReliableTopicPermission(name, "create", "publish"));
            }
        };
    }

    public static <S> BiFunctionEx<? super Processor.Context, Void, ? extends S> createServiceFn(final FunctionEx<? super Processor.Context, ? extends S> createContextFn) {
        return new BiFunctionEx<Processor.Context, Void, S>(){

            @Override
            public S applyEx(Processor.Context context, Void o) throws Exception {
                return createContextFn.applyEx(context);
            }

            @Override
            public List<Permission> permissions() {
                return createContextFn.permissions();
            }
        };
    }

    public static SupplierEx<Processor> streamSocketProcessorFn(final String host, final int port, final String charset) {
        return new SupplierEx<Processor>(){

            @Override
            public Processor getEx() {
                return new StreamSocketP(host, port, Charset.forName(charset));
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(ConnectorPermission.socket(host, port, "read"));
            }
        };
    }

    public static <T> FunctionEx<? super Path, Stream<T>> readFileFn(final String directory, final String charsetName, final BiFunctionEx<? super String, ? super String, ? extends T> mapOutputFn) {
        return new FunctionEx<Path, Stream<T>>(){

            @Override
            public Stream<T> applyEx(Path path) throws Exception {
                String fileName = path.getFileName().toString();
                return Files.lines(path, Charset.forName(charsetName)).map(l -> mapOutputFn.apply(fileName, l));
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(ConnectorPermission.file(directory, "read"));
            }
        };
    }

    public static <T> FunctionEx<? super Path, ? extends Stream<T>> jsonReadFileFn(final String directory, final Class<T> type) {
        return new FunctionEx<Path, Stream<T>>(){

            @Override
            public Stream<T> applyEx(Path path) throws Exception {
                return JsonUtil.beanSequenceFrom(path, type);
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(ConnectorPermission.file(directory, "read"));
            }
        };
    }

    public static <T> FunctionEx<? super Path, ? extends Stream<Map<String, Object>>> jsonReadFileFn(final String directory) {
        return new FunctionEx<Path, Stream<Map<String, Object>>>(){

            @Override
            public Stream<Map<String, Object>> applyEx(Path path) throws Exception {
                return JsonUtil.mapSequenceFrom(path);
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(ConnectorPermission.file(directory, "read"));
            }
        };
    }

    public static SupplierEx<Processor> streamFileProcessorFn(final String watchedDirectory, final String charset, final String glob, final boolean sharedFileSystem, final BiFunctionEx<? super String, ? super String, ?> mapOutputFn) {
        return new SupplierEx<Processor>(){

            @Override
            public Processor getEx() {
                return new StreamFilesP(watchedDirectory, Charset.forName(charset), glob, sharedFileSystem, mapOutputFn);
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(ConnectorPermission.file(watchedDirectory, "read"));
            }
        };
    }

    public static <T> ProcessorSupplier readJdbcProcessorFn(final String connectionUrl, final FunctionEx<ProcessorSupplier.Context, ? extends DataSource> newDataSourceFn, final ToResultSetFunction resultSetFn, final FunctionEx<? super ResultSet, ? extends T> mapOutputFn) {
        return new ProcessorSupplier(){
            private DataSource dataSource;

            @Override
            public void init(@Nonnull ProcessorSupplier.Context context) {
                this.dataSource = (DataSource)newDataSourceFn.apply(context);
            }

            @Override
            @Nonnull
            public Collection<? extends Processor> get(int count) {
                return IntStream.range(0, count).mapToObj(i -> new ReadJdbcP(this.dataSource::getConnection, resultSetFn, mapOutputFn)).collect(Collectors.toList());
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(ConnectorPermission.jdbc(connectionUrl, "read"));
            }
        };
    }

    public static FunctionEx<? super Processor.Context, ? extends BufferedWriter> createBufferedWriterFn(final String host, final int port, final String charsetName) {
        return new FunctionEx<Processor.Context, BufferedWriter>(){

            @Override
            public BufferedWriter applyEx(Processor.Context context) throws Exception {
                return new BufferedWriter(new OutputStreamWriter(new Socket(host, port).getOutputStream(), charsetName));
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(ConnectorPermission.socket(host, port, "write"));
            }
        };
    }

    public static <T> SupplierEx<Processor> writeFileProcessorFn(final String directoryName, final FunctionEx<? super T, ? extends String> toStringFn, final String charset, final String datePattern, final long maxFileSize, final boolean exactlyOnce, final LongSupplier clock) {
        return new SupplierEx<Processor>(){

            @Override
            public Processor getEx() {
                return new WriteFileP(directoryName, toStringFn, charset, datePattern, maxFileSize, exactlyOnce, clock);
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(ConnectorPermission.file(directoryName, "write"));
            }
        };
    }

    public static <T, K, V> FunctionEx<HazelcastInstance, Processor> updateMapProcessorFn(final String name, final String clientXml, final FunctionEx<? super T, ? extends K> toKeyFn, final BiFunctionEx<? super V, ? super T, ? extends V> updateFn) {
        return new FunctionEx<HazelcastInstance, Processor>(){

            @Override
            public Processor applyEx(HazelcastInstance instance) {
                return new UpdateMapP(instance, name, toKeyFn, updateFn);
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(PermissionsUtil.mapUpdatePermission(clientXml, name));
            }
        };
    }

    public static <T, R, K, V> FunctionEx<HazelcastInstance, Processor> updateWithEntryProcessorFn(final int maxParallelAsyncOps, final String name, final String clientXml, final FunctionEx<? super T, ? extends K> toKeyFn, final FunctionEx<? super T, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn) {
        return new FunctionEx<HazelcastInstance, Processor>(){

            @Override
            public Processor applyEx(HazelcastInstance instance) throws Exception {
                return new UpdateMapWithEntryProcessorP(instance, maxParallelAsyncOps, name, toKeyFn, toEntryProcessorFn);
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(PermissionsUtil.mapUpdatePermission(clientXml, name));
            }
        };
    }
}

