/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.memory;

import com.hazelcast.internal.util.QuickMath;

public enum MemoryUnit {
    BYTES(0){

        @Override
        public long convert(long value, MemoryUnit m3) {
            return m3.toBytes(value);
        }

        @Override
        public long toBytes(long value) {
            return value;
        }

        @Override
        public long toKiloBytes(long value) {
            return QuickMath.divideByAndRoundToInt(value, 1024);
        }

        @Override
        public long toMegaBytes(long value) {
            return QuickMath.divideByAndRoundToInt(value, 0x100000);
        }

        @Override
        public long toGigaBytes(long value) {
            return QuickMath.divideByAndRoundToInt(value, 0x40000000);
        }

        @Override
        public String abbreviation() {
            return "B";
        }
    }
    ,
    KILOBYTES(1){

        @Override
        public long convert(long value, MemoryUnit m3) {
            return m3.toKiloBytes(value);
        }

        @Override
        public long toBytes(long value) {
            return value * 1024L;
        }

        @Override
        public long toKiloBytes(long value) {
            return value;
        }

        @Override
        public long toMegaBytes(long value) {
            return QuickMath.divideByAndRoundToInt(value, 1024);
        }

        @Override
        public long toGigaBytes(long value) {
            return QuickMath.divideByAndRoundToInt(value, 0x100000);
        }

        @Override
        public String abbreviation() {
            return "KB";
        }
    }
    ,
    MEGABYTES(2){

        @Override
        public long convert(long value, MemoryUnit m3) {
            return m3.toMegaBytes(value);
        }

        @Override
        public long toBytes(long value) {
            return value * 0x100000L;
        }

        @Override
        public long toKiloBytes(long value) {
            return value * 1024L;
        }

        @Override
        public long toMegaBytes(long value) {
            return value;
        }

        @Override
        public long toGigaBytes(long value) {
            return QuickMath.divideByAndRoundToInt(value, 1024);
        }

        @Override
        public String abbreviation() {
            return "MB";
        }
    }
    ,
    GIGABYTES(3){

        @Override
        public long convert(long value, MemoryUnit m3) {
            return m3.toGigaBytes(value);
        }

        @Override
        public long toBytes(long value) {
            return value * 0x40000000L;
        }

        @Override
        public long toKiloBytes(long value) {
            return value * 0x100000L;
        }

        @Override
        public long toMegaBytes(long value) {
            return value * 1024L;
        }

        @Override
        public long toGigaBytes(long value) {
            return value;
        }

        @Override
        public String abbreviation() {
            return "GB";
        }
    };

    static final int POWER = 10;
    static final int K = 1024;
    static final int M = 0x100000;
    static final int G = 0x40000000;
    private static final MemoryUnit[] VALUES;
    private final int id;

    private MemoryUnit(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static MemoryUnit getById(int id) {
        return VALUES[id];
    }

    public abstract long convert(long var1, MemoryUnit var3);

    public abstract long toBytes(long var1);

    public abstract long toKiloBytes(long var1);

    public abstract long toMegaBytes(long var1);

    public abstract long toGigaBytes(long var1);

    public abstract String abbreviation();

    static {
        VALUES = MemoryUnit.values();
    }
}

