/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.kubernetes;

import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.kubernetes.KubernetesApiProvider;
import com.hazelcast.kubernetes.KubernetesClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

class KubernetesApiEndpointProvider
implements KubernetesApiProvider {
    KubernetesApiEndpointProvider() {
    }

    @Override
    public String getEndpointsByServiceLabelUrlString() {
        return "%s/api/v1/namespaces/%s/endpoints?%s";
    }

    @Override
    public String getEndpointsByNameUrlString() {
        return "%s/api/v1/namespaces/%s/endpoints/%s";
    }

    @Override
    public String getEndpointsUrlString() {
        return "%s/api/v1/namespaces/%s/endpoints";
    }

    @Override
    public List<KubernetesClient.Endpoint> parseEndpointsList(JsonObject endpointsListJson) {
        ArrayList<KubernetesClient.Endpoint> endpoints = new ArrayList<KubernetesClient.Endpoint>();
        for (JsonValue item : KubernetesApiProvider.toJsonArray(endpointsListJson.get("items"))) {
            endpoints.addAll(this.parseEndpoints(item));
        }
        return endpoints;
    }

    @Override
    public List<KubernetesClient.Endpoint> parseEndpoints(JsonValue endpointItemJson) {
        ArrayList<KubernetesClient.Endpoint> addresses = new ArrayList<KubernetesClient.Endpoint>();
        for (JsonValue subset : KubernetesApiProvider.toJsonArray(endpointItemJson.asObject().get("subsets"))) {
            Integer endpointPort = this.extractPort(subset);
            for (JsonValue address : KubernetesApiProvider.toJsonArray(subset.asObject().get("addresses"))) {
                addresses.add(this.extractEntrypointAddress(address, endpointPort, true));
            }
            for (JsonValue address : KubernetesApiProvider.toJsonArray(subset.asObject().get("notReadyAddresses"))) {
                addresses.add(this.extractEntrypointAddress(address, endpointPort, false));
            }
        }
        return addresses;
    }

    private KubernetesClient.Endpoint extractEntrypointAddress(JsonValue endpointAddressJson, Integer endpointPort, boolean isReady) {
        String ip = endpointAddressJson.asObject().get("ip").asString();
        String targetRefName = endpointAddressJson.asObject().get("targetRef").asObject().get("name").asString();
        Map<String, String> additionalProperties = this.extractAdditionalPropertiesFrom(endpointAddressJson);
        return new KubernetesClient.Endpoint(new KubernetesClient.EndpointAddress(ip, endpointPort, targetRefName), isReady, additionalProperties);
    }

    @Override
    public Map<KubernetesClient.EndpointAddress, String> extractServices(JsonObject endpointsListJson, List<KubernetesClient.EndpointAddress> privateAddresses) {
        HashMap<KubernetesClient.EndpointAddress, String> result = new HashMap<KubernetesClient.EndpointAddress, String>();
        HashSet<KubernetesClient.EndpointAddress> left = new HashSet<KubernetesClient.EndpointAddress>(privateAddresses);
        for (JsonValue item : KubernetesApiProvider.toJsonArray(endpointsListJson.get("items"))) {
            KubernetesClient.EndpointAddress address;
            String service = KubernetesApiProvider.convertToString(item.asObject().get("metadata").asObject().get("name"));
            List<KubernetesClient.Endpoint> endpoints = this.parseEndpoints(item);
            if (endpoints.size() != 1 || !privateAddresses.contains(address = endpoints.get(0).getPrivateAddress())) continue;
            if (!result.containsKey(address) || service.equals(this.extractTargetRefName(item))) {
                result.put(address, service);
            }
            left.remove(address);
        }
        if (!left.isEmpty()) {
            throw this.noCorrespondingServicesException(left);
        }
        return result;
    }

    private String extractTargetRefName(JsonValue endpointItemJson) {
        return Optional.of(endpointItemJson).flatMap(e -> KubernetesApiProvider.toJsonArray(e.asObject().get("subsets")).values().stream().findFirst()).flatMap(e -> Stream.concat(KubernetesApiProvider.toJsonArray(e.asObject().get("addresses")).values().stream(), KubernetesApiProvider.toJsonArray(e.asObject().get("notReadyAddresses")).values().stream()).findFirst()).map(e -> e.asObject().get("targetRef")).map(e -> e.asObject().get("name")).map(KubernetesApiProvider::convertToString).orElse(null);
    }

    @Override
    public Map<KubernetesClient.EndpointAddress, String> extractNodes(JsonObject endpointsListJson, List<KubernetesClient.EndpointAddress> privateAddresses) {
        HashMap<KubernetesClient.EndpointAddress, String> result = new HashMap<KubernetesClient.EndpointAddress, String>();
        HashSet<KubernetesClient.EndpointAddress> left = new HashSet<KubernetesClient.EndpointAddress>(privateAddresses);
        for (JsonValue item : KubernetesApiProvider.toJsonArray(endpointsListJson.get("items"))) {
            for (JsonValue subset : KubernetesApiProvider.toJsonArray(item.asObject().get("subsets"))) {
                JsonObject subsetObject = subset.asObject();
                ArrayList<Integer> ports = new ArrayList<Integer>();
                for (JsonValue port : KubernetesApiProvider.toJsonArray(subsetObject.get("ports"))) {
                    ports.add(port.asObject().get("port").asInt());
                }
                HashMap<KubernetesClient.EndpointAddress, String> nodes = new HashMap<KubernetesClient.EndpointAddress, String>();
                nodes.putAll(this.extractNodes(subsetObject.get("addresses"), ports));
                nodes.putAll(this.extractNodes(subsetObject.get("notReadyAddresses"), ports));
                for (Map.Entry nodeEntry : nodes.entrySet()) {
                    KubernetesClient.EndpointAddress address = (KubernetesClient.EndpointAddress)nodeEntry.getKey();
                    if (!privateAddresses.contains(address)) continue;
                    result.put(address, (String)nodes.get(address));
                    left.remove(address);
                }
            }
        }
        if (!left.isEmpty()) {
            throw this.noNodeNameAssignedException(left);
        }
        return result;
    }

    private Map<KubernetesClient.EndpointAddress, String> extractNodes(JsonValue addressesJson, List<Integer> ports) {
        HashMap<KubernetesClient.EndpointAddress, String> result = new HashMap<KubernetesClient.EndpointAddress, String>();
        for (JsonValue address : KubernetesApiProvider.toJsonArray(addressesJson)) {
            String ip = address.asObject().get("ip").asString();
            String targetRefName = address.asObject().get("targetRef").asObject().get("name").asString();
            String nodeName = KubernetesApiProvider.convertToString(address.asObject().get("nodeName"));
            for (Integer port : ports) {
                result.put(new KubernetesClient.EndpointAddress(ip, port, targetRefName), nodeName);
            }
        }
        return result;
    }
}

