/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.test;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.test.TestProcessorSupplierContext;
import com.hazelcast.logging.ILogger;
import java.util.Map;
import javax.annotation.Nonnull;

public class TestProcessorContext
extends TestProcessorSupplierContext
implements Processor.Context {
    private int localProcessorIndex = 0;
    private int globalProcessorIndex = 0;

    @Override
    public int localProcessorIndex() {
        assert (this.localProcessorIndex >= 0 && this.localProcessorIndex < this.localParallelism()) : "localProcessorIndex should be in range 0.." + (this.localParallelism() - 1);
        return this.localProcessorIndex;
    }

    @Override
    public int globalProcessorIndex() {
        assert (this.globalProcessorIndex >= 0 && this.globalProcessorIndex < this.totalParallelism()) : "globalProcessorIndex should be in range 0.." + (this.totalParallelism() - 1);
        return this.globalProcessorIndex;
    }

    public TestProcessorContext setLocalProcessorIndex(int localProcessorIndex) {
        this.localProcessorIndex = localProcessorIndex;
        return this;
    }

    public TestProcessorContext setGlobalProcessorIndex(int globalProcessorIndex) {
        this.globalProcessorIndex = globalProcessorIndex;
        return this;
    }

    @Override
    @Nonnull
    public TestProcessorContext setLogger(@Nonnull ILogger logger2) {
        return (TestProcessorContext)super.setLogger(logger2);
    }

    @Override
    @Nonnull
    public TestProcessorContext setHazelcastInstance(@Nonnull HazelcastInstance instance) {
        return (TestProcessorContext)super.setHazelcastInstance(instance);
    }

    @Override
    @Nonnull
    public TestProcessorContext setJobConfig(@Nonnull JobConfig jobConfig) {
        return (TestProcessorContext)super.setJobConfig(jobConfig);
    }

    @Override
    @Nonnull
    public TestProcessorContext setTotalParallelism(int totalParallelism) {
        return (TestProcessorContext)super.setTotalParallelism(totalParallelism);
    }

    @Override
    @Nonnull
    public TestProcessorContext setLocalParallelism(int localParallelism) {
        return (TestProcessorContext)super.setLocalParallelism(localParallelism);
    }

    @Override
    @Nonnull
    public TestProcessorContext setVertexName(@Nonnull String vertexName) {
        return (TestProcessorContext)super.setVertexName(vertexName);
    }

    @Override
    @Nonnull
    public TestProcessorContext setProcessingGuarantee(@Nonnull ProcessingGuarantee processingGuarantee) {
        return (TestProcessorContext)super.setProcessingGuarantee(processingGuarantee);
    }

    @Override
    @Nonnull
    public TestProcessorContext setIsLightJob(boolean isLightJob) {
        return (TestProcessorContext)super.setIsLightJob(isLightJob);
    }

    @Override
    @Nonnull
    public TestProcessorContext setPartitionAssignment(Map<Address, int[]> partitionAssignment) {
        return (TestProcessorContext)super.setPartitionAssignment((Map)partitionAssignment);
    }

    @Override
    @Nonnull
    public TestProcessorContext setManagedContext(@Nonnull ManagedContext managedContext) {
        return (TestProcessorContext)super.setManagedContext(managedContext);
    }

    @Override
    protected String loggerName() {
        return this.vertexName() + "#" + this.globalProcessorIndex;
    }
}

