/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.io.github.classgraph;

import com.hazelcast.io.github.classgraph.ModuleRef;
import com.hazelcast.nonapi.io.github.classgraph.reflection.ReflectionUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

public class ModuleReaderProxy
implements Closeable {
    private final AutoCloseable moduleReader;
    private static Class<?> collectorClass = ReflectionUtils.classForNameOrNull("java.util.stream.Collector");
    private static Object collectorsToList;

    ModuleReaderProxy(ModuleRef moduleRef) throws IOException {
        try {
            this.moduleReader = (AutoCloseable)ReflectionUtils.invokeMethod(true, moduleRef.getReference(), "open");
            if (this.moduleReader == null) {
                throw new IllegalArgumentException("moduleReference.open() should not return null");
            }
        }
        catch (SecurityException e) {
            throw new IOException("Could not open module " + moduleRef.getName(), e);
        }
    }

    @Override
    public void close() {
        try {
            this.moduleReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<String> list() throws SecurityException {
        if (collectorsToList == null) {
            throw new IllegalArgumentException("Could not call Collectors.toList()");
        }
        Object resourcesStream = ReflectionUtils.invokeMethod(true, this.moduleReader, "list");
        if (resourcesStream == null) {
            throw new IllegalArgumentException("Could not call moduleReader.list()");
        }
        Object resourcesList = ReflectionUtils.invokeMethod(true, resourcesStream, "collect", collectorClass, collectorsToList);
        if (resourcesList == null) {
            throw new IllegalArgumentException("Could not call moduleReader.list().collect(Collectors.toList())");
        }
        List resourcesListTyped = (List)resourcesList;
        return resourcesListTyped;
    }

    public InputStream open(String path) throws SecurityException {
        Object optionalInputStream = ReflectionUtils.invokeMethod(true, this.moduleReader, "open", String.class, path);
        if (optionalInputStream == null) {
            throw new IllegalArgumentException("Got null result from ModuleReader#open for path " + path);
        }
        InputStream inputStream2 = (InputStream)ReflectionUtils.invokeMethod(true, optionalInputStream, "get");
        if (inputStream2 == null) {
            throw new IllegalArgumentException("Got null result from ModuleReader#open(String)#get()");
        }
        return inputStream2;
    }

    public ByteBuffer read(String path) throws SecurityException, OutOfMemoryError {
        Object optionalByteBuffer = ReflectionUtils.invokeMethod(true, this.moduleReader, "read", String.class, path);
        if (optionalByteBuffer == null) {
            throw new IllegalArgumentException("Got null result from ModuleReader#read(String)");
        }
        ByteBuffer byteBuffer = (ByteBuffer)ReflectionUtils.invokeMethod(true, optionalByteBuffer, "get");
        if (byteBuffer == null) {
            throw new IllegalArgumentException("Got null result from ModuleReader#read(String).get()");
        }
        return byteBuffer;
    }

    public void release(ByteBuffer byteBuffer) {
        ReflectionUtils.invokeMethod(true, this.moduleReader, "release", ByteBuffer.class, byteBuffer);
    }

    static {
        Class<?> collectorsClass = ReflectionUtils.classForNameOrNull("java.util.stream.Collectors");
        if (collectorsClass != null) {
            collectorsToList = ReflectionUtils.invokeStaticMethod(true, collectorsClass, "toList");
        }
    }
}

