/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.executor;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;

public class LoggingScheduledExecutor
extends ScheduledThreadPoolExecutor {
    private final ILogger logger;
    private volatile boolean shutdownInitiated;

    public LoggingScheduledExecutor(ILogger logger2, int corePoolSize, ThreadFactory threadFactory2) {
        super(corePoolSize, threadFactory2);
        this.logger = Preconditions.checkNotNull(logger2, "logger cannot be null");
        this.setRemoveOnCancelPolicy(true);
    }

    public LoggingScheduledExecutor(ILogger logger2, int corePoolSize, ThreadFactory threadFactory2, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory2, handler);
        this.logger = Preconditions.checkNotNull(logger2, "logger cannot be null");
        this.setRemoveOnCancelPolicy(true);
    }

    @Override
    protected void afterExecute(Runnable runnable2, Throwable throwable) {
        super.afterExecute(runnable2, throwable);
        Level level = Level.FINE;
        if (throwable == null && runnable2 instanceof ScheduledFuture && ((ScheduledFuture)((Object)runnable2)).isDone()) {
            try {
                ((Future)((Object)runnable2)).get();
            }
            catch (CancellationException ce) {
                throwable = ce;
            }
            catch (ExecutionException ee) {
                level = Level.SEVERE;
                throwable = ee.getCause();
            }
            catch (InterruptedException ie) {
                throwable = ie;
                Thread.currentThread().interrupt();
            }
        }
        if (throwable instanceof RejectedExecutionException && this.shutdownInitiated) {
            level = Level.FINE;
        }
        if (throwable != null) {
            this.logger.log(level, "Failed to execute " + runnable2, throwable);
        }
    }

    public void notifyShutdownInitiated() {
        this.shutdownInitiated = true;
    }
}

