/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.nio.InstanceCreationUtil;
import com.hazelcast.internal.serialization.impl.compact.CompactStreamSerializer;
import com.hazelcast.internal.serialization.impl.compact.CompactUtil;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactReader;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.zeroconfig.ValueReaderWriter;
import com.hazelcast.internal.serialization.impl.compact.zeroconfig.ValueReaderWriters;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.compact.CompactReader;
import com.hazelcast.nio.serialization.compact.CompactSerializer;
import com.hazelcast.nio.serialization.compact.CompactWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ReflectiveCompactSerializer<T>
implements CompactSerializer<T> {
    private final Map<Class, ReaderWriter[]> readerWritersCache = new ConcurrentHashMap<Class, ReaderWriter[]>();
    private final CompactStreamSerializer compactStreamSerializer;

    public ReflectiveCompactSerializer(CompactStreamSerializer compactStreamSerializer) {
        this.compactStreamSerializer = compactStreamSerializer;
    }

    @Override
    public void write(@Nonnull CompactWriter writer, @Nonnull T object) {
        Class<?> clazz = object.getClass();
        if (this.writeFast(clazz, writer, object)) {
            return;
        }
        this.createFastReadWriteCaches(clazz);
        this.writeFast(clazz, writer, object);
    }

    @Override
    @Nonnull
    public String getTypeName() {
        throw new IllegalStateException("getTypeName should not be called for the reflective serializer");
    }

    @Override
    @Nonnull
    public Class<T> getCompactClass() {
        throw new IllegalStateException("getCompactClass should not be called for the reflective serializer");
    }

    private boolean writeFast(Class clazz, CompactWriter compactWriter, Object object) {
        ReaderWriter[] readerWriters = this.readerWritersCache.get(clazz);
        if (readerWriters == null) {
            return false;
        }
        for (ReaderWriter readerWriter : readerWriters) {
            try {
                readerWriter.write(compactWriter, object);
            }
            catch (Exception e) {
                throw new HazelcastSerializationException(e);
            }
        }
        return true;
    }

    private boolean readFast(Class clazz, DefaultCompactReader compactReader, Object object) {
        ReaderWriter[] readerWriters = this.readerWritersCache.get(clazz);
        if (readerWriters == null) {
            return false;
        }
        Schema schema = compactReader.getSchema();
        for (ReaderWriter readerWriter : readerWriters) {
            try {
                readerWriter.read(compactReader, schema, object);
            }
            catch (Exception e) {
                throw new HazelcastSerializationException(e);
            }
        }
        return true;
    }

    @Override
    @Nonnull
    public T read(@Nonnull CompactReader reader) {
        Object object;
        DefaultCompactReader compactReader = (DefaultCompactReader)reader;
        Class associatedClass = Objects.requireNonNull(compactReader.getAssociatedClass(), "AssociatedClass is required for ReflectiveCompactSerializer");
        if (this.readFast(associatedClass, compactReader, object = this.createObject(associatedClass))) {
            return (T)object;
        }
        this.createFastReadWriteCaches(associatedClass);
        this.readFast(associatedClass, compactReader, object);
        return (T)object;
    }

    @Nonnull
    private Object createObject(Class associatedClass) {
        try {
            return InstanceCreationUtil.createNewInstance(associatedClass);
        }
        catch (Exception e) {
            throw new HazelcastSerializationException("Could not construct the class " + associatedClass, e);
        }
    }

    private static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.stream(type.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).filter(f -> !Modifier.isTransient(f.getModifiers())).collect(Collectors.toList()));
        if (type.getSuperclass() != null && type.getSuperclass() != Object.class) {
            ReflectiveCompactSerializer.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    private void createFastReadWriteCaches(Class clazz) {
        CompactUtil.verifyClassIsCompactSerializable(clazz);
        List<Field> allFields = ReflectiveCompactSerializer.getAllFields(new LinkedList<Field>(), clazz);
        ReaderWriter[] readerWriters = new ReaderWriter[allFields.size()];
        int index = 0;
        for (final Field field : allFields) {
            field.setAccessible(true);
            Class<?> type = field.getType();
            final String name = field.getName();
            readerWriters[index] = Byte.TYPE.equals(type) ? new ReaderWriter(){

                @Override
                public void read(CompactReader reader, Schema schema, Object o) throws Exception {
                    if (CompactUtil.isFieldExist(schema, name, FieldKind.INT8, FieldKind.NULLABLE_INT8)) {
                        field.setByte(o, reader.readInt8(name));
                    }
                }

                @Override
                public void write(CompactWriter writer, Object o) throws Exception {
                    writer.writeInt8(name, field.getByte(o));
                }
            } : (Character.TYPE.equals(type) ? new ReaderWriter(){

                @Override
                public void read(CompactReader reader, Schema schema, Object o) throws Exception {
                    if (CompactUtil.isFieldExist(schema, name, FieldKind.INT16, FieldKind.NULLABLE_INT16)) {
                        field.setChar(o, (char)reader.readInt16(name));
                    }
                }

                @Override
                public void write(CompactWriter writer, Object o) throws Exception {
                    writer.writeInt16(name, (short)field.getChar(o));
                }
            } : (Short.TYPE.equals(type) ? new ReaderWriter(){

                @Override
                public void read(CompactReader reader, Schema schema, Object o) throws Exception {
                    if (CompactUtil.isFieldExist(schema, name, FieldKind.INT16, FieldKind.NULLABLE_INT16)) {
                        field.setShort(o, reader.readInt16(name));
                    }
                }

                @Override
                public void write(CompactWriter writer, Object o) throws Exception {
                    writer.writeInt16(name, field.getShort(o));
                }
            } : (Integer.TYPE.equals(type) ? new ReaderWriter(){

                @Override
                public void read(CompactReader reader, Schema schema, Object o) throws Exception {
                    if (CompactUtil.isFieldExist(schema, name, FieldKind.INT32, FieldKind.NULLABLE_INT32)) {
                        field.setInt(o, reader.readInt32(name));
                    }
                }

                @Override
                public void write(CompactWriter writer, Object o) throws Exception {
                    writer.writeInt32(name, field.getInt(o));
                }
            } : (Long.TYPE.equals(type) ? new ReaderWriter(){

                @Override
                public void read(CompactReader reader, Schema schema, Object o) throws Exception {
                    if (CompactUtil.isFieldExist(schema, name, FieldKind.INT64, FieldKind.NULLABLE_INT64)) {
                        field.setLong(o, reader.readInt64(name));
                    }
                }

                @Override
                public void write(CompactWriter writer, Object o) throws Exception {
                    writer.writeInt64(name, field.getLong(o));
                }
            } : (Float.TYPE.equals(type) ? new ReaderWriter(){

                @Override
                public void read(CompactReader reader, Schema schema, Object o) throws Exception {
                    if (CompactUtil.isFieldExist(schema, name, FieldKind.FLOAT32, FieldKind.NULLABLE_FLOAT32)) {
                        field.setFloat(o, reader.readFloat32(name));
                    }
                }

                @Override
                public void write(CompactWriter writer, Object o) throws Exception {
                    writer.writeFloat32(name, field.getFloat(o));
                }
            } : (Double.TYPE.equals(type) ? new ReaderWriter(){

                @Override
                public void read(CompactReader reader, Schema schema, Object o) throws Exception {
                    if (CompactUtil.isFieldExist(schema, name, FieldKind.FLOAT64, FieldKind.NULLABLE_FLOAT64)) {
                        field.setDouble(o, reader.readFloat64(name));
                    }
                }

                @Override
                public void write(CompactWriter writer, Object o) throws Exception {
                    writer.writeFloat64(name, field.getDouble(o));
                }
            } : (Boolean.TYPE.equals(type) ? new ReaderWriter(){

                @Override
                public void read(CompactReader reader, Schema schema, Object o) throws Exception {
                    if (CompactUtil.isFieldExist(schema, name, FieldKind.BOOLEAN, FieldKind.NULLABLE_BOOLEAN)) {
                        field.setBoolean(o, reader.readBoolean(name));
                    }
                }

                @Override
                public void write(CompactWriter writer, Object o) throws Exception {
                    writer.writeBoolean(name, field.getBoolean(o));
                }
            } : new ReaderWriterAdapter(ValueReaderWriters.readerWriterFor(this.compactStreamSerializer, clazz, type, field.getGenericType(), name), field))))))));
            ++index;
        }
        this.readerWritersCache.put(clazz, readerWriters);
    }

    private static interface ReaderWriter {
        public void read(CompactReader var1, Schema var2, Object var3) throws Exception;

        public void write(CompactWriter var1, Object var2) throws Exception;
    }

    private static final class ReaderWriterAdapter
    implements ReaderWriter {
        private final ValueReaderWriter readerWriter;
        private final Field field;

        ReaderWriterAdapter(ValueReaderWriter readerWriter, Field field) {
            this.readerWriter = readerWriter;
            this.field = field;
        }

        @Override
        public void read(CompactReader reader, Schema schema, Object o) throws Exception {
            this.field.set(o, this.readerWriter.read(reader, schema));
        }

        @Override
        public void write(CompactWriter writer, Object o) throws Exception {
            this.readerWriter.write(writer, this.field.get(o));
        }
    }
}

