/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.VersionAwareConstructorFunction;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.VersionedDataSerializableFactory;
import com.hazelcast.version.Version;

public final class ArrayDataSerializableFactory
implements VersionedDataSerializableFactory {
    private final ConstructorFunction<Integer, IdentifiedDataSerializable>[] constructors;
    private final int len;

    public ArrayDataSerializableFactory(ConstructorFunction<Integer, IdentifiedDataSerializable>[] ctorArray) {
        if (ctorArray == null || ctorArray.length <= 0) {
            throw new IllegalArgumentException("ConstructorFunction array cannot be null");
        }
        this.len = ctorArray.length;
        this.constructors = new ConstructorFunction[this.len];
        System.arraycopy(ctorArray, 0, this.constructors, 0, this.len);
    }

    @Override
    public IdentifiedDataSerializable create(int typeId) {
        if (typeId >= 0 && typeId < this.len) {
            ConstructorFunction<Integer, IdentifiedDataSerializable> factory2 = this.constructors[typeId];
            return factory2 != null ? factory2.createNew(typeId) : null;
        }
        return null;
    }

    @Override
    public IdentifiedDataSerializable create(int typeId, Version clusterVersion, Version wanProtocolVersion) {
        if (typeId >= 0 && typeId < this.len) {
            ConstructorFunction<Integer, IdentifiedDataSerializable> factory2 = this.constructors[typeId];
            if (factory2 == null) {
                return null;
            }
            if (factory2 instanceof VersionAwareConstructorFunction) {
                return (IdentifiedDataSerializable)((VersionAwareConstructorFunction)factory2).createNew(typeId, clusterVersion, wanProtocolVersion);
            }
            return factory2.createNew(typeId);
        }
        return null;
    }
}

