/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.config.CompactSerializationConfig;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InputOutputFactory;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.serialization.impl.SerializerAdapter;
import com.hazelcast.internal.serialization.impl.bufferpool.BufferPool;
import com.hazelcast.internal.serialization.impl.bufferpool.BufferPoolFactory;
import com.hazelcast.internal.serialization.impl.bufferpool.BufferPoolFactoryImpl;
import com.hazelcast.internal.serialization.impl.bufferpool.BufferPoolThreadLocal;
import com.hazelcast.internal.serialization.impl.compact.CompactGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactStreamSerializer;
import com.hazelcast.internal.serialization.impl.compact.CompactStreamSerializerAdapter;
import com.hazelcast.internal.serialization.impl.compact.CompactWithSchemaStreamSerializerAdapter;
import com.hazelcast.internal.serialization.impl.compact.SchemaService;
import com.hazelcast.internal.serialization.impl.defaultserializers.ConstantSerializers;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecord;
import com.hazelcast.internal.usercodedeployment.impl.ClassLocator;
import com.hazelcast.internal.util.ConcurrentReferenceHashMap;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.partition.PartitioningStrategy;
import java.io.Externalizable;
import java.io.Serializable;
import java.nio.ByteOrder;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public abstract class AbstractSerializationService
implements InternalSerializationService {
    protected final ManagedContext managedContext;
    protected final InputOutputFactory inputOutputFactory;
    protected final PartitioningStrategy globalPartitioningStrategy;
    protected final Supplier<RuntimeException> notActiveExceptionSupplier;
    protected final BufferPoolThreadLocal bufferPoolThreadLocal;
    protected SerializerAdapter dataSerializerAdapter;
    protected SerializerAdapter portableSerializerAdapter;
    protected final SerializerAdapter nullSerializerAdapter;
    protected SerializerAdapter javaSerializerAdapter;
    protected SerializerAdapter javaExternalizableAdapter;
    protected SerializerAdapter compactSerializerAdapter;
    protected CompactStreamSerializer compactStreamSerializer;
    protected CompactWithSchemaStreamSerializerAdapter compactWithSchemaSerializerAdapter;
    private final IdentityHashMap<Class, SerializerAdapter> constantTypesMap;
    private final SerializerAdapter[] constantTypeIds;
    private final ConcurrentMap<Class, SerializerAdapter> typeMap = new ConcurrentReferenceHashMap<Class, SerializerAdapter>(ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.STRONG);
    private final ConcurrentMap<Integer, SerializerAdapter> idMap = new ConcurrentHashMap<Integer, SerializerAdapter>();
    private final AtomicReference<SerializerAdapter> global = new AtomicReference();
    private boolean overrideJavaSerialization;
    private final ClassLoader classLoader;
    private final int outputBufferSize;
    private volatile boolean active = true;
    private final byte version;
    private final ILogger logger = Logger.getLogger(InternalSerializationService.class);
    private boolean isCompatibility;
    private final boolean allowOverrideDefaultSerializers;

    AbstractSerializationService(Builder<?> builder) {
        this.inputOutputFactory = ((Builder)builder).inputOutputFactory;
        this.version = ((Builder)builder).version;
        this.classLoader = ((Builder)builder).classLoader;
        this.managedContext = ((Builder)builder).managedContext;
        this.globalPartitioningStrategy = ((Builder)builder).globalPartitionStrategy;
        this.outputBufferSize = ((Builder)builder).initialOutputBufferSize;
        this.notActiveExceptionSupplier = ((Builder)builder).notActiveExceptionSupplier;
        this.bufferPoolThreadLocal = new BufferPoolThreadLocal(this, ((Builder)builder).bufferPoolFactory, ((Builder)builder).notActiveExceptionSupplier);
        this.nullSerializerAdapter = SerializationUtil.createSerializerAdapter(new ConstantSerializers.NullSerializer());
        this.constantTypesMap = new IdentityHashMap(((Builder)builder).isCompatibility ? 28 : 57);
        this.constantTypeIds = new SerializerAdapter[((Builder)builder).isCompatibility ? 28 : 57];
        this.isCompatibility = ((Builder)builder).isCompatibility;
        this.allowOverrideDefaultSerializers = ((Builder)builder).allowOverrideDefaultSerializers;
        CompactSerializationConfig compactSerializationCfg = ((Builder)builder).compactSerializationConfig == null ? new CompactSerializationConfig() : ((Builder)builder).compactSerializationConfig;
        this.compactStreamSerializer = new CompactStreamSerializer(this, compactSerializationCfg, this.managedContext, ((Builder)builder).schemaService, this.classLoader);
        this.compactWithSchemaSerializerAdapter = new CompactWithSchemaStreamSerializerAdapter(this.compactStreamSerializer);
        this.compactSerializerAdapter = new CompactStreamSerializerAdapter(this.compactStreamSerializer);
    }

    protected AbstractSerializationService(AbstractSerializationService prototype) {
        this.inputOutputFactory = prototype.inputOutputFactory;
        this.version = prototype.version;
        this.classLoader = prototype.classLoader;
        this.managedContext = prototype.managedContext;
        this.globalPartitioningStrategy = prototype.globalPartitioningStrategy;
        this.outputBufferSize = prototype.outputBufferSize;
        this.notActiveExceptionSupplier = prototype.notActiveExceptionSupplier;
        this.bufferPoolThreadLocal = new BufferPoolThreadLocal(this, new BufferPoolFactoryImpl(), prototype.notActiveExceptionSupplier);
        this.nullSerializerAdapter = prototype.nullSerializerAdapter;
        this.constantTypesMap = new IdentityHashMap(prototype.constantTypesMap.size());
        this.constantTypeIds = new SerializerAdapter[prototype.constantTypeIds.length];
        this.allowOverrideDefaultSerializers = prototype.allowOverrideDefaultSerializers;
        this.compactStreamSerializer = prototype.compactStreamSerializer;
        this.compactWithSchemaSerializerAdapter = prototype.compactWithSchemaSerializerAdapter;
        this.compactSerializerAdapter = prototype.compactSerializerAdapter;
    }

    @Override
    public final <B extends Data> B toData(Object obj) {
        return this.toData(obj, this.globalPartitioningStrategy);
    }

    @Override
    public final <B extends Data> B toDataWithSchema(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Data) {
            Data data = (Data)obj;
            if (data.getType() == -56) {
                return (B)data;
            }
            obj = this.toObject(data);
        }
        byte[] bytes = this.toBytes(obj, 0, true, this.globalPartitioningStrategy, ByteOrder.BIG_ENDIAN, true);
        return (B)new HeapData(bytes);
    }

    @Override
    public <B extends Data> B trimSchema(Data data) {
        if (data == null) {
            return null;
        }
        if (data.getType() != -56) {
            return (B)data;
        }
        Object obj = this.toObject(data);
        return this.toData(obj);
    }

    @Override
    public final <B extends Data> B toData(Object obj, PartitioningStrategy strategy) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Data) {
            return (B)((Data)obj);
        }
        byte[] bytes = this.toBytes(obj, 0, true, strategy);
        return (B)new HeapData(bytes);
    }

    @Override
    public byte[] toBytes(Object obj) {
        return this.toBytes(obj, 0, true, this.globalPartitioningStrategy);
    }

    @Override
    public byte[] toBytes(Object obj, int leftPadding, boolean insertPartitionHash) {
        return this.toBytes(obj, leftPadding, insertPartitionHash, this.globalPartitioningStrategy, this.getByteOrder(), false);
    }

    private byte[] toBytes(Object obj, int leftPadding, boolean writeHash, PartitioningStrategy strategy) {
        return this.toBytes(obj, leftPadding, writeHash, strategy, ByteOrder.BIG_ENDIAN, false);
    }

    private byte[] toBytes(Object obj, int leftPadding, boolean writeHash, PartitioningStrategy strategy, ByteOrder serializerTypeIdByteOrder, boolean includeSchema) {
        Preconditions.checkNotNull(obj);
        Preconditions.checkNotNull(serializerTypeIdByteOrder);
        BufferPool pool = this.bufferPoolThreadLocal.get();
        BufferObjectDataOutput out = pool.takeOutputBuffer();
        try {
            out.position(leftPadding);
            SerializerAdapter serializer = this.serializerFor(obj, includeSchema);
            if (writeHash) {
                int partitionHash = this.calculatePartitionHash(obj, strategy);
                out.writeInt(partitionHash, ByteOrder.BIG_ENDIAN);
            }
            out.writeInt(serializer.getTypeId(), serializerTypeIdByteOrder);
            serializer.write(out, obj);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Throwable e) {
            throw SerializationUtil.handleSerializeException(obj, e);
        }
        finally {
            pool.returnOutputBuffer(out);
        }
    }

    @Override
    public final <T> T toObject(Object object) {
        if (!(object instanceof Data)) {
            return (T)object;
        }
        Data data = (Data)object;
        if (SerializationUtil.isNullData(data)) {
            return null;
        }
        int typeId = data.getType();
        SerializerAdapter serializer = this.serializerFor(typeId);
        if (serializer == null) {
            if (this.active) {
                throw AbstractSerializationService.newHazelcastSerializationException(typeId);
            }
            throw this.notActiveExceptionSupplier.get();
        }
        Object obj = null;
        BufferPool pool = this.bufferPoolThreadLocal.get();
        BufferObjectDataInput in = pool.takeInputBuffer(data);
        try {
            ClassLocator.onStartDeserialization();
            obj = serializer.read(in);
            if (this.managedContext != null) {
                obj = this.managedContext.initialize(obj);
            }
            Object object2 = obj;
            return (T)object2;
        }
        catch (Throwable e) {
            throw SerializationUtil.handleException(e);
        }
        finally {
            ClassLocator.onFinishDeserialization();
            pool.returnInputBuffer(in);
        }
    }

    @Override
    public final <T> T toObject(Object object, Class aClass) {
        if (!(object instanceof Data)) {
            return (T)object;
        }
        Data data = (Data)object;
        if (SerializationUtil.isNullData(data)) {
            return null;
        }
        BufferPool pool = this.bufferPoolThreadLocal.get();
        BufferObjectDataInput in = pool.takeInputBuffer(data);
        try {
            ClassLocator.onStartDeserialization();
            int typeId = data.getType();
            SerializerAdapter serializer = this.serializerFor(typeId);
            if (serializer == null) {
                if (this.active) {
                    throw AbstractSerializationService.newHazelcastSerializationException(typeId);
                }
                throw this.notActiveExceptionSupplier.get();
            }
            Object obj = serializer.read(in, aClass);
            if (this.managedContext != null) {
                obj = this.managedContext.initialize(obj);
            }
            Object object2 = obj;
            return (T)object2;
        }
        catch (Throwable e) {
            throw SerializationUtil.handleException(e);
        }
        finally {
            ClassLocator.onFinishDeserialization();
            pool.returnInputBuffer(in);
        }
    }

    private static HazelcastSerializationException newHazelcastSerializationException(int typeId) {
        return new HazelcastSerializationException("There is no suitable de-serializer for type " + typeId + ". This exception is likely caused by differences in the serialization configuration between members or between clients and members.");
    }

    @Override
    public final void writeObject(ObjectDataOutput out, Object obj) {
        if (obj instanceof Data) {
            throw new HazelcastSerializationException("Cannot write a Data instance, use writeData() instead");
        }
        SerializerAdapter serializer = this.serializerFor(obj, false);
        try {
            out.writeInt(serializer.getTypeId());
            serializer.write(out, obj);
        }
        catch (Throwable e) {
            throw SerializationUtil.handleSerializeException(obj, e);
        }
    }

    @Override
    public final <T> T readObject(ObjectDataInput in) {
        try {
            int typeId = in.readInt();
            SerializerAdapter serializer = this.serializerFor(typeId);
            if (serializer == null) {
                if (this.active) {
                    throw AbstractSerializationService.newHazelcastSerializationException(typeId);
                }
                throw this.notActiveExceptionSupplier.get();
            }
            Object obj = serializer.read(in);
            if (this.managedContext != null) {
                obj = this.managedContext.initialize(obj);
            }
            return (T)obj;
        }
        catch (Throwable e) {
            throw SerializationUtil.handleException(e);
        }
    }

    @Override
    public final <T> T readObject(ObjectDataInput in, Class aClass) {
        try {
            int typeId = in.readInt();
            SerializerAdapter serializer = this.serializerFor(typeId);
            if (serializer == null) {
                if (this.active) {
                    throw AbstractSerializationService.newHazelcastSerializationException(typeId);
                }
                throw this.notActiveExceptionSupplier.get();
            }
            Object obj = serializer.read(in, aClass);
            if (this.managedContext != null) {
                obj = this.managedContext.initialize(obj);
            }
            return (T)obj;
        }
        catch (Throwable e) {
            throw SerializationUtil.handleException(e);
        }
    }

    @Override
    public void disposeData(Data data) {
    }

    @Override
    public final BufferObjectDataInput createObjectDataInput(byte[] data) {
        return this.inputOutputFactory.createInput(data, (InternalSerializationService)this, this.isCompatibility);
    }

    @Override
    public final BufferObjectDataInput createObjectDataInput(byte[] data, int offset) {
        return this.inputOutputFactory.createInput(data, offset, this, this.isCompatibility);
    }

    @Override
    public final BufferObjectDataInput createObjectDataInput(Data data) {
        return this.inputOutputFactory.createInput(data, (InternalSerializationService)this, this.isCompatibility);
    }

    @Override
    public final BufferObjectDataOutput createObjectDataOutput(int size) {
        return this.inputOutputFactory.createOutput(size, this);
    }

    @Override
    public BufferObjectDataOutput createObjectDataOutput(int initialSize, int firstGrowthSize) {
        return this.inputOutputFactory.createOutput(initialSize, firstGrowthSize, this);
    }

    @Override
    public BufferObjectDataOutput createObjectDataOutput() {
        return this.inputOutputFactory.createOutput(this.outputBufferSize, this);
    }

    @Override
    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public final ManagedContext getManagedContext() {
        return this.managedContext;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.inputOutputFactory.getByteOrder();
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public void dispose() {
        this.active = false;
        for (SerializerAdapter serializer : this.typeMap.values()) {
            serializer.destroy();
        }
        for (SerializerAdapter serializer : this.constantTypesMap.values()) {
            serializer.destroy();
        }
        this.typeMap.clear();
        this.idMap.clear();
        this.global.set(null);
        this.constantTypesMap.clear();
        this.bufferPoolThreadLocal.clear();
    }

    public final void register(Class type, Serializer serializer) {
        if (type == null) {
            throw new IllegalArgumentException("type is required");
        }
        if (serializer.getTypeId() <= 0) {
            throw new IllegalArgumentException("Type ID must be positive. Current: " + serializer.getTypeId() + ", Serializer: " + serializer);
        }
        this.safeRegister(type, SerializationUtil.createSerializerAdapter(serializer));
    }

    public final void registerGlobal(Serializer serializer) {
        this.registerGlobal(serializer, false);
    }

    public final void registerGlobal(Serializer serializer, boolean overrideJavaSerialization) {
        SerializerAdapter adapter = SerializationUtil.createSerializerAdapter(serializer);
        if (!this.global.compareAndSet(null, adapter)) {
            throw new IllegalStateException("Global serializer is already registered");
        }
        this.overrideJavaSerialization = overrideJavaSerialization;
        SerializerAdapter current = this.idMap.putIfAbsent(serializer.getTypeId(), adapter);
        if (current != null && current.getImpl().getClass() != adapter.getImpl().getClass()) {
            this.global.compareAndSet(adapter, null);
            this.overrideJavaSerialization = false;
            throw new IllegalStateException("Serializer [" + current.getImpl() + "] has been already registered for type ID: " + serializer.getTypeId());
        }
    }

    protected final int calculatePartitionHash(Object obj, PartitioningStrategy strategy) {
        Object pk;
        PartitioningStrategy partitioningStrategy;
        int partitionHash = 0;
        PartitioningStrategy partitioningStrategy2 = partitioningStrategy = strategy == null ? this.globalPartitioningStrategy : strategy;
        if (partitioningStrategy != null && (pk = partitioningStrategy.getPartitionKey(obj)) != null && pk != obj) {
            Object partitionKey = this.toData(pk, SerializationUtil.EMPTY_PARTITIONING_STRATEGY);
            partitionHash = partitionKey == null ? 0 : partitionKey.getPartitionHash();
        }
        return partitionHash;
    }

    protected final boolean safeRegister(Class type, Serializer serializer) {
        return this.safeRegister(type, SerializationUtil.createSerializerAdapter(serializer));
    }

    protected final boolean safeRegister(Class type, SerializerAdapter serializer) {
        if (this.constantTypesMap.containsKey(type) && !this.allowOverrideDefaultSerializers) {
            throw new IllegalArgumentException("[" + type + "] serializer cannot be overridden. See documentation of Hazelcast serialization configuration  or setAllowOverrideDefaultSerializers method in SerializationConfig.");
        }
        SerializerAdapter current = this.typeMap.putIfAbsent(type, serializer);
        if (current != null && current.getImpl().getClass() != serializer.getImpl().getClass()) {
            throw new IllegalStateException("Serializer[" + current.getImpl() + "] has been already registered for type: " + type);
        }
        current = this.idMap.putIfAbsent(serializer.getTypeId(), serializer);
        if (current != null && current.getImpl().getClass() != serializer.getImpl().getClass()) {
            throw new IllegalStateException("Serializer [" + current.getImpl() + "] has been already registered for type ID: " + serializer.getTypeId());
        }
        return current == null;
    }

    protected final void registerConstant(Class type, Serializer serializer) {
        this.registerConstant(type, SerializationUtil.createSerializerAdapter(serializer));
    }

    protected final void registerConstant(Class type, SerializerAdapter serializer) {
        this.constantTypesMap.put(type, serializer);
        this.constantTypeIds[SerializationUtil.indexForDefaultType((int)serializer.getTypeId())] = serializer;
    }

    protected final void registerConstant(SerializerAdapter serializer) {
        this.constantTypeIds[SerializationUtil.indexForDefaultType((int)serializer.getTypeId())] = serializer;
    }

    private SerializerAdapter registerFromSuperType(Class type, Class superType) {
        SerializerAdapter serializer = (SerializerAdapter)this.typeMap.get(superType);
        if (serializer != null) {
            this.safeRegister(type, serializer);
        }
        return serializer;
    }

    public SerializerAdapter serializerFor(int typeId) {
        int index;
        if (typeId <= 0 && (index = SerializationUtil.indexForDefaultType(typeId)) < this.constantTypeIds.length) {
            return this.constantTypeIds[index];
        }
        return (SerializerAdapter)this.idMap.get(typeId);
    }

    public SerializerAdapter serializerFor(Object object, boolean includeSchema) {
        if (!this.active) {
            throw this.notActiveExceptionSupplier.get();
        }
        if (object == null) {
            return this.nullSerializerAdapter;
        }
        Class<?> type = object.getClass();
        return this.serializerForClass(type, includeSchema);
    }

    public SerializerAdapter serializerForClass(Class type, boolean includeSchema) {
        SerializerAdapter customSerializer;
        SerializerAdapter serializer = this.lookupDefaultSerializer(type, includeSchema);
        if ((serializer == null || this.allowOverrideDefaultSerializers) && (customSerializer = this.lookupCustomSerializer(type)) != null) {
            serializer = customSerializer;
        }
        if (serializer == null && !this.overrideJavaSerialization) {
            serializer = this.lookupJavaSerializer(type);
        }
        if (serializer == null) {
            serializer = this.lookupGlobalSerializer(type);
        }
        if (serializer == null) {
            serializer = this.getCompactSerializer(includeSchema);
        }
        if (serializer == null) {
            throw new HazelcastSerializationException("There is no suitable serializer for " + type);
        }
        return serializer;
    }

    private SerializerAdapter getCompactSerializer(boolean includeSchema) {
        return includeSchema ? this.compactWithSchemaSerializerAdapter : this.compactSerializerAdapter;
    }

    @Override
    public boolean isCompactSerializable(Object object) {
        return this.serializerFor(object, false) == this.compactSerializerAdapter;
    }

    private SerializerAdapter lookupDefaultSerializer(Class type, boolean includeSchema) {
        if (CompactGenericRecord.class.isAssignableFrom(type) || this.compactStreamSerializer.isRegisteredAsCompact(type)) {
            return this.getCompactSerializer(includeSchema);
        }
        if (DataSerializable.class.isAssignableFrom(type)) {
            return this.dataSerializerAdapter;
        }
        if (Portable.class.isAssignableFrom(type)) {
            return this.portableSerializerAdapter;
        }
        if (PortableGenericRecord.class.isAssignableFrom(type)) {
            return this.portableSerializerAdapter;
        }
        return this.constantTypesMap.get(type);
    }

    private SerializerAdapter lookupCustomSerializer(Class type) {
        SerializerAdapter serializer;
        block3: {
            Class typeInterface;
            serializer = (SerializerAdapter)this.typeMap.get(type);
            if (serializer != null) {
                return serializer;
            }
            LinkedHashSet<Class> interfaces = new LinkedHashSet<Class>(5);
            SerializationUtil.getInterfaces(type, interfaces);
            for (Class typeSuperclass = type.getSuperclass(); typeSuperclass != null && (serializer = this.registerFromSuperType(type, typeSuperclass)) == null; typeSuperclass = typeSuperclass.getSuperclass()) {
                SerializationUtil.getInterfaces(typeSuperclass, interfaces);
            }
            if (serializer != null) break block3;
            interfaces.remove(Serializable.class);
            interfaces.remove(Externalizable.class);
            Iterator iterator2 = interfaces.iterator();
            while (iterator2.hasNext() && (serializer = this.registerFromSuperType(type, typeInterface = (Class)iterator2.next())) == null) {
            }
        }
        return serializer;
    }

    private SerializerAdapter lookupGlobalSerializer(Class type) {
        SerializerAdapter serializer = this.global.get();
        if (serializer != null) {
            this.logger.fine("Registering global serializer for: " + type.getName());
            this.safeRegister(type, serializer);
        }
        return serializer;
    }

    private SerializerAdapter lookupJavaSerializer(Class type) {
        if (Externalizable.class.isAssignableFrom(type)) {
            if (this.safeRegister(type, this.javaExternalizableAdapter) && !Throwable.class.isAssignableFrom(type)) {
                this.logger.info("Performance Hint: Serialization service will use java.io.Externalizable for: " + type.getName() + ". Please consider using a faster serialization option such as DataSerializable.");
            }
            return this.javaExternalizableAdapter;
        }
        if (Serializable.class.isAssignableFrom(type)) {
            if (this.safeRegister(type, this.javaSerializerAdapter) && !Throwable.class.isAssignableFrom(type)) {
                this.logger.info("Performance Hint: Serialization service will use java.io.Serializable for: " + type.getName() + ". Please consider using a faster serialization option such as DataSerializable.");
            }
            return this.javaSerializerAdapter;
        }
        return null;
    }

    protected void verifyDefaultSerializersNotOverriddenWithCompact() {
        for (Class clazz : this.compactStreamSerializer.getCompactSerializableClasses()) {
            if (!this.constantTypesMap.containsKey(clazz)) continue;
            throw new IllegalArgumentException("Compact serializer for the class '" + clazz + " can not be registered as it overrides the default serializer for that class provided by Hazelcast.");
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private InputOutputFactory inputOutputFactory;
        private byte version;
        private ClassLoader classLoader;
        private ManagedContext managedContext;
        private PartitioningStrategy globalPartitionStrategy;
        private int initialOutputBufferSize;
        private BufferPoolFactory bufferPoolFactory;
        private Supplier<RuntimeException> notActiveExceptionSupplier;
        private boolean isCompatibility;
        private boolean allowOverrideDefaultSerializers;
        private CompactSerializationConfig compactSerializationConfig;
        private SchemaService schemaService;

        protected Builder() {
        }

        protected abstract T self();

        public final T withInputOutputFactory(InputOutputFactory inputOutputFactory) {
            this.inputOutputFactory = inputOutputFactory;
            return this.self();
        }

        public final T withVersion(byte version) {
            this.version = version;
            return this.self();
        }

        public final T withClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this.self();
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public final T withManagedContext(ManagedContext managedContext) {
            this.managedContext = managedContext;
            return this.self();
        }

        public final T withGlobalPartitionStrategy(PartitioningStrategy globalPartitionStrategy) {
            this.globalPartitionStrategy = globalPartitionStrategy;
            return this.self();
        }

        public final T withInitialOutputBufferSize(int initialOutputBufferSize) {
            this.initialOutputBufferSize = initialOutputBufferSize;
            return this.self();
        }

        public final T withBufferPoolFactory(BufferPoolFactory bufferPoolFactory) {
            this.bufferPoolFactory = bufferPoolFactory;
            return this.self();
        }

        public final T withNotActiveExceptionSupplier(Supplier<RuntimeException> notActiveExceptionSupplier) {
            this.notActiveExceptionSupplier = notActiveExceptionSupplier;
            return this.self();
        }

        public final T withCompatibility(boolean isCompatibility) {
            this.isCompatibility = isCompatibility;
            return this.self();
        }

        public boolean isCompatibility() {
            return this.isCompatibility;
        }

        public final T withAllowOverrideDefaultSerializers(boolean allowOverrideDefaultSerializers) {
            this.allowOverrideDefaultSerializers = allowOverrideDefaultSerializers;
            return this.self();
        }

        public final T withCompactSerializationConfig(CompactSerializationConfig compactSerializationConfig) {
            this.compactSerializationConfig = compactSerializationConfig;
            return this.self();
        }

        public final T withSchemaService(SchemaService schemaService) {
            this.schemaService = schemaService;
            return this.self();
        }
    }
}

