/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.partition.ChunkSerDeHelper;
import com.hazelcast.internal.partition.ChunkSupplier;
import com.hazelcast.internal.partition.impl.PartitionDataSerializerHook;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.TargetAware;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ReplicaFragmentMigrationState
implements IdentifiedDataSerializable,
TargetAware,
Versioned {
    private Map<ServiceNamespace, long[]> namespaces;
    private Collection<Operation> migrationOperations;
    private transient ChunkSerDeHelper chunkSerDeHelper;

    public ReplicaFragmentMigrationState() {
    }

    public ReplicaFragmentMigrationState(Map<ServiceNamespace, long[]> namespaces, Collection<Operation> migrationOperations, Collection<ChunkSupplier> chunkSuppliers, boolean chunkedMigrationEnabled, int maxTotalChunkedDataInBytes, ILogger logger2, int partitionId) {
        this.namespaces = namespaces;
        this.migrationOperations = migrationOperations;
        this.chunkSerDeHelper = new ChunkSerDeHelper(logger2, partitionId, chunkSuppliers, chunkedMigrationEnabled, maxTotalChunkedDataInBytes);
    }

    public Map<ServiceNamespace, long[]> getNamespaceVersionMap() {
        return this.namespaces;
    }

    public Collection<Operation> getMigrationOperations() {
        return this.migrationOperations;
    }

    @Override
    public int getFactoryId() {
        return PartitionDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 15;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.namespaces.size());
        for (Map.Entry<ServiceNamespace, long[]> e : this.namespaces.entrySet()) {
            out.writeObject(e.getKey());
            out.writeLongArray(e.getValue());
        }
        out.writeInt(this.migrationOperations.size());
        for (Operation operation : this.migrationOperations) {
            out.writeObject(operation);
        }
        this.chunkSerDeHelper.writeChunkedOperations(out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int namespaceSize = in.readInt();
        this.namespaces = new HashMap<ServiceNamespace, long[]>(namespaceSize);
        for (int i = 0; i < namespaceSize; ++i) {
            ServiceNamespace namespace = (ServiceNamespace)in.readObject();
            long[] replicaVersions = in.readLongArray();
            this.namespaces.put(namespace, replicaVersions);
        }
        int migrationOperationSize = in.readInt();
        this.migrationOperations = new ArrayList<Operation>(migrationOperationSize);
        for (int i = 0; i < migrationOperationSize; ++i) {
            Operation migrationOperation = (Operation)in.readObject();
            this.migrationOperations.add(migrationOperation);
        }
        this.migrationOperations = ChunkSerDeHelper.readChunkedOperations(in, this.migrationOperations);
    }

    @Override
    public void setTarget(Address address) {
        for (Operation op : this.migrationOperations) {
            if (!(op instanceof TargetAware)) continue;
            ((TargetAware)((Object)op)).setTarget(address);
        }
    }
}

