/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.DoubleProbeFunction;
import com.hazelcast.internal.metrics.LongGauge;
import com.hazelcast.internal.metrics.LongProbeFunction;
import com.hazelcast.internal.metrics.ProbeFunction;
import com.hazelcast.internal.metrics.impl.AbstractGauge;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.internal.metrics.impl.ProbeInstance;

class LongGaugeImpl
extends AbstractGauge
implements LongGauge {
    static final long DEFAULT_VALUE = 0L;
    private volatile LongGaugeSource gaugeSource;

    LongGaugeImpl(MetricsRegistryImpl metricsRegistry, String name) {
        super(metricsRegistry, name);
        ProbeInstance probeInstance = metricsRegistry.getProbeInstance(name);
        this.gaugeSource = probeInstance != null ? new ProbeInstanceGaugeSource(probeInstance) : new LongMetricValueCatcher();
    }

    @Override
    public long read() {
        return this.gaugeSource.read();
    }

    @Override
    LongMetricValueCatcher getCatcherOrNull() {
        LongGaugeSource gaugeSourceCopy = this.gaugeSource;
        return gaugeSourceCopy instanceof LongMetricValueCatcher ? (LongMetricValueCatcher)gaugeSourceCopy : null;
    }

    @Override
    public void render(StringBuilder stringBuilder) {
        stringBuilder.append(this.read());
    }

    @Override
    public void onProbeInstanceSet(ProbeInstance probeInstance) {
        this.gaugeSource = new ProbeInstanceGaugeSource(probeInstance);
    }

    private static long getMetricValue(String gaugeName, Object source2, ProbeFunction function, MetricsRegistryImpl metricsRegistry) {
        try {
            if (function instanceof LongProbeFunction) {
                LongProbeFunction longFunction = (LongProbeFunction)function;
                return longFunction.get(source2);
            }
            DoubleProbeFunction doubleFunction = (DoubleProbeFunction)function;
            double doubleResult = doubleFunction.get(source2);
            return Math.round(doubleResult);
        }
        catch (Exception e) {
            metricsRegistry.logger.warning("Failed to access the probe: " + gaugeName, e);
            return 0L;
        }
    }

    private final class ProbeInstanceGaugeSource
    implements LongGaugeSource {
        private volatile ProbeInstance probeInstance;

        private ProbeInstanceGaugeSource(ProbeInstance probeInstance) {
            this.probeInstance = probeInstance;
        }

        @Override
        public long read() {
            ProbeFunction function = null;
            Object source2 = null;
            if (this.probeInstance != null) {
                function = this.probeInstance.function;
                source2 = this.probeInstance.source;
            }
            if (function == null || source2 == null) {
                this.probeInstance = null;
                return 0L;
            }
            return LongGaugeImpl.getMetricValue(LongGaugeImpl.this.name, source2, function, LongGaugeImpl.this.metricsRegistry);
        }
    }

    private final class LongMetricValueCatcher
    extends AbstractGauge.AbstractMetricValueCatcher
    implements LongGaugeSource {
        private volatile long value = 0L;

        private LongMetricValueCatcher() {
        }

        @Override
        public void catchMetricValue(long collectionId, long value) {
            LongGaugeImpl.this.lastCollectionId = collectionId;
            this.value = value;
            this.clearCachedMetricSourceRef();
        }

        @Override
        public void catchMetricValue(long collectionId, double value) {
            LongGaugeImpl.this.lastCollectionId = collectionId;
            this.value = Math.round(value);
            this.clearCachedMetricSourceRef();
        }

        @Override
        public long read() {
            return this.readBase((x$0, x$1, x$2, x$3) -> LongGaugeImpl.getMetricValue(x$0, x$1, x$2, x$3), () -> this.value);
        }

        @Override
        void clearCachedValue() {
            this.value = 0L;
        }
    }

    private static interface LongGaugeSource {
        public long read();
    }
}

