/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig;

import com.hazelcast.config.AliasedDiscoveryConfig;
import com.hazelcast.config.AttributeConfig;
import com.hazelcast.config.CachePartitionLostListenerConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.config.CollectionConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.ConfigXmlGenerator;
import com.hazelcast.config.DataPersistenceConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.DiskTierConfig;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.ExternalDataStoreConfig;
import com.hazelcast.config.FlakeIdGeneratorConfig;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapPartitionLostListenerConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MemoryTierConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.PNCounterConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.RingbufferStoreConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.TieredStoreConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.config.WanCustomPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.WanSyncConfig;
import com.hazelcast.internal.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.internal.config.ConfigSections;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.memory.Capacity;
import com.hazelcast.query.impl.IndexUtils;
import java.util.Collection;
import java.util.List;

public final class DynamicConfigXmlGenerator {
    private DynamicConfigXmlGenerator() {
    }

    public static void licenseKeyXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        gen.node(ConfigSections.LICENSE_KEY.getName(), config.getLicenseKey(), new Object[0]);
    }

    public static void mapXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        Collection<MapConfig> mapConfigs = config.getMapConfigs().values();
        for (MapConfig m3 : mapConfigs) {
            String cacheDeserializedVal = m3.getCacheDeserializedValues() != null ? m3.getCacheDeserializedValues().name().replaceAll("_", "-") : null;
            MergePolicyConfig mergePolicyConfig = m3.getMergePolicyConfig();
            gen.open("map", "name", m3.getName()).node("in-memory-format", (Object)m3.getInMemoryFormat(), new Object[0]).node("statistics-enabled", m3.isStatisticsEnabled(), new Object[0]).node("per-entry-stats-enabled", m3.isPerEntryStatsEnabled(), new Object[0]).node("cache-deserialized-values", cacheDeserializedVal, new Object[0]).node("backup-count", m3.getBackupCount(), new Object[0]).node("async-backup-count", m3.getAsyncBackupCount(), new Object[0]).node("time-to-live-seconds", m3.getTimeToLiveSeconds(), new Object[0]).node("max-idle-seconds", m3.getMaxIdleSeconds(), new Object[0]).node("merge-policy", mergePolicyConfig.getPolicy(), "batch-size", mergePolicyConfig.getBatchSize()).node("split-brain-protection-ref", m3.getSplitBrainProtectionName(), new Object[0]).node("read-backup-data", m3.isReadBackupData(), new Object[0]).node("metadata-policy", (Object)m3.getMetadataPolicy(), new Object[0]);
            DynamicConfigXmlGenerator.evictionConfigXmlGenerator(gen, m3.getEvictionConfig());
            if (m3.getMerkleTreeConfig().getEnabled() != null) {
                DynamicConfigXmlGenerator.appendMerkleTreeConfig(gen, m3.getMerkleTreeConfig());
            }
            DynamicConfigXmlGenerator.appendEventJournalConfig(gen, m3.getEventJournalConfig());
            DynamicConfigXmlGenerator.appendDataPersistenceConfig(gen, m3.getDataPersistenceConfig());
            DynamicConfigXmlGenerator.mapStoreConfigXmlGenerator(gen, m3);
            DynamicConfigXmlGenerator.mapNearCacheConfigXmlGenerator(gen, m3.getNearCacheConfig());
            DynamicConfigXmlGenerator.wanReplicationConfigXmlGenerator(gen, m3.getWanReplicationRef());
            DynamicConfigXmlGenerator.indexConfigXmlGenerator(gen, m3);
            DynamicConfigXmlGenerator.attributeConfigXmlGenerator(gen, m3);
            DynamicConfigXmlGenerator.entryListenerConfigXmlGenerator(gen, m3);
            DynamicConfigXmlGenerator.mapPartitionLostListenerConfigXmlGenerator(gen, m3);
            DynamicConfigXmlGenerator.mapPartitionStrategyConfigXmlGenerator(gen, m3);
            DynamicConfigXmlGenerator.mapQueryCachesConfigXmlGenerator(gen, m3);
            DynamicConfigXmlGenerator.tieredStoreConfigXmlGenerator(gen, m3.getTieredStoreConfig());
            gen.close();
        }
    }

    public static void cacheXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        for (CacheSimpleConfig c : config.getCacheConfigs().values()) {
            gen.open("cache", "name", c.getName());
            if (c.getKeyType() != null) {
                gen.node("key-type", null, "class-name", c.getKeyType());
            }
            if (c.getValueType() != null) {
                gen.node("value-type", null, "class-name", c.getValueType());
            }
            gen.node("statistics-enabled", c.isStatisticsEnabled(), new Object[0]).node("management-enabled", c.isManagementEnabled(), new Object[0]).node("read-through", c.isReadThrough(), new Object[0]).node("write-through", c.isWriteThrough(), new Object[0]);
            DynamicConfigXmlGenerator.checkAndFillCacheLoaderFactoryConfigXml(gen, c.getCacheLoaderFactory());
            DynamicConfigXmlGenerator.checkAndFillCacheLoaderConfigXml(gen, c.getCacheLoader());
            DynamicConfigXmlGenerator.checkAndFillCacheWriterFactoryConfigXml(gen, c.getCacheWriterFactory());
            DynamicConfigXmlGenerator.checkAndFillCacheWriterConfigXml(gen, c.getCacheWriter());
            DynamicConfigXmlGenerator.cacheExpiryPolicyFactoryConfigXmlGenerator(gen, c.getExpiryPolicyFactoryConfig());
            gen.open("cache-entry-listeners", new Object[0]);
            for (CacheSimpleEntryListenerConfig el : c.getCacheEntryListeners()) {
                gen.open("cache-entry-listener", "old-value-required", el.isOldValueRequired(), "synchronous", el.isSynchronous()).node("cache-entry-listener-factory", null, "class-name", el.getCacheEntryListenerFactory()).node("cache-entry-event-filter-factory", null, "class-name", el.getCacheEntryEventFilterFactory()).close();
            }
            gen.close().node("in-memory-format", (Object)c.getInMemoryFormat(), new Object[0]).node("backup-count", c.getBackupCount(), new Object[0]).node("async-backup-count", c.getAsyncBackupCount(), new Object[0]);
            DynamicConfigXmlGenerator.evictionConfigXmlGenerator(gen, c.getEvictionConfig());
            DynamicConfigXmlGenerator.wanReplicationConfigXmlGenerator(gen, c.getWanReplicationRef());
            gen.node("split-brain-protection-ref", c.getSplitBrainProtectionName(), new Object[0]);
            DynamicConfigXmlGenerator.cachePartitionLostListenerConfigXmlGenerator(gen, c.getPartitionLostListenerConfigs());
            gen.node("merge-policy", c.getMergePolicyConfig().getPolicy(), "batch-size", c.getMergePolicyConfig().getBatchSize());
            DynamicConfigXmlGenerator.appendEventJournalConfig(gen, c.getEventJournalConfig());
            DynamicConfigXmlGenerator.appendDataPersistenceConfig(gen, c.getDataPersistenceConfig());
            if (c.getMerkleTreeConfig().getEnabled() != null) {
                DynamicConfigXmlGenerator.appendMerkleTreeConfig(gen, c.getMerkleTreeConfig());
            }
            gen.node("disable-per-entry-invalidation-events", c.isDisablePerEntryInvalidationEvents(), new Object[0]).close();
        }
    }

    public static void queueXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        Collection<QueueConfig> qCfgs = config.getQueueConfigs().values();
        for (QueueConfig q : qCfgs) {
            gen.open("queue", "name", q.getName()).node("priority-comparator-class-name", q.getPriorityComparatorClassName(), new Object[0]).node("statistics-enabled", q.isStatisticsEnabled(), new Object[0]).node("max-size", q.getMaxSize(), new Object[0]).node("backup-count", q.getBackupCount(), new Object[0]).node("async-backup-count", q.getAsyncBackupCount(), new Object[0]).node("empty-queue-ttl", q.getEmptyQueueTtl(), new Object[0]);
            DynamicConfigXmlGenerator.appendItemListenerConfigs(gen, q.getItemListenerConfigs());
            QueueStoreConfig storeConfig = q.getQueueStoreConfig();
            if (storeConfig != null) {
                gen.open("queue-store", "enabled", storeConfig.isEnabled()).node("class-name", DynamicConfigXmlGenerator.classNameOrImplClass(storeConfig.getClassName(), storeConfig.getStoreImplementation()), new Object[0]).node("factory-class-name", DynamicConfigXmlGenerator.classNameOrImplClass(storeConfig.getFactoryClassName(), storeConfig.getFactoryImplementation()), new Object[0]).appendProperties(storeConfig.getProperties()).close();
            }
            MergePolicyConfig mergePolicyConfig = q.getMergePolicyConfig();
            gen.node("split-brain-protection-ref", q.getSplitBrainProtectionName(), new Object[0]).node("merge-policy", mergePolicyConfig.getPolicy(), "batch-size", mergePolicyConfig.getBatchSize()).close();
        }
    }

    public static void listXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        DynamicConfigXmlGenerator.collectionXmlGenerator(gen, "list", config.getListConfigs().values());
    }

    public static void setXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        DynamicConfigXmlGenerator.collectionXmlGenerator(gen, "set", config.getSetConfigs().values());
    }

    public static void multiMapXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        for (MultiMapConfig mm3 : config.getMultiMapConfigs().values()) {
            gen.open("multimap", "name", mm3.getName()).node("backup-count", mm3.getBackupCount(), new Object[0]).node("async-backup-count", mm3.getAsyncBackupCount(), new Object[0]).node("statistics-enabled", mm3.isStatisticsEnabled(), new Object[0]).node("binary", mm3.isBinary(), new Object[0]).node("split-brain-protection-ref", mm3.getSplitBrainProtectionName(), new Object[0]).node("value-collection-type", (Object)mm3.getValueCollectionType(), new Object[0]);
            DynamicConfigXmlGenerator.entryListenerConfigXmlGenerator(gen, mm3.getEntryListenerConfigs());
            MergePolicyConfig mergePolicyConfig = mm3.getMergePolicyConfig();
            gen.node("merge-policy", mergePolicyConfig.getPolicy(), "batch-size", mergePolicyConfig.getBatchSize()).close();
        }
    }

    public static void replicatedMapXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        for (ReplicatedMapConfig r : config.getReplicatedMapConfigs().values()) {
            MergePolicyConfig mergePolicyConfig = r.getMergePolicyConfig();
            gen.open("replicatedmap", "name", r.getName()).node("in-memory-format", (Object)r.getInMemoryFormat(), new Object[0]).node("async-fillup", r.isAsyncFillup(), new Object[0]).node("statistics-enabled", r.isStatisticsEnabled(), new Object[0]).node("split-brain-protection-ref", r.getSplitBrainProtectionName(), new Object[0]).node("merge-policy", mergePolicyConfig.getPolicy(), "batch-size", mergePolicyConfig.getBatchSize());
            if (!r.getListenerConfigs().isEmpty()) {
                gen.open("entry-listeners", new Object[0]);
                for (ListenerConfig lc : r.getListenerConfigs()) {
                    gen.node("entry-listener", DynamicConfigXmlGenerator.classNameOrImplClass(lc.getClassName(), lc.getImplementation()), "include-value", lc.isIncludeValue(), "local", lc.isLocal());
                }
                gen.close();
            }
            gen.close();
        }
    }

    public static void ringbufferXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        Collection<RingbufferConfig> configs = config.getRingbufferConfigs().values();
        for (RingbufferConfig rbConfig : configs) {
            gen.open("ringbuffer", "name", rbConfig.getName()).node("capacity", rbConfig.getCapacity(), new Object[0]).node("time-to-live-seconds", rbConfig.getTimeToLiveSeconds(), new Object[0]).node("backup-count", rbConfig.getBackupCount(), new Object[0]).node("async-backup-count", rbConfig.getAsyncBackupCount(), new Object[0]).node("split-brain-protection-ref", rbConfig.getSplitBrainProtectionName(), new Object[0]).node("in-memory-format", (Object)rbConfig.getInMemoryFormat(), new Object[0]);
            RingbufferStoreConfig storeConfig = rbConfig.getRingbufferStoreConfig();
            if (storeConfig != null) {
                gen.open("ringbuffer-store", "enabled", storeConfig.isEnabled()).node("class-name", DynamicConfigXmlGenerator.classNameOrImplClass(storeConfig.getClassName(), storeConfig.getStoreImplementation()), new Object[0]).node("factory-class-name", DynamicConfigXmlGenerator.classNameOrImplClass(storeConfig.getFactoryClassName(), storeConfig.getFactoryImplementation()), new Object[0]).appendProperties(storeConfig.getProperties());
                gen.close();
            }
            MergePolicyConfig mergePolicyConfig = rbConfig.getMergePolicyConfig();
            gen.node("merge-policy", mergePolicyConfig.getPolicy(), "batch-size", mergePolicyConfig.getBatchSize()).close();
        }
    }

    public static void topicXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        for (TopicConfig t : config.getTopicConfigs().values()) {
            gen.open("topic", "name", t.getName()).node("statistics-enabled", t.isStatisticsEnabled(), new Object[0]).node("global-ordering-enabled", t.isGlobalOrderingEnabled(), new Object[0]);
            if (!t.getMessageListenerConfigs().isEmpty()) {
                gen.open("message-listeners", new Object[0]);
                for (ListenerConfig lc : t.getMessageListenerConfigs()) {
                    gen.node("message-listener", DynamicConfigXmlGenerator.classNameOrImplClass(lc.getClassName(), lc.getImplementation()), new Object[0]);
                }
                gen.close();
            }
            gen.node("multi-threading-enabled", t.isMultiThreadingEnabled(), new Object[0]);
            gen.close();
        }
    }

    public static void reliableTopicXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        for (ReliableTopicConfig t : config.getReliableTopicConfigs().values()) {
            gen.open("reliable-topic", "name", t.getName()).node("statistics-enabled", t.isStatisticsEnabled(), new Object[0]).node("read-batch-size", t.getReadBatchSize(), new Object[0]).node("topic-overload-policy", (Object)t.getTopicOverloadPolicy(), new Object[0]);
            if (!t.getMessageListenerConfigs().isEmpty()) {
                gen.open("message-listeners", new Object[0]);
                for (ListenerConfig lc : t.getMessageListenerConfigs()) {
                    gen.node("message-listener", DynamicConfigXmlGenerator.classNameOrImplClass(lc.getClassName(), lc.getImplementation()), new Object[0]);
                }
                gen.close();
            }
            gen.close();
        }
    }

    public static void executorXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        for (ExecutorConfig ex : config.getExecutorConfigs().values()) {
            gen.open("executor-service", "name", ex.getName()).node("statistics-enabled", ex.isStatisticsEnabled(), new Object[0]).node("pool-size", ex.getPoolSize(), new Object[0]).node("queue-capacity", ex.getQueueCapacity(), new Object[0]).node("split-brain-protection-ref", ex.getSplitBrainProtectionName(), new Object[0]).close();
        }
    }

    public static void durableExecutorXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        for (DurableExecutorConfig ex : config.getDurableExecutorConfigs().values()) {
            gen.open("durable-executor-service", "name", ex.getName()).node("pool-size", ex.getPoolSize(), new Object[0]).node("durability", ex.getDurability(), new Object[0]).node("capacity", ex.getCapacity(), new Object[0]).node("split-brain-protection-ref", ex.getSplitBrainProtectionName(), new Object[0]).node("statistics-enabled", ex.isStatisticsEnabled(), new Object[0]).close();
        }
    }

    public static void scheduledExecutorXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        for (ScheduledExecutorConfig ex : config.getScheduledExecutorConfigs().values()) {
            MergePolicyConfig mergePolicyConfig = ex.getMergePolicyConfig();
            gen.open("scheduled-executor-service", "name", ex.getName()).node("pool-size", ex.getPoolSize(), new Object[0]).node("durability", ex.getDurability(), new Object[0]).node("capacity", ex.getCapacity(), new Object[0]).node("capacity-policy", ex.getCapacityPolicy().name(), new Object[0]).node("split-brain-protection-ref", ex.getSplitBrainProtectionName(), new Object[0]).node("merge-policy", mergePolicyConfig.getPolicy(), "batch-size", mergePolicyConfig.getBatchSize()).node("statistics-enabled", ex.isStatisticsEnabled(), new Object[0]).close();
        }
    }

    public static void cardinalityEstimatorXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        for (CardinalityEstimatorConfig ex : config.getCardinalityEstimatorConfigs().values()) {
            MergePolicyConfig mergePolicyConfig = ex.getMergePolicyConfig();
            gen.open("cardinality-estimator", "name", ex.getName()).node("backup-count", ex.getBackupCount(), new Object[0]).node("async-backup-count", ex.getAsyncBackupCount(), new Object[0]).node("split-brain-protection-ref", ex.getSplitBrainProtectionName(), new Object[0]).node("merge-policy", mergePolicyConfig.getPolicy(), "batch-size", mergePolicyConfig.getBatchSize()).close();
        }
    }

    public static void flakeIdGeneratorXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        for (FlakeIdGeneratorConfig m3 : config.getFlakeIdGeneratorConfigs().values()) {
            gen.open("flake-id-generator", "name", m3.getName()).node("prefetch-count", m3.getPrefetchCount(), new Object[0]).node("prefetch-validity-millis", m3.getPrefetchValidityMillis(), new Object[0]).node("epoch-start", m3.getEpochStart(), new Object[0]).node("node-id-offset", m3.getNodeIdOffset(), new Object[0]).node("bits-sequence", m3.getBitsSequence(), new Object[0]).node("bits-node-id", m3.getBitsNodeId(), new Object[0]).node("allowed-future-millis", m3.getAllowedFutureMillis(), new Object[0]).node("statistics-enabled", m3.isStatisticsEnabled(), new Object[0]);
            gen.close();
        }
    }

    public static void pnCounterXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        for (PNCounterConfig counterConfig : config.getPNCounterConfigs().values()) {
            gen.open("pn-counter", "name", counterConfig.getName()).node("replica-count", counterConfig.getReplicaCount(), new Object[0]).node("split-brain-protection-ref", counterConfig.getSplitBrainProtectionName(), new Object[0]).node("statistics-enabled", counterConfig.isStatisticsEnabled(), new Object[0]).close();
        }
    }

    public static void externalDataStoreXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        for (ExternalDataStoreConfig externalDataStoreConfig : config.getExternalDataStoreConfigs().values()) {
            gen.open("external-data-store", "name", externalDataStoreConfig.getName()).node("class-name", externalDataStoreConfig.getClassName(), new Object[0]).node("shared", externalDataStoreConfig.isShared(), new Object[0]).appendProperties(externalDataStoreConfig.getProperties()).close();
        }
    }

    public static void wanReplicationXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        for (WanReplicationConfig wan : config.getWanReplicationConfigs().values()) {
            gen.open("wan-replication", "name", wan.getName());
            for (WanBatchPublisherConfig wanBatchPublisherConfig : wan.getBatchPublisherConfigs()) {
                DynamicConfigXmlGenerator.wanBatchReplicationPublisherXmlGenerator(gen, wanBatchPublisherConfig);
            }
            for (WanCustomPublisherConfig wanCustomPublisherConfig : wan.getCustomPublisherConfigs()) {
                DynamicConfigXmlGenerator.wanCustomPublisherXmlGenerator(gen, wanCustomPublisherConfig);
            }
            WanConsumerConfig consumerConfig = wan.getConsumerConfig();
            if (consumerConfig != null) {
                DynamicConfigXmlGenerator.wanReplicationConsumerGenerator(gen, consumerConfig);
            }
            gen.close();
        }
    }

    private static void collectionXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, String type, Collection<? extends CollectionConfig> configs) {
        if (CollectionUtil.isNotEmpty(configs)) {
            for (CollectionConfig collectionConfig : configs) {
                gen.open(type, "name", collectionConfig.getName()).node("statistics-enabled", collectionConfig.isStatisticsEnabled(), new Object[0]).node("max-size", collectionConfig.getMaxSize(), new Object[0]).node("backup-count", collectionConfig.getBackupCount(), new Object[0]).node("async-backup-count", collectionConfig.getAsyncBackupCount(), new Object[0]).node("split-brain-protection-ref", collectionConfig.getSplitBrainProtectionName(), new Object[0]);
                DynamicConfigXmlGenerator.appendItemListenerConfigs(gen, collectionConfig.getItemListenerConfigs());
                MergePolicyConfig mergePolicyConfig = collectionConfig.getMergePolicyConfig();
                gen.node("merge-policy", mergePolicyConfig.getPolicy(), "batch-size", mergePolicyConfig.getBatchSize()).close();
            }
        }
    }

    private static void wanReplicationConsumerGenerator(ConfigXmlGenerator.XmlGenerator gen, WanConsumerConfig consumerConfig) {
        gen.open("consumer", new Object[0]);
        String consumerClassName = DynamicConfigXmlGenerator.classNameOrImplClass(consumerConfig.getClassName(), consumerConfig.getImplementation());
        if (consumerClassName != null) {
            gen.node("class-name", consumerClassName, new Object[0]);
        }
        gen.node("persist-wan-replicated-data", consumerConfig.isPersistWanReplicatedData(), new Object[0]).appendProperties(consumerConfig.getProperties()).close();
    }

    private static void wanBatchReplicationPublisherXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, WanBatchPublisherConfig c) {
        String publisherId = c.getPublisherId();
        gen.open("batch-publisher", new Object[0]);
        gen.node("cluster-name", c.getClusterName(), new Object[0]).node("batch-size", c.getBatchSize(), new Object[0]).node("batch-max-delay-millis", c.getBatchMaxDelayMillis(), new Object[0]).node("response-timeout-millis", c.getResponseTimeoutMillis(), new Object[0]).node("acknowledge-type", (Object)c.getAcknowledgeType(), new Object[0]).node("initial-publisher-state", (Object)c.getInitialPublisherState(), new Object[0]).node("snapshot-enabled", c.isSnapshotEnabled(), new Object[0]).node("idle-max-park-ns", c.getIdleMaxParkNs(), new Object[0]).node("idle-min-park-ns", c.getIdleMinParkNs(), new Object[0]).node("max-concurrent-invocations", c.getMaxConcurrentInvocations(), new Object[0]).node("discovery-period-seconds", c.getDiscoveryPeriodSeconds(), new Object[0]).node("use-endpoint-private-address", c.isUseEndpointPrivateAddress(), new Object[0]).node("queue-full-behavior", (Object)c.getQueueFullBehavior(), new Object[0]).node("max-target-endpoints", c.getMaxTargetEndpoints(), new Object[0]).node("queue-capacity", c.getQueueCapacity(), new Object[0]).appendProperties(c.getProperties());
        if (!StringUtil.isNullOrEmptyAfterTrim(publisherId)) {
            gen.node("publisher-id", publisherId, new Object[0]);
        }
        if (c.getTargetEndpoints() != null) {
            gen.node("target-endpoints", c.getTargetEndpoints(), new Object[0]);
        }
        if (c.getEndpoint() != null) {
            gen.node("endpoint", c.getEndpoint(), new Object[0]);
        }
        DynamicConfigXmlGenerator.wanReplicationSyncGenerator(gen, c.getSyncConfig());
        DynamicConfigXmlGenerator.aliasedDiscoveryConfigsGenerator(gen, AliasedDiscoveryConfigUtils.aliasedDiscoveryConfigsFrom(c));
        DynamicConfigXmlGenerator.discoveryStrategyConfigXmlGenerator(gen, c.getDiscoveryConfig());
        gen.close();
    }

    private static void wanCustomPublisherXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, WanCustomPublisherConfig c) {
        String publisherId = c.getPublisherId();
        gen.open("custom-publisher", new Object[0]).appendProperties(c.getProperties()).node("class-name", c.getClassName(), new Object[0]).node("publisher-id", publisherId, new Object[0]).close();
    }

    private static void wanReplicationSyncGenerator(ConfigXmlGenerator.XmlGenerator gen, WanSyncConfig c) {
        gen.open("sync", new Object[0]).node("consistency-check-strategy", (Object)c.getConsistencyCheckStrategy(), new Object[0]).close();
    }

    private static void tieredStoreConfigXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, TieredStoreConfig tieredStoreConfig) {
        gen.open("tiered-store", "enabled", tieredStoreConfig.isEnabled());
        DynamicConfigXmlGenerator.appendMemoryTierConfig(gen, tieredStoreConfig.getMemoryTierConfig());
        DynamicConfigXmlGenerator.appendDiskTierConfig(gen, tieredStoreConfig.getDiskTierConfig());
        gen.close();
    }

    private static void appendMemoryTierConfig(ConfigXmlGenerator.XmlGenerator gen, MemoryTierConfig memoryTierConfig) {
        Capacity capacity = memoryTierConfig.getCapacity();
        gen.open("memory-tier", new Object[0]).node("capacity", null, new Object[]{"unit", capacity.getUnit(), "value", capacity.getValue()}).close();
    }

    private static void appendDiskTierConfig(ConfigXmlGenerator.XmlGenerator gen, DiskTierConfig diskTierConfig) {
        gen.open("disk-tier", "enabled", diskTierConfig.isEnabled(), "device-name", diskTierConfig.getDeviceName()).close();
    }

    private static void checkAndFillCacheWriterFactoryConfigXml(ConfigXmlGenerator.XmlGenerator gen, String cacheWriter) {
        if (StringUtil.isNullOrEmpty(cacheWriter)) {
            return;
        }
        gen.node("cache-writer-factory", null, "class-name", cacheWriter);
    }

    private static void checkAndFillCacheWriterConfigXml(ConfigXmlGenerator.XmlGenerator gen, String cacheWriter) {
        if (StringUtil.isNullOrEmpty(cacheWriter)) {
            return;
        }
        gen.node("cache-writer", null, "class-name", cacheWriter);
    }

    private static void checkAndFillCacheLoaderFactoryConfigXml(ConfigXmlGenerator.XmlGenerator gen, String cacheLoader) {
        if (StringUtil.isNullOrEmpty(cacheLoader)) {
            return;
        }
        gen.node("cache-loader-factory", null, "class-name", cacheLoader);
    }

    private static void checkAndFillCacheLoaderConfigXml(ConfigXmlGenerator.XmlGenerator gen, String cacheLoader) {
        if (StringUtil.isNullOrEmpty(cacheLoader)) {
            return;
        }
        gen.node("cache-loader", null, "class-name", cacheLoader);
    }

    private static void cacheExpiryPolicyFactoryConfigXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, CacheSimpleConfig.ExpiryPolicyFactoryConfig config) {
        if (config == null) {
            return;
        }
        if (!StringUtil.isNullOrEmpty(config.getClassName())) {
            gen.node("expiry-policy-factory", null, "class-name", config.getClassName());
        } else {
            CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedConfig = config.getTimedExpiryPolicyFactoryConfig();
            if (timedConfig != null && timedConfig.getExpiryPolicyType() != null && timedConfig.getDurationConfig() != null) {
                CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig duration = timedConfig.getDurationConfig();
                gen.open("expiry-policy-factory", new Object[0]).node("timed-expiry-policy-factory", null, new Object[]{"expiry-policy-type", timedConfig.getExpiryPolicyType(), "duration-amount", duration.getDurationAmount(), "time-unit", duration.getTimeUnit().name()}).close();
            }
        }
    }

    private static void cachePartitionLostListenerConfigXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, List<CachePartitionLostListenerConfig> configs) {
        if (configs.isEmpty()) {
            return;
        }
        gen.open("partition-lost-listeners", new Object[0]);
        for (CachePartitionLostListenerConfig c : configs) {
            gen.node("partition-lost-listener", DynamicConfigXmlGenerator.classNameOrImplClass(c.getClassName(), c.getImplementation()), new Object[0]);
        }
        gen.close();
    }

    private static void mapPartitionStrategyConfigXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, MapConfig m3) {
        if (m3.getPartitioningStrategyConfig() != null) {
            PartitioningStrategyConfig psc = m3.getPartitioningStrategyConfig();
            gen.node("partition-strategy", DynamicConfigXmlGenerator.classNameOrImplClass(psc.getPartitioningStrategyClass(), psc.getPartitioningStrategy()), new Object[0]);
        }
    }

    private static void mapQueryCachesConfigXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, MapConfig mapConfig) {
        List<QueryCacheConfig> queryCacheConfigs = mapConfig.getQueryCacheConfigs();
        if (queryCacheConfigs != null && !queryCacheConfigs.isEmpty()) {
            gen.open("query-caches", new Object[0]);
            for (QueryCacheConfig queryCacheConfig : queryCacheConfigs) {
                gen.open("query-cache", "name", queryCacheConfig.getName());
                gen.node("include-value", queryCacheConfig.isIncludeValue(), new Object[0]);
                gen.node("in-memory-format", (Object)queryCacheConfig.getInMemoryFormat(), new Object[0]);
                gen.node("populate", queryCacheConfig.isPopulate(), new Object[0]);
                gen.node("coalesce", queryCacheConfig.isCoalesce(), new Object[0]);
                gen.node("delay-seconds", queryCacheConfig.getDelaySeconds(), new Object[0]);
                gen.node("batch-size", queryCacheConfig.getBatchSize(), new Object[0]);
                gen.node("buffer-size", queryCacheConfig.getBufferSize(), new Object[0]);
                gen.node("serialize-keys", queryCacheConfig.isSerializeKeys(), new Object[0]);
                DynamicConfigXmlGenerator.evictionConfigXmlGenerator(gen, queryCacheConfig.getEvictionConfig());
                IndexUtils.generateXml(gen, queryCacheConfig.getIndexConfigs(), false);
                DynamicConfigXmlGenerator.mapQueryCachePredicateConfigXmlGenerator(gen, queryCacheConfig);
                DynamicConfigXmlGenerator.entryListenerConfigXmlGenerator(gen, queryCacheConfig.getEntryListenerConfigs());
                gen.close();
            }
            gen.close();
        }
    }

    private static void entryListenerConfigXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, MapConfig m3) {
        DynamicConfigXmlGenerator.entryListenerConfigXmlGenerator(gen, m3.getEntryListenerConfigs());
    }

    private static void mapPartitionLostListenerConfigXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, MapConfig m3) {
        if (!m3.getPartitionLostListenerConfigs().isEmpty()) {
            gen.open("partition-lost-listeners", new Object[0]);
            for (MapPartitionLostListenerConfig c : m3.getPartitionLostListenerConfigs()) {
                gen.node("partition-lost-listener", DynamicConfigXmlGenerator.classNameOrImplClass(c.getClassName(), c.getImplementation()), new Object[0]);
            }
            gen.close();
        }
    }

    private static void mapQueryCachePredicateConfigXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, QueryCacheConfig queryCacheConfig) {
        PredicateConfig predicateConfig = queryCacheConfig.getPredicateConfig();
        String type = predicateConfig.getClassName() != null ? "class-name" : "sql";
        String content = predicateConfig.getClassName() != null ? predicateConfig.getClassName() : predicateConfig.getSql();
        gen.node("predicate", content, "type", type);
    }

    private static void appendMerkleTreeConfig(ConfigXmlGenerator.XmlGenerator gen, MerkleTreeConfig c) {
        gen.open("merkle-tree", "enabled", Boolean.TRUE.equals(c.getEnabled())).node("depth", c.getDepth(), new Object[0]).close();
    }

    private static void appendDataPersistenceConfig(ConfigXmlGenerator.XmlGenerator gen, DataPersistenceConfig p) {
        gen.open("data-persistence", "enabled", p != null && p.isEnabled()).node("fsync", p != null && p.isFsync(), new Object[0]).close();
    }

    private static void appendEventJournalConfig(ConfigXmlGenerator.XmlGenerator gen, EventJournalConfig c) {
        gen.open("event-journal", "enabled", c.isEnabled()).node("capacity", c.getCapacity(), new Object[0]).node("time-to-live-seconds", c.getTimeToLiveSeconds(), new Object[0]).close();
    }

    private static void indexConfigXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, MapConfig m3) {
        IndexUtils.generateXml(gen, m3.getIndexConfigs(), true);
    }

    private static void attributeConfigXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, MapConfig m3) {
        if (!m3.getAttributeConfigs().isEmpty()) {
            gen.open("attributes", new Object[0]);
            for (AttributeConfig attributeCfg : m3.getAttributeConfigs()) {
                gen.node("attribute", attributeCfg.getName(), "extractor-class-name", attributeCfg.getExtractorClassName());
            }
            gen.close();
        }
    }

    private static void wanReplicationConfigXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, WanReplicationRef wan) {
        if (wan != null) {
            List<String> filters;
            gen.open("wan-replication-ref", "name", wan.getName());
            String mergePolicy = wan.getMergePolicyClassName();
            if (!StringUtil.isNullOrEmpty(mergePolicy)) {
                gen.node("merge-policy-class-name", mergePolicy, new Object[0]);
            }
            if (CollectionUtil.isNotEmpty(filters = wan.getFilters())) {
                gen.open("filters", new Object[0]);
                for (String f : filters) {
                    gen.node("filter-impl", f, new Object[0]);
                }
                gen.close();
            }
            gen.node("republishing-enabled", wan.isRepublishingEnabled(), new Object[0]).close();
        }
    }

    private static void mapStoreConfigXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, MapConfig m3) {
        if (m3.getMapStoreConfig() != null) {
            MapStoreConfig s2 = m3.getMapStoreConfig();
            String clazz = s2.getImplementation() != null ? s2.getImplementation().getClass().getName() : s2.getClassName();
            String factoryClass = s2.getFactoryImplementation() != null ? s2.getFactoryImplementation().getClass().getName() : s2.getFactoryClassName();
            MapStoreConfig.InitialLoadMode initialMode = s2.getInitialLoadMode();
            gen.open("map-store", "enabled", s2.isEnabled(), "initial-mode", initialMode.toString()).node("class-name", clazz, new Object[0]).node("factory-class-name", factoryClass, new Object[0]).node("write-coalescing", s2.isWriteCoalescing(), new Object[0]).node("offload", s2.isOffload(), new Object[0]).node("write-delay-seconds", s2.getWriteDelaySeconds(), new Object[0]).node("write-batch-size", s2.getWriteBatchSize(), new Object[0]).appendProperties(s2.getProperties()).close();
        }
    }

    private static void mapNearCacheConfigXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, NearCacheConfig n) {
        if (n != null) {
            if (n.getName() != null) {
                gen.open("near-cache", "name", n.getName());
            } else {
                gen.open("near-cache", new Object[0]);
            }
            gen.node("in-memory-format", (Object)n.getInMemoryFormat(), new Object[0]).node("invalidate-on-change", n.isInvalidateOnChange(), new Object[0]).node("time-to-live-seconds", n.getTimeToLiveSeconds(), new Object[0]).node("max-idle-seconds", n.getMaxIdleSeconds(), new Object[0]).node("serialize-keys", n.isSerializeKeys(), new Object[0]).node("cache-local-entries", n.isCacheLocalEntries(), new Object[0]);
            DynamicConfigXmlGenerator.evictionConfigXmlGenerator(gen, n.getEvictionConfig());
            gen.close();
        }
    }

    private static void evictionConfigXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, EvictionConfig e) {
        if (e == null) {
            return;
        }
        String comparatorClassName = !StringUtil.isNullOrEmpty(e.getComparatorClassName()) ? e.getComparatorClassName() : null;
        gen.node("eviction", null, new Object[]{"size", e.getSize(), "max-size-policy", e.getMaxSizePolicy(), "eviction-policy", e.getEvictionPolicy(), "comparator-class-name", comparatorClassName});
    }

    private static void entryListenerConfigXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, List<EntryListenerConfig> entryListenerConfigs) {
        if (!entryListenerConfigs.isEmpty()) {
            gen.open("entry-listeners", new Object[0]);
            for (EntryListenerConfig lc : entryListenerConfigs) {
                gen.node("entry-listener", DynamicConfigXmlGenerator.classNameOrImplClass(lc.getClassName(), lc.getImplementation()), "include-value", lc.isIncludeValue(), "local", lc.isLocal());
            }
            gen.close();
        }
    }

    public static void aliasedDiscoveryConfigsGenerator(ConfigXmlGenerator.XmlGenerator gen, List<AliasedDiscoveryConfig<?>> configs) {
        if (configs == null) {
            return;
        }
        for (AliasedDiscoveryConfig<?> c : configs) {
            gen.open(AliasedDiscoveryConfigUtils.tagFor(c), "enabled", c.isEnabled());
            if (c.isUsePublicIp()) {
                gen.node("use-public-ip", "true", new Object[0]);
            }
            for (String key : c.getProperties().keySet()) {
                gen.node(key, c.getProperties().get(key), new Object[0]);
            }
            gen.close();
        }
    }

    public static void discoveryStrategyConfigXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, DiscoveryConfig c) {
        Collection<DiscoveryStrategyConfig> configs;
        if (c == null) {
            return;
        }
        gen.open("discovery-strategies", new Object[0]);
        String nodeFilterClass = DynamicConfigXmlGenerator.classNameOrImplClass(c.getNodeFilterClass(), c.getNodeFilter());
        if (nodeFilterClass != null) {
            gen.node("node-filter", null, "class", nodeFilterClass);
        }
        if (CollectionUtil.isNotEmpty(configs = c.getDiscoveryStrategyConfigs())) {
            for (DiscoveryStrategyConfig config : configs) {
                gen.open("discovery-strategy", "class", DynamicConfigXmlGenerator.classNameOrImplClass(config.getClassName(), config.getDiscoveryStrategyFactory()), "enabled", "true").appendProperties(config.getProperties()).close();
            }
        }
        gen.close();
    }

    public static void tcpIpConfigXmlGenerator(ConfigXmlGenerator.XmlGenerator gen, Config config) {
        ConfigXmlGenerator.tcpIpConfigXmlGenerator(gen, ConfigAccessor.getActiveMemberNetworkConfig(config).getJoin());
    }

    public static String classNameOrImplClass(String className, Object impl) {
        return !StringUtil.isNullOrEmpty(className) ? className : (impl != null ? impl.getClass().getName() : null);
    }

    private static void appendItemListenerConfigs(ConfigXmlGenerator.XmlGenerator gen, Collection<ItemListenerConfig> configs) {
        if (CollectionUtil.isNotEmpty(configs)) {
            gen.open("item-listeners", new Object[0]);
            for (ItemListenerConfig lc : configs) {
                gen.node("item-listener", DynamicConfigXmlGenerator.classNameOrImplClass(lc.getClassName(), lc.getImplementation()), "include-value", lc.isIncludeValue());
            }
            gen.close();
        }
    }
}

