/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl.operations;

import com.hazelcast.cluster.Address;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.tcp.LinkedAddresses;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngineImpl;

public class ClusterMismatchOp
extends AbstractClusterOperation {
    @Override
    public void run() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        ServerConnection connection = this.getConnection();
        String message = "Node could not join cluster at node: " + connection.getRemoteAddress() + " Cause: the target cluster has a different cluster-name";
        Node node = nodeEngine.getNode();
        LinkedAddresses linkedAddresses = node.getLocalAddressRegistry().linkedAddressesOf(this.getCallerUuid());
        connection.close(message, null);
        ILogger logger2 = nodeEngine.getLogger("com.hazelcast.cluster");
        logger2.warning(message);
        if (linkedAddresses != null) {
            for (Address address : linkedAddresses.getAllAddresses()) {
                node.getJoiner().blacklist(address, true);
            }
        } else {
            node.getJoiner().blacklist(this.getCallerAddress(), true);
        }
    }

    @Override
    public int getClassId() {
        return 11;
    }
}

