/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.cluster.impl.MemberMap;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public final class MembersView
implements IdentifiedDataSerializable {
    private int version;
    private List<MemberInfo> members;

    public MembersView() {
    }

    public MembersView(int version, List<MemberInfo> members) {
        this.version = version;
        this.members = members;
    }

    static MembersView cloneAdding(MembersView source2, Collection<MemberInfo> newMembers) {
        ArrayList<MemberInfo> list = new ArrayList<MemberInfo>(source2.size() + newMembers.size());
        list.addAll(source2.getMembers());
        int newVersion = Math.max(source2.version, source2.size());
        for (MemberInfo newMember : newMembers) {
            MemberInfo m3 = new MemberInfo(newMember.getAddress(), newMember.getUuid(), newMember.getCPMemberUUID(), newMember.getAttributes(), newMember.isLiteMember(), newMember.getVersion(), ++newVersion, newMember.getAddressMap());
            list.add(m3);
        }
        return new MembersView(newVersion, Collections.unmodifiableList(list));
    }

    public static MembersView createNew(int version, Collection<MemberImpl> members) {
        ArrayList<MemberInfo> list = new ArrayList<MemberInfo>(members.size());
        for (MemberImpl member : members) {
            list.add(new MemberInfo(member));
        }
        return new MembersView(version, Collections.unmodifiableList(list));
    }

    public List<MemberInfo> getMembers() {
        return this.members;
    }

    public int size() {
        return this.members.size();
    }

    public int getVersion() {
        return this.version;
    }

    MemberMap toMemberMap() {
        MemberImpl[] m3 = new MemberImpl[this.size()];
        int ix = 0;
        for (MemberInfo memberInfo : this.members) {
            m3[ix++] = memberInfo.toMember();
        }
        return MemberMap.createNew(this.version, m3);
    }

    public boolean containsAddress(Address address) {
        for (MemberInfo member : this.members) {
            if (!member.getAddress().equals(address)) continue;
            return true;
        }
        return false;
    }

    public boolean containsMember(Address address, UUID uuid) {
        for (MemberInfo member : this.members) {
            if (!member.getAddress().equals(address)) continue;
            return member.getUuid().equals(uuid);
        }
        return false;
    }

    public Set<Address> getAddresses() {
        HashSet<Address> addresses = new HashSet<Address>(this.members.size());
        for (MemberInfo member : this.members) {
            addresses.add(member.getAddress());
        }
        return addresses;
    }

    public MemberInfo getMember(Address address) {
        for (MemberInfo member : this.members) {
            if (!member.getAddress().equals(address)) continue;
            return member;
        }
        return null;
    }

    public boolean isLaterThan(MembersView other) {
        return this.version > other.version;
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getClassId() {
        return 35;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.version);
        SerializationUtil.writeList(this.members, out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.version = in.readInt();
        this.members = Collections.unmodifiableList(SerializationUtil.readList(in));
    }

    public String toString() {
        return "MembersView{version=" + this.version + ", members=" + this.members + '}';
    }
}

