/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.MemberAddressProviderConfig;
import com.hazelcast.instance.AddressPicker;
import com.hazelcast.instance.impl.AdvancedNetworkAddressPicker;
import com.hazelcast.instance.impl.DefaultAddressPicker;
import com.hazelcast.instance.impl.DelegatingAddressPicker;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.instance.impl.NodeContext;
import com.hazelcast.instance.impl.NodeExtension;
import com.hazelcast.instance.impl.NodeExtensionFactory;
import com.hazelcast.internal.cluster.Joiner;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.networking.Networking;
import com.hazelcast.internal.networking.nio.NioNetworking;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.server.Server;
import com.hazelcast.internal.server.tcp.LocalAddressRegistry;
import com.hazelcast.internal.server.tcp.ServerSocketRegistry;
import com.hazelcast.internal.server.tcp.TcpServer;
import com.hazelcast.internal.server.tcp.TcpServerConnectionChannelErrorHandler;
import com.hazelcast.internal.server.tcp.TcpServerContext;
import com.hazelcast.internal.util.InstantiationUtils;
import com.hazelcast.internal.util.ThreadAffinity;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.impl.LoggingServiceImpl;
import com.hazelcast.spi.MemberAddressProvider;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class DefaultNodeContext
implements NodeContext {
    public static final List<String> EXTENSION_PRIORITY_LIST = Collections.unmodifiableList(Arrays.asList("com.hazelcast.instance.impl.EnterpriseNodeExtension", "com.hazelcast.instance.impl.DefaultNodeExtension"));

    @Override
    public NodeExtension createNodeExtension(Node node) {
        return NodeExtensionFactory.create(node, EXTENSION_PRIORITY_LIST);
    }

    @Override
    public AddressPicker createAddressPicker(Node node) {
        Config config = node.getConfig();
        MemberAddressProviderConfig memberAddressProviderConfig = ConfigAccessor.getActiveMemberNetworkConfig(config).getMemberAddressProviderConfig();
        ILogger addressPickerLogger = node.getLogger(AddressPicker.class);
        if (!memberAddressProviderConfig.isEnabled()) {
            if (config.getAdvancedNetworkConfig().isEnabled()) {
                return new AdvancedNetworkAddressPicker(config, addressPickerLogger);
            }
            return new DefaultAddressPicker(config, addressPickerLogger);
        }
        MemberAddressProvider implementation = memberAddressProviderConfig.getImplementation();
        if (implementation != null) {
            return new DelegatingAddressPicker(implementation, config, addressPickerLogger);
        }
        ClassLoader classLoader = config.getClassLoader();
        String classname = memberAddressProviderConfig.getClassName();
        Class<? extends MemberAddressProvider> clazz = this.loadMemberAddressProviderClass(classLoader, classname);
        ILogger memberAddressProviderLogger = node.getLogger(clazz);
        Properties properties = memberAddressProviderConfig.getProperties();
        MemberAddressProvider memberAddressProvider = DefaultNodeContext.newMemberAddressProviderInstance(clazz, memberAddressProviderLogger, properties);
        return new DelegatingAddressPicker(memberAddressProvider, config, addressPickerLogger);
    }

    private static MemberAddressProvider newMemberAddressProviderInstance(Class<? extends MemberAddressProvider> clazz, ILogger logger2, Properties properties) {
        Properties nonNullProps = properties == null ? new Properties() : properties;
        MemberAddressProvider provider = InstantiationUtils.newInstanceOrNull(clazz, nonNullProps, logger2);
        if (provider == null) {
            provider = InstantiationUtils.newInstanceOrNull(clazz, logger2, nonNullProps);
        }
        if (provider == null) {
            provider = InstantiationUtils.newInstanceOrNull(clazz, nonNullProps);
        }
        if (provider == null) {
            if (properties != null && !properties.isEmpty()) {
                throw new InvalidConfigurationException("Cannot find a matching constructor for MemberAddressProvider.  The member address provider has properties configured, but the class '" + clazz.getName() + "' does not have a public constructor accepting properties.");
            }
            provider = InstantiationUtils.newInstanceOrNull(clazz, logger2);
        }
        if (provider == null) {
            provider = InstantiationUtils.newInstanceOrNull(clazz, new Object[0]);
        }
        if (provider == null) {
            throw new InvalidConfigurationException("Cannot find a matching constructor for MemberAddressProvider implementation '" + clazz.getName() + "'.");
        }
        return provider;
    }

    private Class<? extends MemberAddressProvider> loadMemberAddressProviderClass(ClassLoader classLoader, String classname) {
        try {
            Class<?> clazz = ClassLoaderUtil.loadClass(classLoader, classname);
            if (!MemberAddressProvider.class.isAssignableFrom(clazz)) {
                throw new InvalidConfigurationException("Configured member address provider " + clazz.getName() + " does not implement the interface" + MemberAddressProvider.class.getName());
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Cannot create a new instance of MemberAddressProvider '" + classname + "'", e);
        }
    }

    @Override
    public Joiner createJoiner(Node node) {
        return node.createJoiner();
    }

    @Override
    public Server createServer(Node node, ServerSocketRegistry registry, LocalAddressRegistry addressRegistry) {
        TcpServerContext context = new TcpServerContext(node, node.nodeEngine);
        Networking networking = this.createNetworking(node);
        Config config = node.getConfig();
        MetricsRegistry metricsRegistry = node.nodeEngine.getMetricsRegistry();
        return new TcpServer(config, context, registry, addressRegistry, metricsRegistry, networking, node.getNodeExtension().createChannelInitializerFn(context));
    }

    private Networking createNetworking(Node node) {
        LoggingServiceImpl loggingService = node.loggingService;
        ILogger logger2 = loggingService.getLogger(TcpServerConnectionChannelErrorHandler.class);
        TcpServerConnectionChannelErrorHandler errorHandler = new TcpServerConnectionChannelErrorHandler(logger2);
        HazelcastProperties props = node.getProperties();
        return new NioNetworking(new NioNetworking.Context().loggingService(loggingService).metricsRegistry(node.nodeEngine.getMetricsRegistry()).threadNamePrefix(node.hazelcastInstance.getName()).errorHandler(errorHandler).inputThreadCount(props.getInteger(ClusterProperty.IO_INPUT_THREAD_COUNT)).inputThreadAffinity(ThreadAffinity.newSystemThreadAffinity("hazelcast.io.input.thread.affinity")).outputThreadCount(props.getInteger(ClusterProperty.IO_OUTPUT_THREAD_COUNT)).outputThreadAffinity(ThreadAffinity.newSystemThreadAffinity("hazelcast.io.output.thread.affinity")).balancerIntervalSeconds(props.getInteger(ClusterProperty.IO_BALANCER_INTERVAL_SECONDS)).writeThroughEnabled(props.getBoolean(ClusterProperty.IO_WRITE_THROUGH_ENABLED)).concurrencyDetection(node.nodeEngine.getConcurrencyDetection()));
    }
}

