/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.datastore.impl;

import com.hazelcast.config.ExternalDataStoreConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.datastore.ExternalDataStoreFactory;
import com.hazelcast.datastore.ExternalDataStoreService;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ExternalDataStoreServiceImpl
implements ExternalDataStoreService {
    private final Map<String, ExternalDataStoreFactory<?>> dataStoreFactories = new ConcurrentHashMap();
    private final ClassLoader classLoader;
    private final Node node;

    public ExternalDataStoreServiceImpl(Node node, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.node = node;
        for (Map.Entry<String, ExternalDataStoreConfig> entry : node.getConfig().getExternalDataStoreConfigs().entrySet()) {
            this.dataStoreFactories.put(entry.getKey(), this.createFactory(entry.getValue()));
        }
    }

    private ExternalDataStoreFactory<?> createFactory(ExternalDataStoreConfig config) {
        String className = config.getClassName();
        try {
            ExternalDataStoreFactory externalDataStoreFactory = (ExternalDataStoreFactory)ClassLoaderUtil.newInstance(this.classLoader, className);
            externalDataStoreFactory.init(config);
            return externalDataStoreFactory;
        }
        catch (ClassCastException e) {
            throw new HazelcastException("External data store '" + config.getName() + "' misconfigured: '" + className + "' must implement '" + ExternalDataStoreFactory.class.getName() + "'", e);
        }
        catch (ClassNotFoundException e) {
            throw new HazelcastException("External data store '" + config.getName() + "' misconfigured: class '" + className + "' not found", e);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public ExternalDataStoreFactory<?> getExternalDataStoreFactory(String name) {
        ExternalDataStoreConfig externalDataStoreConfig = this.node.getConfig().getExternalDataStoreConfigs().get(name);
        if (externalDataStoreConfig == null) {
            throw new HazelcastException("External data store factory '" + name + "' not found");
        }
        return this.dataStoreFactories.computeIfAbsent(name, n -> this.createFactory(externalDataStoreConfig));
    }
}

