/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.spi.atomic;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftNodeLifecycleAwareService;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.datastructures.spi.AbstractCPMigrationAwareService;
import com.hazelcast.cp.internal.datastructures.spi.RaftManagedService;
import com.hazelcast.cp.internal.datastructures.spi.RaftRemoteService;
import com.hazelcast.cp.internal.datastructures.spi.atomic.RaftAtomicValue;
import com.hazelcast.cp.internal.datastructures.spi.atomic.RaftAtomicValueSnapshot;
import com.hazelcast.cp.internal.raft.SnapshotAwareService;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public abstract class RaftAtomicValueService<T, V extends RaftAtomicValue<T>, S extends RaftAtomicValueSnapshot<T>>
extends AbstractCPMigrationAwareService
implements RaftManagedService,
RaftRemoteService,
RaftNodeLifecycleAwareService,
SnapshotAwareService<S> {
    protected final Map<BiTuple<CPGroupId, String>, V> atomicValues = new ConcurrentHashMap<BiTuple<CPGroupId, String>, V>();
    private final Set<BiTuple<CPGroupId, String>> destroyedValues = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile RaftService raftService;

    public RaftAtomicValueService(NodeEngine nodeEngine) {
        super(nodeEngine);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.raftService = (RaftService)nodeEngine.getService("hz:core:raft");
    }

    @Override
    public void reset() {
        if (!this.raftService.isCpSubsystemEnabled()) {
            this.clearValues();
        }
    }

    private void clearValues() {
        this.atomicValues.clear();
        this.destroyedValues.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.clearValues();
    }

    @Override
    public void onCPSubsystemRestart() {
        this.clearValues();
    }

    @Override
    public final S takeSnapshot(CPGroupId groupId, long commitIndex) {
        Preconditions.checkNotNull(groupId);
        HashMap values2 = new HashMap();
        for (RaftAtomicValue value : this.atomicValues.values()) {
            if (!value.groupId().equals(groupId)) continue;
            values2.put(value.name(), value.get());
        }
        HashSet<String> destroyed = new HashSet<String>();
        for (BiTuple<CPGroupId, String> tuple : this.destroyedValues) {
            if (!groupId.equals(tuple.element1)) continue;
            destroyed.add((String)tuple.element2);
        }
        return this.newSnapshot(values2, destroyed);
    }

    protected abstract S newSnapshot(Map<String, T> var1, Set<String> var2);

    @Override
    public final void restoreSnapshot(CPGroupId groupId, long commitIndex, S snapshot) {
        Preconditions.checkNotNull(groupId);
        for (Map.Entry e : ((RaftAtomicValueSnapshot)snapshot).getValues()) {
            String name = e.getKey();
            Object val = e.getValue();
            this.atomicValues.put(BiTuple.of(groupId, name), this.newAtomicValue(groupId, name, val));
        }
        for (String name : ((RaftAtomicValueSnapshot)snapshot).getDestroyed()) {
            this.destroyedValues.add(BiTuple.of(groupId, name));
        }
    }

    protected abstract V newAtomicValue(CPGroupId var1, String var2, T var3);

    @Override
    public final void onRaftNodeTerminated(CPGroupId groupId) {
        Iterator<BiTuple<CPGroupId, String>> iter = this.atomicValues.keySet().iterator();
        while (iter.hasNext()) {
            BiTuple<CPGroupId, String> next = iter.next();
            if (!groupId.equals(next.element1)) continue;
            this.destroyedValues.add(next);
            iter.remove();
        }
    }

    @Override
    public void onRaftNodeSteppedDown(CPGroupId groupId) {
    }

    @Override
    public final boolean destroyRaftObject(CPGroupId groupId, String name) {
        BiTuple<CPGroupId, String> key = BiTuple.of(groupId, name);
        this.destroyedValues.add(key);
        return this.atomicValues.remove(key) != null;
    }

    public int getAtomicValuesCount() {
        return this.atomicValues.size();
    }

    public final V getAtomicValue(CPGroupId groupId, String name) {
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(name);
        BiTuple<CPGroupId, String> key = BiTuple.of(groupId, name);
        if (this.destroyedValues.contains(key)) {
            throw new DistributedObjectDestroyedException("AtomicValue[" + name + "] is already destroyed!");
        }
        RaftAtomicValue<Object> atomicValue = (RaftAtomicValue)this.atomicValues.get(key);
        if (atomicValue == null) {
            atomicValue = this.newAtomicValue(groupId, name, null);
            this.atomicValues.put(key, atomicValue);
        }
        return (V)atomicValue;
    }

    public final DistributedObject createProxy(String proxyName) {
        try {
            proxyName = RaftService.withoutDefaultGroupName(proxyName);
            RaftGroupId groupId = this.raftService.createRaftGroupForProxy(proxyName);
            return this.newRaftAtomicProxy(this.nodeEngine, groupId, proxyName, RaftService.getObjectNameForProxy(proxyName));
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    protected abstract DistributedObject newRaftAtomicProxy(NodeEngineImpl var1, RaftGroupId var2, String var3, String var4);

    @Override
    protected int getBackupCount() {
        return 1;
    }

    @Override
    protected final Map<CPGroupId, Object> getSnapshotMap(int partitionId) {
        assert (!this.raftService.isCpSubsystemEnabled());
        int partitionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        return this.atomicValues.keySet().stream().filter(tuple -> RaftService.getCPGroupPartitionId((CPGroupId)tuple.element1, partitionCount) == partitionId).map(tuple -> (CPGroupId)tuple.element1).distinct().map(groupId -> BiTuple.of(groupId, this.takeSnapshot((CPGroupId)groupId, 0L))).collect(Collectors.toMap(tuple -> (CPGroupId)tuple.element1, tuple -> (RaftAtomicValueSnapshot)tuple.element2));
    }

    @Override
    protected final void clearPartitionReplica(int partitionId) {
        this.atomicValues.keySet().removeIf(t -> this.raftService.getCPGroupPartitionId((CPGroupId)t.element1) == partitionId);
    }
}

