/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.merge.PassThroughMergePolicy;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class WanReplicationRef
implements IdentifiedDataSerializable,
Serializable {
    private static final String DEFAULT_MERGE_POLICY_CLASS_NAME = PassThroughMergePolicy.class.getName();
    private boolean republishingEnabled = true;
    private String name;
    private String mergePolicyClassName = DEFAULT_MERGE_POLICY_CLASS_NAME;
    private List<String> filters = new LinkedList<String>();

    public WanReplicationRef() {
    }

    public WanReplicationRef(WanReplicationRef ref) {
        this(ref.name, ref.mergePolicyClassName, ref.filters, ref.republishingEnabled);
    }

    public WanReplicationRef(String name, String mergePolicyClassName, List<String> filters, boolean republishingEnabled) {
        this.name = name;
        this.mergePolicyClassName = mergePolicyClassName;
        this.filters = filters;
        this.republishingEnabled = republishingEnabled;
    }

    public String getName() {
        return this.name;
    }

    public WanReplicationRef setName(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Name must not be null");
        this.name = name;
        return this;
    }

    @Nonnull
    public String getMergePolicyClassName() {
        return this.mergePolicyClassName;
    }

    public WanReplicationRef setMergePolicyClassName(@Nonnull String mergePolicyClassName) {
        Preconditions.checkNotNull(mergePolicyClassName, "Merge policy class name must not be null");
        this.mergePolicyClassName = mergePolicyClassName;
        return this;
    }

    public WanReplicationRef addFilter(@Nonnull String filterClassName) {
        Preconditions.checkNotNull(filterClassName, "Filter class name must not be null");
        this.filters.add(filterClassName);
        return this;
    }

    @Nonnull
    public List<String> getFilters() {
        return this.filters;
    }

    public WanReplicationRef setFilters(@Nonnull List<String> filters) {
        Preconditions.checkNotNull(filters, "Filters must not be null");
        this.filters = filters;
        return this;
    }

    public boolean isRepublishingEnabled() {
        return this.republishingEnabled;
    }

    public WanReplicationRef setRepublishingEnabled(boolean republishEnabled) {
        this.republishingEnabled = republishEnabled;
        return this;
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 59;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.mergePolicyClassName);
        out.writeInt(this.filters.size());
        for (String filter : this.filters) {
            out.writeString(filter);
        }
        out.writeBoolean(this.republishingEnabled);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.mergePolicyClassName = in.readString();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.filters.add(in.readString());
        }
        this.republishingEnabled = in.readBoolean();
    }

    public String toString() {
        return "WanReplicationRef{name='" + this.name + '\'' + ", mergePolicy='" + this.mergePolicyClassName + '\'' + ", filters='" + this.filters + '\'' + ", republishingEnabled='" + this.republishingEnabled + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WanReplicationRef that = (WanReplicationRef)o;
        return this.republishingEnabled == that.republishingEnabled && Objects.equals(this.name, that.name) && Objects.equals(this.mergePolicyClassName, that.mergePolicyClassName) && Objects.equals(this.filters, that.filters);
    }

    public int hashCode() {
        return Objects.hash(this.republishingEnabled, this.name, this.mergePolicyClassName, this.filters);
    }
}

