/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.StackTraceElementCodec;
import com.hazelcast.client.impl.protocol.exception.ErrorHolder;
import java.util.List;

public final class ErrorHolderCodec {
    private static final int ERROR_CODE_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 4;

    private ErrorHolderCodec() {
    }

    public static void encode(ClientMessage clientMessage, ErrorHolder errorHolder) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[4]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, errorHolder.getErrorCode());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, errorHolder.getClassName());
        CodecUtil.encodeNullable(clientMessage, errorHolder.getMessage(), StringCodec::encode);
        ListMultiFrameCodec.encode(clientMessage, errorHolder.getStackTraceElements(), StackTraceElementCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static ErrorHolder decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        int errorCode = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        String className = StringCodec.decode(iterator2);
        String message = CodecUtil.decodeNullable(iterator2, StringCodec::decode);
        List<StackTraceElement> stackTraceElements = ListMultiFrameCodec.decode(iterator2, StackTraceElementCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return new ErrorHolder(errorCode, className, message, stackTraceElements);
    }
}

