/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AddressCodec;
import com.hazelcast.cluster.Address;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.internal.CPMemberInfo;
import java.util.UUID;

public final class CPMemberCodec {
    private static final int UUID_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 17;

    private CPMemberCodec() {
    }

    public static void encode(ClientMessage clientMessage, CPMember cPMember) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[17]);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 0, cPMember.getUuid());
        clientMessage.add(initialFrame);
        AddressCodec.encode(clientMessage, cPMember.getAddress());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static CPMemberInfo decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        UUID uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 0);
        Address address = AddressCodec.decode(iterator2);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return new CPMemberInfo(uuid, address);
    }
}

