/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class CodecUtil {
    private CodecUtil() {
    }

    public static void fastForwardToEndFrame(ClientMessage.ForwardFrameIterator iterator2) {
        int numberOfExpectedEndFrames = 1;
        while (numberOfExpectedEndFrames != 0) {
            ClientMessage.Frame frame = iterator2.next();
            if (frame.isEndFrame()) {
                --numberOfExpectedEndFrames;
                continue;
            }
            if (!frame.isBeginFrame()) continue;
            ++numberOfExpectedEndFrames;
        }
    }

    public static <T> void encodeNullable(ClientMessage clientMessage, T value, BiConsumer<ClientMessage, T> encode) {
        if (value == null) {
            clientMessage.add(ClientMessage.NULL_FRAME.copy());
        } else {
            encode.accept(clientMessage, (ClientMessage)value);
        }
    }

    public static <T> T decodeNullable(ClientMessage.ForwardFrameIterator iterator2, Function<ClientMessage.ForwardFrameIterator, T> decode) {
        return CodecUtil.nextFrameIsNullEndFrame(iterator2) ? null : (T)decode.apply(iterator2);
    }

    public static boolean nextFrameIsDataStructureEndFrame(ClientMessage.ForwardFrameIterator iterator2) {
        return iterator2.peekNext().isEndFrame();
    }

    public static boolean nextFrameIsNullEndFrame(ClientMessage.ForwardFrameIterator iterator2) {
        boolean isNull = iterator2.peekNext().isNullFrame();
        if (isNull) {
            iterator2.next();
        }
        return isNull;
    }
}

