/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.ListenerConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.QueueStoreConfigHolderCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.ListenerConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.QueueStoreConfigHolder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class DynamicConfigAddQueueConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x1B0B00;
    public static final int RESPONSE_MESSAGE_TYPE = 0x1B0B01;
    private static final int REQUEST_BACKUP_COUNT_FIELD_OFFSET = 16;
    private static final int REQUEST_ASYNC_BACKUP_COUNT_FIELD_OFFSET = 20;
    private static final int REQUEST_MAX_SIZE_FIELD_OFFSET = 24;
    private static final int REQUEST_EMPTY_QUEUE_TTL_FIELD_OFFSET = 28;
    private static final int REQUEST_STATISTICS_ENABLED_FIELD_OFFSET = 32;
    private static final int REQUEST_MERGE_BATCH_SIZE_FIELD_OFFSET = 33;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 37;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private DynamicConfigAddQueueConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, @Nullable Collection<ListenerConfigHolder> listenerConfigs, int backupCount, int asyncBackupCount, int maxSize, int emptyQueueTtl, boolean statisticsEnabled, @Nullable String splitBrainProtectionName, @Nullable QueueStoreConfigHolder queueStoreConfig, String mergePolicy, int mergeBatchSize, @Nullable String priorityComparatorClassName) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setContainsSerializedDataInRequest(true);
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("DynamicConfig.AddQueueConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[37], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x1B0B00);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, backupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, asyncBackupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, maxSize);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 28, emptyQueueTtl);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 32, statisticsEnabled);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 33, mergeBatchSize);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        ListMultiFrameCodec.encodeNullable(clientMessage, listenerConfigs, ListenerConfigHolderCodec::encode);
        CodecUtil.encodeNullable(clientMessage, splitBrainProtectionName, StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, queueStoreConfig, QueueStoreConfigHolderCodec::encode);
        StringCodec.encode(clientMessage, mergePolicy);
        CodecUtil.encodeNullable(clientMessage, priorityComparatorClassName, StringCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        request.backupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.asyncBackupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
        request.maxSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        request.emptyQueueTtl = FixedSizeTypesCodec.decodeInt(initialFrame.content, 28);
        request.statisticsEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 32);
        request.mergeBatchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 33);
        request.name = StringCodec.decode(iterator2);
        request.listenerConfigs = ListMultiFrameCodec.decodeNullable(iterator2, ListenerConfigHolderCodec::decode);
        request.splitBrainProtectionName = CodecUtil.decodeNullable(iterator2, StringCodec::decode);
        request.queueStoreConfig = CodecUtil.decodeNullable(iterator2, QueueStoreConfigHolderCodec::decode);
        request.mergePolicy = StringCodec.decode(iterator2);
        if (iterator2.hasNext()) {
            request.priorityComparatorClassName = CodecUtil.decodeNullable(iterator2, StringCodec::decode);
            request.isPriorityComparatorClassNameExists = true;
        } else {
            request.isPriorityComparatorClassNameExists = false;
        }
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x1B0B01);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        @Nullable
        public List<ListenerConfigHolder> listenerConfigs;
        public int backupCount;
        public int asyncBackupCount;
        public int maxSize;
        public int emptyQueueTtl;
        public boolean statisticsEnabled;
        @Nullable
        public String splitBrainProtectionName;
        @Nullable
        public QueueStoreConfigHolder queueStoreConfig;
        public String mergePolicy;
        public int mergeBatchSize;
        @Nullable
        public String priorityComparatorClassName;
        public boolean isPriorityComparatorClassNameExists;
    }
}

