/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.tcp;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientPingCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public final class HeartbeatManager {
    private HeartbeatManager() {
    }

    public static void start(HazelcastClientInstanceImpl client, TaskScheduler taskScheduler, ILogger logger2, long heartbeatIntervalMillis, long heartbeatTimeoutMillis, Collection<Connection> unmodifiableActiveConnections) {
        taskScheduler.scheduleWithRepetition(() -> {
            long now = Clock.currentTimeMillis();
            for (Connection connection : unmodifiableActiveConnections) {
                if (!connection.isAlive()) {
                    return;
                }
                if (now - connection.lastReadTimeMillis() > heartbeatTimeoutMillis) {
                    logger2.warning("Heartbeat failed over the connection: " + connection);
                    connection.close("Heartbeat timed out", new TargetDisconnectedException("Heartbeat timed out to connection " + connection));
                    return;
                }
                if (now - connection.lastWriteTimeMillis() <= heartbeatIntervalMillis) continue;
                ClientMessage request = ClientPingCodec.encodeRequest();
                ClientInvocation invocation = new ClientInvocation(client, request, null, connection);
                invocation.invokeUrgent();
            }
        }, heartbeatIntervalMillis, heartbeatIntervalMillis, TimeUnit.MILLISECONDS);
    }
}

