/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.config.ClientCloudConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.config.impl.ClientAliasedDiscoveryConfigUtils;
import com.hazelcast.client.impl.ClientExtension;
import com.hazelcast.client.impl.clientside.CandidateClusterContext;
import com.hazelcast.client.impl.clientside.ClientCallbackHandler;
import com.hazelcast.client.impl.clientside.ClusterDiscoveryService;
import com.hazelcast.client.impl.connection.AddressProvider;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.client.impl.spi.impl.DefaultAddressProvider;
import com.hazelcast.client.impl.spi.impl.TranslateToPublicAddressProvider;
import com.hazelcast.client.impl.spi.impl.discovery.HazelcastCloudDiscovery;
import com.hazelcast.client.impl.spi.impl.discovery.RemoteAddressProvider;
import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.cluster.Address;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.security.StaticCredentialsFactory;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.internal.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.internal.config.DiscoveryConfigReadOnly;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.security.ICredentialsFactory;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.impl.DefaultDiscoveryService;
import com.hazelcast.spi.discovery.impl.DefaultDiscoveryServiceProvider;
import com.hazelcast.spi.discovery.integration.DiscoveryMode;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import com.hazelcast.spi.discovery.integration.DiscoveryServiceProvider;
import com.hazelcast.spi.discovery.integration.DiscoveryServiceSettings;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ClusterDiscoveryServiceBuilder {
    private final int configsTryCount;
    private final LoggingService loggingService;
    private final HazelcastProperties properties;
    private final ClientExtension clientExtension;
    private final Collection<ClientConfig> configs;
    private final LifecycleService lifecycleService;
    private final AddressProvider externalAddressProvider;
    private final ClientClusterService clusterService;

    ClusterDiscoveryServiceBuilder(int configsTryCount, List<ClientConfig> configs, LoggingService loggingService, AddressProvider externalAddressProvider, HazelcastProperties properties, ClientExtension clientExtension, LifecycleService lifecycleService, ClientClusterService clusterService) {
        this.configsTryCount = configsTryCount;
        this.configs = configs;
        this.loggingService = loggingService;
        this.externalAddressProvider = externalAddressProvider;
        this.properties = properties;
        this.clientExtension = clientExtension;
        this.lifecycleService = lifecycleService;
        this.clusterService = clusterService;
    }

    public ClusterDiscoveryService build() {
        ArrayList<CandidateClusterContext> contexts = new ArrayList<CandidateClusterContext>();
        for (ClientConfig config : this.configs) {
            ClientNetworkConfig networkConfig = config.getNetworkConfig();
            SocketInterceptor interceptor = this.initSocketInterceptor(networkConfig.getSocketInterceptorConfig());
            ICredentialsFactory credentialsFactory = this.initCredentialsFactory(config);
            if (credentialsFactory == null) {
                credentialsFactory = new StaticCredentialsFactory(new UsernamePasswordCredentials(null, null));
            }
            credentialsFactory.configure(new ClientCallbackHandler(config));
            DiscoveryService discoveryService = this.initDiscoveryService(config);
            AddressProvider provider = this.externalAddressProvider != null ? this.externalAddressProvider : this.createAddressProvider(config, discoveryService);
            SSLConfig sslConfig = networkConfig.getSSLConfig();
            SocketOptions socketOptions = networkConfig.getSocketOptions();
            contexts.add(new CandidateClusterContext(config.getClusterName(), provider, discoveryService, credentialsFactory, interceptor, this.clientExtension.createChannelInitializer(sslConfig, socketOptions)));
        }
        return new ClusterDiscoveryService(Collections.unmodifiableList(contexts), this.configsTryCount, this.lifecycleService);
    }

    private AddressProvider createAddressProvider(ClientConfig clientConfig, DiscoveryService discoveryService) {
        ClientNetworkConfig networkConfig = clientConfig.getNetworkConfig();
        ClientCloudConfig cloudConfig = networkConfig.getCloudConfig();
        List<String> addresses = networkConfig.getAddresses();
        boolean addressListProvided = addresses.size() != 0;
        boolean awsDiscoveryEnabled = networkConfig.getAwsConfig() != null && networkConfig.getAwsConfig().isEnabled();
        boolean gcpDiscoveryEnabled = networkConfig.getGcpConfig() != null && networkConfig.getGcpConfig().isEnabled();
        boolean azureDiscoveryEnabled = networkConfig.getAzureConfig() != null && networkConfig.getAzureConfig().isEnabled();
        boolean kubernetesDiscoveryEnabled = networkConfig.getKubernetesConfig() != null && networkConfig.getKubernetesConfig().isEnabled();
        boolean eurekaDiscoveryEnabled = networkConfig.getEurekaConfig() != null && networkConfig.getEurekaConfig().isEnabled();
        boolean discoverySpiEnabled = this.discoverySpiEnabled(networkConfig);
        String cloudDiscoveryToken = this.properties.getString(ClientProperty.HAZELCAST_CLOUD_DISCOVERY_TOKEN);
        if (cloudDiscoveryToken != null && cloudConfig.isEnabled()) {
            throw new IllegalStateException("Ambiguous hazelcast.cloud configuration. Both property based and client configuration based settings are provided for Hazelcast cloud discovery together. Use only one.");
        }
        boolean hazelcastCloudEnabled = cloudDiscoveryToken != null || cloudConfig.isEnabled();
        this.isDiscoveryConfigurationConsistent(addressListProvided, awsDiscoveryEnabled, gcpDiscoveryEnabled, azureDiscoveryEnabled, kubernetesDiscoveryEnabled, eurekaDiscoveryEnabled, discoverySpiEnabled, hazelcastCloudEnabled);
        if (hazelcastCloudEnabled) {
            String discoveryToken = ClusterDiscoveryServiceBuilder.cloudDiscoveryToken(cloudConfig, cloudDiscoveryToken);
            String cloudUrlBase = this.properties.getString(HazelcastCloudDiscovery.CLOUD_URL_BASE_PROPERTY);
            String urlEndpoint = HazelcastCloudDiscovery.createUrlEndpoint(cloudUrlBase, discoveryToken);
            int connectionTimeoutMillis = this.getConnectionTimeoutMillis(networkConfig);
            HazelcastCloudDiscovery cloudDiscovery = new HazelcastCloudDiscovery(urlEndpoint, connectionTimeoutMillis);
            return new RemoteAddressProvider(cloudDiscovery::discoverNodes, true);
        }
        if (networkConfig.getAddresses().isEmpty() && discoveryService != null) {
            return new RemoteAddressProvider(() -> this.discoverAddresses(discoveryService), this.usePublicAddress(clientConfig));
        }
        TranslateToPublicAddressProvider toPublicAddressProvider = new TranslateToPublicAddressProvider(networkConfig, this.properties, this.loggingService.getLogger(TranslateToPublicAddressProvider.class));
        this.clusterService.addMembershipListener(toPublicAddressProvider);
        return new DefaultAddressProvider(networkConfig, toPublicAddressProvider);
    }

    private Map<Address, Address> discoverAddresses(DiscoveryService discoveryService) {
        Iterable<DiscoveryNode> discoveredNodes = Preconditions.checkNotNull(discoveryService.discoverNodes(), "Discovered nodes cannot be null!");
        HashMap<Address, Address> privateToPublic = new HashMap<Address, Address>();
        for (DiscoveryNode discoveryNode : discoveredNodes) {
            privateToPublic.put(discoveryNode.getPrivateAddress(), discoveryNode.getPublicAddress());
        }
        return privateToPublic;
    }

    private boolean discoverySpiEnabled(ClientNetworkConfig networkConfig) {
        return networkConfig.getDiscoveryConfig() != null && networkConfig.getDiscoveryConfig().isEnabled() || Boolean.parseBoolean(this.properties.getString(ClientProperty.DISCOVERY_SPI_ENABLED));
    }

    private boolean usePublicAddress(ClientConfig config) {
        return this.properties.getBoolean(ClientProperty.DISCOVERY_SPI_PUBLIC_IP_ENABLED) || AliasedDiscoveryConfigUtils.allUsePublicAddress(ClientAliasedDiscoveryConfigUtils.aliasedDiscoveryConfigsFrom(config.getNetworkConfig()));
    }

    private void isDiscoveryConfigurationConsistent(boolean addressListProvided, boolean awsDiscoveryEnabled, boolean gcpDiscoveryEnabled, boolean azureDiscoveryEnabled, boolean kubernetesDiscoveryEnabled, boolean eurekaDiscoveryEnabled, boolean discoverySpiEnabled, boolean hazelcastCloudEnabled) {
        ArrayList<String> enabledDiscoveries = new ArrayList<String>();
        int count = 0;
        if (addressListProvided) {
            ++count;
            enabledDiscoveries.add("cluster members given explicitly");
        }
        if (awsDiscoveryEnabled) {
            ++count;
            enabledDiscoveries.add("AWS discovery");
        }
        if (gcpDiscoveryEnabled) {
            ++count;
            enabledDiscoveries.add("GCP discovery");
        }
        if (azureDiscoveryEnabled) {
            ++count;
            enabledDiscoveries.add("Azure discovery");
        }
        if (kubernetesDiscoveryEnabled) {
            ++count;
            enabledDiscoveries.add("Kubernetes discovery");
        }
        if (eurekaDiscoveryEnabled) {
            ++count;
            enabledDiscoveries.add("Eureka discovery");
        }
        if (discoverySpiEnabled) {
            ++count;
            enabledDiscoveries.add("Discovery SPI");
        }
        if (hazelcastCloudEnabled) {
            ++count;
            enabledDiscoveries.add("Hazelcast Cloud");
        }
        if (count > 1) {
            throw new IllegalStateException("Only one discovery method can be enabled at a time. Keep only one of the following method enabled by removing the others from the configuration, or setting enabled to 'false': " + String.join((CharSequence)",", enabledDiscoveries));
        }
    }

    private static String cloudDiscoveryToken(ClientCloudConfig cloudConfig, String cloudDiscoveryToken) {
        if (cloudConfig.isEnabled()) {
            return cloudConfig.getDiscoveryToken();
        }
        return cloudDiscoveryToken;
    }

    private DiscoveryService initDiscoveryService(ClientConfig config) {
        List<DiscoveryStrategyConfig> aliasedDiscoveryConfigs = ClientAliasedDiscoveryConfigUtils.createDiscoveryStrategyConfigs(config);
        if (!this.properties.getBoolean(ClientProperty.DISCOVERY_SPI_ENABLED) && aliasedDiscoveryConfigs.isEmpty() && !config.getNetworkConfig().isAutoDetectionEnabled()) {
            return null;
        }
        ILogger logger2 = this.loggingService.getLogger(DiscoveryService.class);
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        DiscoveryConfigReadOnly discoveryConfig = new DiscoveryConfigReadOnly(networkConfig.getDiscoveryConfig());
        DiscoveryServiceProvider factory2 = discoveryConfig.getDiscoveryServiceProvider();
        if (factory2 == null) {
            factory2 = new DefaultDiscoveryServiceProvider();
        }
        boolean isAutoDetectionEnabled = networkConfig.isAutoDetectionEnabled();
        DiscoveryServiceSettings settings = new DiscoveryServiceSettings().setConfigClassLoader(config.getClassLoader()).setLogger(logger2).setDiscoveryMode(DiscoveryMode.Client).setAliasedDiscoveryConfigs(aliasedDiscoveryConfigs).setDiscoveryConfig(discoveryConfig).setAutoDetectionEnabled(isAutoDetectionEnabled);
        DiscoveryService discoveryService = factory2.newDiscoveryService(settings);
        if (isAutoDetectionEnabled && this.isEmptyDiscoveryStrategies(discoveryService)) {
            return null;
        }
        discoveryService.start();
        return discoveryService;
    }

    private boolean isEmptyDiscoveryStrategies(DiscoveryService discoveryService) {
        return discoveryService instanceof DefaultDiscoveryService && !((DefaultDiscoveryService)discoveryService).getDiscoveryStrategies().iterator().hasNext();
    }

    private ICredentialsFactory initCredentialsFactory(ClientConfig config) {
        ClientSecurityConfig securityConfig = config.getSecurityConfig();
        return securityConfig.asCredentialsFactory(config.getClassLoader());
    }

    private SocketInterceptor initSocketInterceptor(SocketInterceptorConfig sic) {
        if (sic != null && sic.isEnabled()) {
            return this.clientExtension.createSocketInterceptor(sic);
        }
        return null;
    }

    private int getConnectionTimeoutMillis(ClientNetworkConfig networkConfig) {
        int connTimeout = networkConfig.getConnectionTimeout();
        return connTimeout == 0 ? Integer.MAX_VALUE : connTimeout;
    }
}

