/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientFetchSchemaCodec;
import com.hazelcast.client.impl.protocol.codec.ClientSendAllSchemasCodec;
import com.hazelcast.client.impl.protocol.codec.ClientSendSchemaCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.SchemaService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class ClientSchemaService
implements SchemaService {
    public static final HazelcastProperty MAX_PUT_RETRY_COUNT = new HazelcastProperty("hazelcast.client.schema.max.put.retry.count", 100);
    private final HazelcastClientInstanceImpl client;
    private final Map<Long, Schema> schemas = new ConcurrentHashMap<Long, Schema>();
    private final ILogger logger;
    private final long retryPauseMillis;
    private final int maxPutRetryCount;

    public ClientSchemaService(HazelcastClientInstanceImpl client, ILogger logger2) {
        this.client = client;
        this.logger = logger2;
        HazelcastProperties properties = client.getProperties();
        this.retryPauseMillis = properties.getPositiveMillisOrDefault(ClientProperty.INVOCATION_RETRY_PAUSE_MILLIS);
        this.maxPutRetryCount = properties.getInteger(MAX_PUT_RETRY_COUNT);
    }

    @Override
    @Nullable
    public Schema get(long schemaId) {
        ClientInvocation invocation;
        ClientMessage message;
        Schema schema = this.schemas.get(schemaId);
        if (schema != null) {
            return schema;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Could not find schema id  " + schemaId + " locally, will search on the cluster" + schemaId);
        }
        if ((schema = ClientFetchSchemaCodec.decodeResponse(message = (ClientMessage)(invocation = new ClientInvocation(this.client, ClientFetchSchemaCodec.encodeRequest(schemaId), "schema-service")).invoke().joinInternal())) != null) {
            this.schemas.put(schemaId, schema);
        }
        return schema;
    }

    @Override
    public void put(Schema schema) {
        long schemaId = schema.getSchemaId();
        Schema existingSchema = this.schemas.get(schemaId);
        if (existingSchema != null) {
            return;
        }
        if (!this.replicateSchemaInCluster(schema)) {
            throw new IllegalStateException("The schema " + schema + " cannot be replicated in the cluster, after " + this.maxPutRetryCount + " retries. It might be the case that the client is connected to the two halves of the cluster that is experiencing a split-brain, and continue putting the data associated with that schema might result in data loss. It might be possible to replicate the schema after some time, when the cluster is healed.");
        }
        this.putIfAbsent(schema);
    }

    @Override
    public void putLocal(Schema schema) {
        this.putIfAbsent(schema);
    }

    private void putIfAbsent(Schema schema) {
        long schemaId = schema.getSchemaId();
        Schema existingSchema = this.schemas.putIfAbsent(schemaId, schema);
        if (existingSchema == null) {
            return;
        }
        if (!schema.equals(existingSchema)) {
            throw new IllegalStateException("Schema with schemaId " + schemaId + " already exists. existing schema " + existingSchema + "new schema " + schema);
        }
    }

    public void sendAllSchemas() {
        if (this.schemas.isEmpty()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("There is no schema to send to the cluster");
            }
            return;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Sending schemas to the cluster " + this.schemas);
        }
        ClientMessage clientMessage = ClientSendAllSchemasCodec.encodeRequest(new ArrayList<Schema>(this.schemas.values()));
        ClientInvocation invocation = new ClientInvocation(this.client, clientMessage, "schema-service");
        invocation.invokeUrgent().joinInternal();
    }

    public boolean hasAnySchemas() {
        return !this.schemas.isEmpty();
    }

    private boolean replicateSchemaInCluster(Schema schema) {
        ClientMessage clientMessage = ClientSendSchemaCodec.encodeRequest(schema);
        for (int i = 0; i < this.maxPutRetryCount; ++i) {
            block4: {
                ClientInvocation invocation = new ClientInvocation(this.client, clientMessage, "schema-service");
                ClientMessage response = (ClientMessage)invocation.invoke().joinInternal();
                Set<UUID> replicatedMemberUuids = ClientSendSchemaCodec.decodeResponse(response);
                Set<Member> members = this.client.getCluster().getMembers();
                for (Member member : members) {
                    if (replicatedMemberUuids.contains(member.getUuid())) continue;
                    try {
                        Thread.sleep(this.retryPauseMillis);
                        break block4;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return false;
                    }
                }
                return true;
            }
            clientMessage = clientMessage.copyMessageWithSharedNonInitialFrames();
        }
        return false;
    }
}

