/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.cache.EventJournalCacheEvent;
import com.hazelcast.cache.impl.CacheEntryProcessorResult;
import com.hazelcast.cache.impl.CacheEventListenerAdaptor;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.CacheSyncListenerCompleter;
import com.hazelcast.cache.impl.event.CachePartitionLostListener;
import com.hazelcast.client.cache.impl.ClientCacheIterator;
import com.hazelcast.client.cache.impl.ClientCachePartitionIterable;
import com.hazelcast.client.cache.impl.ClientCachePartitionIterator;
import com.hazelcast.client.cache.impl.ClientCacheProxySupport;
import com.hazelcast.client.cache.impl.ClientCacheProxySupportUtil;
import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheEventJournalReadCodec;
import com.hazelcast.client.impl.protocol.codec.CacheEventJournalSubscribeCodec;
import com.hazelcast.client.impl.protocol.codec.CacheSizeCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.internal.config.CacheConfigReadOnly;
import com.hazelcast.internal.journal.EventJournalInitialSubscriberState;
import com.hazelcast.internal.journal.EventJournalReader;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.ringbuffer.ReadResultSet;
import com.hazelcast.ringbuffer.impl.ReadResultSetImpl;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;

public class ClientCacheProxy<K, V>
extends ClientCacheProxySupport<K, V>
implements EventJournalReader<EventJournalCacheEvent<K, V>>,
CacheSyncListenerCompleter {
    private ClientMessageDecoder eventJournalReadResponseDecoder;
    private ClientMessageDecoder eventJournalSubscribeResponseDecoder;

    public ClientCacheProxy(CacheConfig<K, V> cacheConfig, ClientContext context) {
        super(cacheConfig, context);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.eventJournalReadResponseDecoder = message -> {
            CacheEventJournalReadCodec.ResponseParameters params = CacheEventJournalReadCodec.decodeResponse(message);
            ReadResultSetImpl resultSet = new ReadResultSetImpl(params.readCount, params.items, params.itemSeqs, params.nextSeq);
            resultSet.setSerializationService(this.getSerializationService());
            return resultSet;
        };
        this.eventJournalSubscribeResponseDecoder = message -> {
            CacheEventJournalSubscribeCodec.ResponseParameters resp = CacheEventJournalSubscribeCodec.decodeResponse(message);
            return new EventJournalInitialSubscriberState(resp.oldestSequence, resp.newestSequence);
        };
    }

    public V get(K key) {
        return this.get(key, null);
    }

    public Map<K, V> getAll(Set<? extends K> keys2) {
        return this.getAll(keys2, null);
    }

    public boolean containsKey(K key) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        return this.containsKeyInternal(key);
    }

    public void loadAll(Set<? extends K> keys2, boolean replaceExistingValues, CompletionListener completionListener) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys2);
        ArrayList<Data> dataKeys = new ArrayList<Data>(keys2.size());
        for (K key : keys2) {
            CacheProxyUtil.validateNotNull(key);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key);
            dataKeys.add(this.toData(key));
        }
        this.loadAllInternal(keys2, dataKeys, replaceExistingValues, completionListener);
    }

    public void put(K key, V value) {
        this.put(key, value, null);
    }

    public V getAndPut(K key, V value) {
        return this.getAndPut(key, value, null);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAll(map, null);
    }

    public boolean putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, null);
    }

    public boolean remove(K key) {
        try {
            return this.removeSync(key, null, false, true);
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    public boolean remove(K key, V oldValue) {
        try {
            return this.removeSync(key, oldValue, true, true);
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    public V getAndRemove(K key) {
        try {
            return (V)this.toObject(this.getAndRemoveSyncInternal(key));
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.replace(key, oldValue, newValue, null);
    }

    public boolean replace(K key, V value) {
        return this.replace(key, value, (ExpiryPolicy)null);
    }

    public V getAndReplace(K key, V value) {
        return this.getAndReplace(key, value, null);
    }

    public void removeAll(Set<? extends K> keys2) {
        long startNanos = this.nowInNanosOrDefault();
        this.ensureOpen();
        Preconditions.checkNotNull(keys2, "Null key is not allowed!");
        if (keys2.isEmpty()) {
            return;
        }
        ArrayList<Data> dataKeys = new ArrayList<Data>(keys2.size());
        CollectionUtil.objectToDataCollection(keys2, dataKeys, this.getSerializationService(), "Null key is not allowed!");
        this.removeAllKeysInternal(keys2, dataKeys, startNanos);
    }

    public void removeAll() {
        this.ensureOpen();
        this.removeAllInternal();
    }

    public void clear() {
        this.ensureOpen();
        this.clearInternal();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        if (clazz.isInstance(this.cacheConfig)) {
            return (C)((Configuration)clazz.cast(new CacheConfigReadOnly(this.cacheConfig)));
        }
        throw new IllegalArgumentException("The configuration class " + clazz + " is not supported by this implementation");
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        if (entryProcessor == null) {
            throw new NullPointerException("Entry Processor is null");
        }
        Data epData = this.toData(entryProcessor);
        return (T)this.invokeInternal(key, epData, arguments);
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys2, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys2);
        if (entryProcessor == null) {
            throw new NullPointerException("Entry Processor is null");
        }
        Map<K, CacheEntryProcessorResult<T>> allResult = MapUtil.createHashMap(keys2.size());
        for (K key : keys2) {
            CacheEntryProcessorResult<T> cepResult;
            CacheProxyUtil.validateNotNull(key);
            try {
                T result = this.invoke(key, entryProcessor, arguments);
                cepResult = result != null ? new CacheEntryProcessorResult<T>(result) : null;
            }
            catch (Exception e) {
                cepResult = new CacheEntryProcessorResult<T>(e);
            }
            if (cepResult == null) continue;
            allResult.put(key, cepResult);
        }
        return allResult;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to " + clazz + " is not supported by this implementation");
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.registerCacheEntryListener(cacheEntryListenerConfiguration, true);
    }

    @Override
    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, boolean addToConfig) {
        this.ensureOpen();
        if (cacheEntryListenerConfiguration == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        CacheEventListenerAdaptor<K, V> adaptor = new CacheEventListenerAdaptor<K, V>(this, cacheEntryListenerConfiguration, this.getSerializationService());
        UUID regId = this.getContext().getListenerService().registerListener(ClientCacheProxySupportUtil.createCacheEntryListenerCodec(this.nameWithPrefix), ClientCacheProxySupportUtil.createHandler(adaptor));
        if (addToConfig) {
            this.cacheConfig.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
        }
        this.addListenerLocally(regId, cacheEntryListenerConfiguration, adaptor);
        if (addToConfig) {
            this.updateCacheListenerConfigOnOtherNodes(cacheEntryListenerConfiguration, true);
        }
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (cacheEntryListenerConfiguration == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        UUID regId = this.getListenerIdLocal(cacheEntryListenerConfiguration);
        if (regId == null) {
            return;
        }
        boolean isDeregistered = this.getContext().getListenerService().deregisterListener(regId);
        if (isDeregistered) {
            this.removeListenerLocally(cacheEntryListenerConfiguration);
            this.cacheConfig.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
            this.updateCacheListenerConfigOnOtherNodes(cacheEntryListenerConfiguration, false);
        }
    }

    @Nonnull
    public Iterator<Cache.Entry<K, V>> iterator() {
        this.ensureOpen();
        return new ClientCacheIterator(this, this.getContext(), false);
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator(int fetchSize) {
        this.ensureOpen();
        return new ClientCacheIterator(this, this.getContext(), fetchSize, false);
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator(int fetchSize, int partitionId, boolean prefetchValues) {
        this.ensureOpen();
        return new ClientCachePartitionIterator(this, this.getContext(), fetchSize, partitionId, prefetchValues);
    }

    @Override
    public Iterable<Cache.Entry<K, V>> iterable(int fetchSize, int partitionId, boolean prefetchValues) {
        return new ClientCachePartitionIterable(this, this.getContext(), fetchSize, partitionId, prefetchValues);
    }

    @Override
    public UUID addPartitionLostListener(CachePartitionLostListener listener) {
        ClientCacheProxySupportUtil.ClientCachePartitionLostEventHandler handler = new ClientCacheProxySupportUtil.ClientCachePartitionLostEventHandler(this.name, this.getContext(), this.injectDependencies(listener));
        return this.getContext().getListenerService().registerListener(ClientCacheProxySupportUtil.createPartitionLostListenerCodec(this.name), handler);
    }

    @Override
    public boolean removePartitionLostListener(UUID id) {
        return this.getContext().getListenerService().deregisterListener(id);
    }

    public InternalCompletableFuture<EventJournalInitialSubscriberState> subscribeToEventJournal(int partitionId) {
        ClientMessage request = CacheEventJournalSubscribeCodec.encodeRequest(this.nameWithPrefix);
        ClientInvocationFuture fut = new ClientInvocation(this.getClient(), request, (Object)this.getName(), partitionId).invoke();
        return new ClientDelegatingFuture<EventJournalInitialSubscriberState>(fut, this.getSerializationService(), this.eventJournalSubscribeResponseDecoder);
    }

    @Override
    public <T> InternalCompletableFuture<ReadResultSet<T>> readFromEventJournal(long startSequence, int minSize, int maxSize, int partitionId, Predicate<? super EventJournalCacheEvent<K, V>> predicate, Function<? super EventJournalCacheEvent<K, V>, ? extends T> projection) {
        if (maxSize < minSize) {
            throw new IllegalArgumentException("maxSize " + maxSize + " must be greater or equal to minSize " + minSize);
        }
        SerializationService ss = this.getSerializationService();
        ClientMessage request = CacheEventJournalReadCodec.encodeRequest(this.nameWithPrefix, startSequence, minSize, maxSize, ss.toData(predicate), ss.toData(projection));
        ClientInvocationFuture fut = new ClientInvocation(this.getClient(), request, (Object)this.getName(), partitionId).invoke();
        return new ClientDelegatingFuture<ReadResultSet<T>>(fut, ss, this.eventJournalReadResponseDecoder);
    }

    @Override
    public CompletableFuture<V> getAsync(K key) {
        return this.getAsync((Object)key, (ExpiryPolicy)null);
    }

    @Override
    public CompletableFuture<V> getAsync(K key, ExpiryPolicy expiryPolicy) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        return this.getAsyncInternal(key, expiryPolicy);
    }

    public CompletableFuture<Void> putAsync(K key, V value) {
        return this.putAsync((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public CompletableFuture<Void> putAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putAsyncInternal(key, value, expiryPolicy, false, true);
    }

    public CompletableFuture<Boolean> putIfAbsentAsync(K key, V value) {
        return this.putIfAbsentAsync(key, value, null, false);
    }

    public CompletableFuture<Boolean> putIfAbsentAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putIfAbsentAsync(key, value, expiryPolicy, false);
    }

    @Override
    public CompletableFuture<V> getAndPutAsync(K key, V value) {
        return this.getAndPutAsync((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    @Override
    public CompletableFuture<V> getAndPutAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putAsyncInternal(key, value, expiryPolicy, true, false);
    }

    public CompletableFuture<Boolean> removeAsync(K key) {
        return this.removeAsync(key, null, false, false);
    }

    public CompletableFuture<Boolean> removeAsync(K key, V oldValue) {
        return this.removeAsync(key, oldValue, true, false);
    }

    @Override
    public CompletableFuture<V> getAndRemoveAsync(K key) {
        return this.getAndRemoveAsyncInternal(key);
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V value) {
        return this.replaceAsync(key, null, value, null, false, false);
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.replaceAsync(key, null, value, expiryPolicy, false, false);
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsync(key, oldValue, newValue, null, true, false);
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy) {
        return this.replaceAsync(key, oldValue, newValue, expiryPolicy, true, false);
    }

    @Override
    public CompletableFuture<V> getAndReplaceAsync(K key, V value) {
        return this.getAndReplaceAsync(key, null, value, null, false, false);
    }

    @Override
    public CompletableFuture<V> getAndReplaceAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.getAndReplaceAsync(key, null, value, expiryPolicy, false, false);
    }

    @Override
    public V get(K key, ExpiryPolicy expiryPolicy) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        return (V)this.toObject(this.callGetSync(key, expiryPolicy));
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys2, ExpiryPolicy expiryPolicy) {
        long startNanos = this.nowInNanosOrDefault();
        this.ensureOpen();
        Preconditions.checkNotNull(keys2, "Null key is not allowed!");
        if (keys2.isEmpty()) {
            return Collections.emptyMap();
        }
        int keysSize = keys2.size();
        LinkedList<Data> dataKeys = new LinkedList<Data>();
        ArrayList<Object> resultingKeyValuePairs = new ArrayList<Object>(keysSize * 2);
        this.getAllInternal(keys2, dataKeys, expiryPolicy, resultingKeyValuePairs, startNanos);
        Map result = MapUtil.createHashMap(keysSize);
        int i = 0;
        while (i < resultingKeyValuePairs.size()) {
            Object key = this.toObject(resultingKeyValuePairs.get(i++));
            Object value = this.toObject(resultingKeyValuePairs.get(i++));
            result.put(key, value);
        }
        return result;
    }

    @Override
    public void put(K key, V value, ExpiryPolicy expiryPolicy) {
        this.putSyncInternal(key, value, expiryPolicy, false);
    }

    @Override
    public V getAndPut(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putSyncInternal(key, value, expiryPolicy, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, ExpiryPolicy expiryPolicy) {
        long startNanos = this.nowInNanosOrDefault();
        this.ensureOpen();
        Preconditions.checkNotNull(map, "map is null");
        if (map.isEmpty()) {
            return;
        }
        this.putAllInternal(map, expiryPolicy, new List[this.partitionCount], startNanos);
    }

    @Override
    public void setExpiryPolicy(Set<? extends K> keys2, ExpiryPolicy policy) {
        this.ensureOpen();
        Preconditions.checkNotNull(keys2);
        Preconditions.checkNotNull(policy);
        if (keys2.isEmpty()) {
            return;
        }
        this.setExpiryPolicyInternal(keys2, policy);
    }

    @Override
    public boolean setExpiryPolicy(K key, ExpiryPolicy expiryPolicy) {
        return this.setExpiryPolicyInternal(key, expiryPolicy);
    }

    @Override
    public boolean putIfAbsent(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putIfAbsentSync(key, value, expiryPolicy, true);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy) {
        return this.replaceSync(key, oldValue, newValue, expiryPolicy, true);
    }

    @Override
    public boolean replace(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.replaceSync(key, null, value, expiryPolicy, false);
    }

    @Override
    public V getAndReplace(K key, V value, ExpiryPolicy expiryPolicy) {
        try {
            return this.getAndReplaceSync(key, null, value, expiryPolicy, false, true);
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public int size() {
        this.ensureOpen();
        try {
            ClientMessage request = CacheSizeCodec.encodeRequest(this.nameWithPrefix);
            ClientMessage resultMessage = (ClientMessage)this.invoke(request);
            return CacheSizeCodec.decodeResponse(resultMessage);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(t, CacheException.class);
        }
    }

    @Override
    public CacheStatistics getLocalCacheStatistics() {
        return this.statsHandler.getStatistics();
    }

    public String toString() {
        return this.getClass().getName() + "{name=" + this.name + ", nameWithPrefix=" + this.nameWithPrefix + '}';
    }
}

