/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.LocalCache;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.Nullable;

interface LocalManualCache<C extends LocalCache<K, V>, K, V>
extends Cache<K, V> {
    public C cache();

    @Override
    default public long estimatedSize() {
        return this.cache().estimatedSize();
    }

    @Override
    default public void cleanUp() {
        this.cache().cleanUp();
    }

    @Override
    @Nullable
    default public V getIfPresent(Object key) {
        return this.cache().getIfPresent(key, true);
    }

    @Override
    @Nullable
    default public V get(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.cache().computeIfAbsent(key, mappingFunction);
    }

    @Override
    default public Map<K, V> getAllPresent(Iterable<?> keys2) {
        return this.cache().getAllPresent(keys2);
    }

    @Override
    default public void put(K key, V value) {
        this.cache().put(key, value);
    }

    @Override
    default public void putAll(Map<? extends K, ? extends V> map) {
        this.cache().putAll(map);
    }

    @Override
    default public void invalidate(Object key) {
        this.cache().remove(key);
    }

    @Override
    default public void invalidateAll(Iterable<?> keys2) {
        this.cache().invalidateAll(keys2);
    }

    @Override
    default public void invalidateAll() {
        this.cache().clear();
    }

    @Override
    default public CacheStats stats() {
        return this.cache().statsCounter().snapshot();
    }

    @Override
    default public ConcurrentMap<K, V> asMap() {
        return this.cache();
    }
}

