// Copyright (c) Microsoft. All rights reserved.

package com.microsoft.trouterclient.registration;

import android.support.annotation.Nullable;
import android.util.Log;

import com.microsoft.trouterclient.ITrouterAuthHeadersProvider;
import com.microsoft.trouterclient.ITrouterAuthHeadersSetter;

/**
 * Adapter of ISkypetokenProvider to ITrouterAuthHeadersProvider
 * For the convenience of using ISkypetokenProvider for both Trouter client and Registration authentication
 */
public class TrouterSkypetokenAuthHeaderProvider implements ITrouterAuthHeadersProvider {
    private ISkypetokenProvider skypetokenProvider;
    private static final String TAG = "TrouterSkypetokenAuthHeaderProvider";

    public TrouterSkypetokenAuthHeaderProvider(ISkypetokenProvider skypetokenProvider) {
        if (skypetokenProvider == null) {
            throw new IllegalArgumentException("skypetokenProvider is mandatory dependency");
        } else {
            this.skypetokenProvider = skypetokenProvider;
        }
    }

    @Override
    public void getAuthHeaders(boolean forceRefresh, ITrouterAuthHeadersSetter trouterAuthHeadersSetter) {
        @Nullable String skypetoken = skypetokenProvider.getSkypetoken(forceRefresh);
        if (skypetoken != null) {
            final String authHeader = "X-Skypetoken: " + skypetoken;
            trouterAuthHeadersSetter.set(authHeader);
        } else {
            Log.w(TAG, "getAuthHeaders: got null skypetoken");
        }
    }
}
