// Copyright (c) Microsoft. All rights reserved.

package com.microsoft.trouterclient.registration;

import android.support.annotation.Nullable;

/**
 * Represents a callback for trouter registrar client to acquire authentication token for its requests
 */
public interface ISkypetokenProvider {
    /**
     * Called back whenever Registrar client needs X-Skypetoken auth header value for its next request
     * It is recommended that auth tokens are cached in the upper layer and returned immediately
     *
     * forceRefresh parameter is set to true when Registrar client hits 401 Unauthorized error
     * which may indicate an expired or revoked token so the hint is to ask for new token
     * to be issued instead of returning cached one
     *
     * @param forceRefresh Signals the current token is known to be invalid
     * @return New Skypetoken to use, or null if it is not possible to obtain the Skypetoken.
     * In case null is returned, the operation that needs the Skypetoken will not continue.
     */
    @Nullable
    public String getSkypetoken(boolean forceRefresh);
}
