// Copyright (c) Microsoft. All rights reserved.

package com.microsoft.trouterclient;

/** Activity states that a user can be in on an endpoint */
public enum UserActivityState {
    ACTIVITY_UNKNOWN(0),   /// Initial state
    ACTIVITY_ACTIVE(1),    /// User is active according to the application
    ACTIVITY_INACTIVE(2);  /// User is not active according to the application

    UserActivityState(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    private final int value;
}
