// Copyright (c) Microsoft. All rights reserved.

package com.microsoft.trouterclient;

public enum MessageSendStatusCode {
    RESPONSE_SENT(0),        /// Response to be sent to Trouter server (no guarantee of delivery)
    RESPONSE_TIMEOUT(1),     /// Response sent after client generated a synthetic 504
                             /// (N/A for the Java/JNI wrapper, will be reported as RESPONSE_DUPLICATE instead)
    RESPONSE_DUPLICATE(2),   /// Send called multiple times on this message
    RESPONSE_INCOMPLETE(3),  /// Mandatory parameters (status) not set
    TROUTER_DISCONNECTED(4); /// Trouter server connection lost

    MessageSendStatusCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    public static MessageSendStatusCode fromInteger(int value)
    {
        for (MessageSendStatusCode item : values()) {
            if (item.value == value) {
                return item;
            }
        }
        throw new IllegalArgumentException();
    }

    private final int value;
}
