// Copyright (c) Microsoft. All rights reserved.

package com.microsoft.trouterclient;

/**
 * Represents a response to be sent back from an application level component.
 */
public interface ITrouterResponse extends ITrouterHttpMessage {
    /**
     * Retrieve an unique ID of this response.
     * @return The response ID
     */
    public long getId();

    /**
     * Set a HTTP-like headers to be returned to the caller.
     * Even without setting any custom headers, Trouter client and service
     * set some basic headers by themselves.
     * @param header Header name
     * @param value Header value
     */
    public void setHeader(String header, String value);

    /**
     * Set the HTTP-like status code to be returned to the caller.
     * You must call this method before replying the request with send().
     * @param statusCode HTTP-like status code
     */
    public void setStatus(int statusCode);

    /**
     * Retrieve the HTTP-like status code to be returned to the caller.
     * @return The HTTP-like status code
     */
    public int getStatusCode();

    /**
     * Set the body/content of the response to be returned to the caller.
     * By default the body is empty.
     * @param data New response body
     */
    public void setBody(String data);

    /**
     * Send the response back to the caller.
     * This will let the local Trouter client tell the Trouter service to reply
     * the original caller's request with the set status code, headers and body.
     * @return Result of the operation
     */
    public MessageSendStatusCode send();
}
