// Copyright (c) Microsoft. All rights reserved.

package com.microsoft.trouterclient;

/**
 * Represents a Trouter request. Created after a listener is identified for an incoming server request
 */
public interface ITrouterRequest extends ITrouterHttpMessage {
    /**
     * Gets the part of the url after the service url and the routing path. This will include any query parameters
     * For example, from the URL baseEndpointUrl/listenerPath/v1/getStatus, this returns "/v1/getStatus"
     * @return The relative path
     */
    public String getUrlPathComponent();

    /**
     * Gets the HTTP-like method name used by the caller.
     * @return The HTTP-like method name
     */
    public String getMethod();
}
