// Copyright (c) Microsoft. All rights reserved.

package com.microsoft.trouterclient;

/**
 * Information about the current Trouter connection
 *
 * Received in `ITrouterListener::onTrouterConnected()` every time the
 * connection parameters change.
 */
public interface ITrouterConnectionInfo {
    /**
     * Base URL used for routing messages from services to this client instance,
     * i.e. not specific to a particular listener
     * @return Base endpoint URL
     */
    public String getBaseEndpointUrl();

    /**
     * Tells if this `baseEndpointUrl` is different from the previous one and
     * therefore if any dependent service registrations need to be updated to
     * know where to send data
     * @return Whether the endpoint URL changed
     */
    public boolean isNewEndpointUrl();

    /**
     * Base URL prefix used for routing messages from clients to this client -
     * replace the URL base (protocol + hostname) of `baseEndpointUrl` (or
     * another per-listener endpoint URL) with this value to obtain the full
     * client-to-client URL - see also `TrouterUtils.replaceUrlBase()`.
     * @return Client-to-client URL base
     */
    public String getC2cUrlBase();

    /**
     * ID of this Trouter client, should stay the same between reconnects
     * @return Client ID
     */
    public String getClientId();

    /**
     * ID of the current Trouter connection, can change between reconnects
     * @return Connection ID
     */
    public String getConnectionId();

    /**
     * Expected lifetime of the current connection (ID) in seconds, as
     * determined by Trouter Service
     * @return Expected connection lifetime in seconds
     */
    public int getConnectionTtlSec();
}
