// Copyright (c) Microsoft. All rights reserved.

package com.microsoft.trouterclient;

/**
 * Represents a callback for trouter client to store and load connection data.
 * Storing that data allows Trouter Client to reconnect to the service quicker
 * and preserves Trouter URL.
 *
 * It can even be a simple in-memory storage for applications that start/stop
 * Trouter client often during its lifetime
 *
 * !!! It is important to carefully separate data for applications with
 *  multiple Trouter connections (e.g. multi user login)
 */
public interface ITrouterConnectionDataCache {
    /**
     * Called when trouter establishes new connection or is forced to reconnect to a new DC
     * @param data Opaque connection data to store
     */
    public void store(String data);

    /**
     * Called when trouter starts up and checks if it can reconnect instead of
     * establishing brand new connection
     * @return Loaded opaque connection data or an empty string if not available
     */
    public String load();
}
