// Copyright (c) Microsoft. All rights reserved.

package com.microsoft.trouterclient;

/**
 * Represents a setter of authentication headers for trouter client requests.
 * Created for convenience of each call back to ITrouterAuthHeadersProvider
 */
public interface ITrouterAuthHeadersSetter {
    /**
     * Sets the authentication headers for trouter client request
     * Can be safely called from within  ITrouterAuthHeadersProvider.getAuthHeaders()
     *
     * Example of the authHeaders value to set is:
     *   "X-Skypetoken: eyJhbGc..."
     *
     * @param authHeaders New authentication headers to use
     */
    public void set(String authHeaders);
}
