// Copyright (c) Microsoft. All rights reserved.

package com.microsoft.trouterclient;

/**
 * Represents a callback for trouter client to acquire authentication headers for its requests
 */
public interface ITrouterAuthHeadersProvider {
    /**
     * Called back whenever Trouter client needs authentication headers for its next request
     * It is recommended that auth tokens are cached in the upper layer and returned immediately
     *
     * forceRefresh parameter is set to true when Trouter client hits 401 Unauthorized error
     * which may indicate an expired or revoked token so the hint is to ask for new token
     * to be issued instead of returning cached one
     *
     * @param forceRefresh Signals the current authentication parameters are known to be invalid
     * @param authHeaders Callback for setting new authentication headers
     */
    public void getAuthHeaders(boolean forceRefresh, ITrouterAuthHeadersSetter authHeaders);
}
