// Copyright (c) Microsoft. All rights reserved.

package com.microsoft.trouterclient;

import com.microsoft.trouterclient.registration.TrouterUrlRegistrar;

/**
 * This Java object represents self hosted Trouter Client
 * i.e. client which lifecycle can be directly managed
 * unlike trouter client hosted by SlimCore
 */
public abstract class ISelfHostedTrouterClient extends ITrouter {
    /**
     * Starts client connection to the Trouter service
     *
     * Throws IllegalStateException if called after close()
     */
    public abstract void start();

    /**
     * Gracefully disconnects client from the service
     * It does not reset listener registrations, those stay active
     *
     * Throws IllegalStateException if called after close()
     */
    public abstract void stop();

    /**
     * Disconnects client from the service if it was stared
     * Disposes all native objects associated with that instance of a client
     * Which makes it unusable afterwards
     *
     * Throws IllegalStateException if called after close()
     */
    public abstract void close();

    /**
     * Attaches registrar component that will track Trouter connection
     * and automatically register it.
     * Must be done before starting the client
     * @param registrar TrouterUrlRegistrar instance to use
     */
    public abstract void withRegistrar(TrouterUrlRegistrar registrar);
}
