/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.semanticfunctions;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.semantickernel.plugin.KernelPluginFactory;
import java.util.Objects;
import javax.annotation.Nullable;

public class InputVariable {
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String defaultValue;
    private final boolean isRequired;
    private final String type;

    @JsonCreator
    public InputVariable(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="default") @Nullable String defaultValue, @JsonAlias(value={"required", "is_required"}) @JsonProperty(value="is_required") boolean isRequired) {
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
        this.isRequired = isRequired;
        if (type == null) {
            type = "java.lang.String";
        }
        this.type = type;
    }

    public InputVariable(String name) {
        this.name = name;
        this.type = String.class.getName();
        this.description = null;
        this.defaultValue = null;
        this.isRequired = true;
    }

    public static InputVariable build(String name, Class<?> type, @Nullable String description, @Nullable String defaultValue, boolean required) {
        return new InputVariable(name, type.getName(), description, defaultValue, required);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public String getType() {
        return this.type;
    }

    public Class<?> getTypeClass() {
        return KernelPluginFactory.getTypeForName(this.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.description, this.defaultValue, this.isRequired);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        InputVariable other = (InputVariable)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.defaultValue, other.defaultValue)) {
            return false;
        }
        return this.isRequired == other.isRequired;
    }
}

