/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.semantickernel.contextvariables.CaseInsensitiveMap;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.implementation.EmbeddedResourceLoader;
import com.microsoft.semantickernel.plugin.KernelPlugin;
import com.microsoft.semantickernel.semanticfunctions.InputVariable;
import com.microsoft.semantickernel.semanticfunctions.KernelFunction;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionFromMethod;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionFromPrompt;
import com.microsoft.semantickernel.semanticfunctions.KernelPromptTemplateFactory;
import com.microsoft.semantickernel.semanticfunctions.OutputVariable;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplate;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateConfig;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateFactory;
import com.microsoft.semantickernel.semanticfunctions.annotations.DefineKernelFunction;
import com.microsoft.semantickernel.semanticfunctions.annotations.KernelFunctionParameter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelPluginFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(KernelPluginFactory.class);
    private static final String CONFIG_FILE = "config.json";
    private static final String PROMPT_FILE = "skprompt.txt";
    private static final CaseInsensitiveMap<Class<?>> PRIMATIVE_CLASS_NAMES = new CaseInsensitiveMap();
    private static final CaseInsensitiveMap<Class<?>> COMMON_CLASS_NAMES = new CaseInsensitiveMap();
    private static final Map<Class<?>, Class<?>> BOXED_FROM_PRIMATIVE = new HashMap();

    public static KernelPlugin createFromObject(Object target, String pluginName) {
        List methods = Arrays.stream(target.getClass().getMethods()).filter(method -> method.isAnnotationPresent(DefineKernelFunction.class)).map(method -> {
            DefineKernelFunction annotation = method.getAnnotation(DefineKernelFunction.class);
            Class<?> returnType = KernelPluginFactory.getReturnType(annotation, method);
            OutputVariable kernelReturnParameterMetadata = new OutputVariable(annotation.returnDescription(), returnType);
            KernelFunctionFromMethod.Builder builder = KernelFunction.createFromMethod(method, target).withParameters(KernelPluginFactory.getParameters(method)).withReturnParameter(kernelReturnParameterMetadata);
            if (pluginName != null && !pluginName.isEmpty()) {
                builder = builder.withPluginName(pluginName);
            }
            if (annotation.name() != null && !annotation.name().isEmpty()) {
                builder = builder.withFunctionName(annotation.name());
            }
            if (annotation.description() != null && !annotation.description().isEmpty()) {
                builder = builder.withDescription(annotation.description());
            }
            return builder.build();
        }).collect(ArrayList::new, (list, it) -> list.add(it), (a, b) -> a.addAll(b));
        return KernelPluginFactory.createFromFunctions(pluginName, methods);
    }

    private static Class<?> getReturnType(DefineKernelFunction annotation, Method method) {
        Class<?> returnType = null;
        if (annotation.returnType().isEmpty()) {
            returnType = method.getReturnType();
            if (Publisher.class.isAssignableFrom(returnType)) {
                throw new SKException("Method: " + method.getDeclaringClass().getName() + "." + method.getName() + ", this is an async method, It is required to add an annotation to specify the return type");
            }
        } else {
            String className = annotation.returnType();
            if (method.getReturnType().getName().equals(className)) {
                return method.getReturnType();
            }
            try {
                returnType = Thread.currentThread().getContextClassLoader().loadClass(annotation.returnType());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (returnType == null) {
                returnType = KernelPluginFactory.getCommonTypeAlias(method, className);
            }
            if (returnType == null) {
                throw new SKException("Could not find return type " + annotation.returnType() + "  is not found on method " + method.getDeclaringClass().getName() + "." + method.getName());
            }
            if (!Publisher.class.isAssignableFrom(method.getReturnType()) && !returnType.isAssignableFrom(method.getReturnType())) {
                throw new SKException("Return type " + returnType.getName() + " is not assignable from " + method.getReturnType());
            }
        }
        return returnType;
    }

    @Nullable
    private static Class<?> getCommonTypeAlias(Method method, String className) {
        Class<?> returnType = PRIMATIVE_CLASS_NAMES.get(className);
        if (returnType == null) {
            returnType = COMMON_CLASS_NAMES.get(className);
        }
        if (returnType != null && Publisher.class.isAssignableFrom(method.getReturnType())) {
            return returnType;
        }
        if (returnType != null && !returnType.isAssignableFrom(method.getReturnType())) {
            returnType = BOXED_FROM_PRIMATIVE.get(returnType);
        }
        return returnType;
    }

    public static Class<?> getTypeForName(String className) {
        Class<?> clazz = PRIMATIVE_CLASS_NAMES.get(className);
        if (clazz == null) {
            clazz = COMMON_CLASS_NAMES.get(className);
        }
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = KernelPluginFactory.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            throw new SKException("Requested type could not be found: " + className + ". This needs to be a fully qualified class name, e.g. 'java.lang.String'.");
        }
        return clazz;
    }

    public static KernelPlugin createFromFunctions(String pluginName, @Nullable List<KernelFunction<?>> functions) {
        return KernelPluginFactory.createFromFunctions(pluginName, null, functions);
    }

    public static KernelPlugin createFromFunctions(String pluginName, @Nullable String description, @Nullable List<KernelFunction<?>> functions) {
        Map<String, KernelFunction<Object>> funcs = new HashMap();
        if (functions != null) {
            funcs = functions.stream().collect(Collectors.toMap(KernelFunction::getName, f -> f));
        }
        return new KernelPlugin(pluginName, description, funcs);
    }

    private static List<InputVariable> getParameters(Method method) {
        return Arrays.stream(method.getParameters()).filter(parameter -> parameter.isAnnotationPresent(KernelFunctionParameter.class)).map(parameter -> {
            KernelFunctionParameter annotation = parameter.getAnnotation(KernelFunctionParameter.class);
            return InputVariable.build(annotation.name(), annotation.type(), annotation.description(), annotation.defaultValue(), annotation.required());
        }).collect(Collectors.toList());
    }

    public static KernelPlugin importPluginFromDirectory(Path parentDirectory, String pluginDirectoryName, @Nullable PromptTemplateFactory promptTemplateFactory) {
        File pluginDir = new File(parentDirectory.toFile(), pluginDirectoryName);
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            throw new SKException("Could not find directory " + pluginDir.getAbsolutePath());
        }
        File[] files = pluginDir.listFiles(File::isDirectory);
        if (files == null) {
            throw new SKException("No Plugins found in directory " + pluginDir.getAbsolutePath());
        }
        CaseInsensitiveMap plugins = new CaseInsensitiveMap();
        for (File dir : files) {
            try {
                File configPath;
                File promptPath = new File(dir, PROMPT_FILE);
                if (!promptPath.exists() || !(configPath = new File(dir, CONFIG_FILE)).exists()) continue;
                KernelFunction<?> plugin = KernelPluginFactory.getKernelFunction(dir.getName(), promptTemplateFactory, configPath, promptPath);
                plugins.put(dir.getName(), plugin);
            }
            catch (IOException e) {
                LOGGER.error("Failed to read file", (Throwable)e);
            }
        }
        return new KernelPlugin(pluginDirectoryName, null, plugins);
    }

    private static KernelFunction<?> getKernelFunction(@Nullable String functionName, @Nullable PromptTemplateFactory promptTemplateFactory, File configPath, File promptPath) throws IOException {
        try {
            PromptTemplateConfig config = (PromptTemplateConfig)new ObjectMapper().readValue(configPath, PromptTemplateConfig.class);
            String template = new String(Files.readAllBytes(promptPath.toPath()), Charset.defaultCharset());
            return KernelPluginFactory.getKernelFunction(functionName, promptTemplateFactory, config, template);
        }
        catch (Exception e) {
            LOGGER.error("Failed to read file " + configPath.getAbsolutePath(), (Throwable)e);
            throw new SKException("Failed to read function " + configPath.getAbsolutePath(), e);
        }
    }

    private static <T> KernelFunction<T> getKernelFunction(@Nullable String functionName, @Nullable PromptTemplateFactory promptTemplateFactory, PromptTemplateConfig config, String template) {
        config = config.copy().withTemplate(template).build();
        PromptTemplate promptTemplate = promptTemplateFactory != null ? promptTemplateFactory.tryCreate(config) : new KernelPromptTemplateFactory().tryCreate(config);
        if (config.getName() != null) {
            functionName = config.getName();
        }
        return new KernelFunctionFromPrompt.Builder().withName(functionName).withDescription(config.getDescription()).withExecutionSettings(config.getExecutionSettings()).withInputParameters(config.getInputVariables()).withPromptTemplate(promptTemplate).withTemplate(template).withTemplateFormat(config.getTemplateFormat()).withOutputVariable(config.getOutputVariable()).withPromptTemplateFactory(promptTemplateFactory).build();
    }

    @Nullable
    public static KernelPlugin importPluginFromResourcesDirectory(String parentDirectory, String pluginDirectoryName, String functionName, @Nullable PromptTemplateFactory promptTemplateFactory) {
        return KernelPluginFactory.importPluginFromResourcesDirectory(parentDirectory, pluginDirectoryName, functionName, promptTemplateFactory, null);
    }

    @Nullable
    public static KernelPlugin importPluginFromResourcesDirectory(String parentDirectory, String pluginDirectoryName, String functionName, @Nullable PromptTemplateFactory promptTemplateFactory, @Nullable Class<?> clazz) {
        String template = KernelPluginFactory.getTemplatePrompt(parentDirectory, pluginDirectoryName, functionName, clazz);
        PromptTemplateConfig promptTemplateConfig = KernelPluginFactory.getPromptTemplateConfig(parentDirectory, pluginDirectoryName, functionName, clazz);
        if (promptTemplateConfig == null) {
            LOGGER.warn("Unable to load prompt template config for " + functionName + " in " + pluginDirectoryName);
            return null;
        }
        KernelFunction function = KernelPluginFactory.getKernelFunction(functionName, promptTemplateFactory, promptTemplateConfig, template);
        HashMap plugins = new HashMap();
        plugins.put(functionName, function);
        return new KernelPlugin(pluginDirectoryName, promptTemplateConfig.getDescription(), plugins);
    }

    private static String getTemplatePrompt(String pluginDirectory, String pluginName, String functionName, @Nullable Class<?> clazz) {
        String promptFileName = pluginDirectory + File.separator + pluginName + File.separator + functionName + File.separator + PROMPT_FILE;
        try {
            return KernelPluginFactory.getFileContents(promptFileName, clazz);
        }
        catch (IOException e) {
            LOGGER.error("Failed to read file " + promptFileName, (Throwable)e);
            throw new SKException("No plugins found in directory " + promptFileName);
        }
    }

    private static String getFileContents(String file, @Nullable Class<?> clazz) throws FileNotFoundException {
        if (clazz == null) {
            return EmbeddedResourceLoader.readFile(file, null, EmbeddedResourceLoader.ResourceLocation.CLASSPATH_ROOT, EmbeddedResourceLoader.ResourceLocation.FILESYSTEM);
        }
        return EmbeddedResourceLoader.readFile(file, clazz, EmbeddedResourceLoader.ResourceLocation.CLASSPATH_ROOT, EmbeddedResourceLoader.ResourceLocation.CLASSPATH, EmbeddedResourceLoader.ResourceLocation.FILESYSTEM);
    }

    @Nullable
    private static PromptTemplateConfig getPromptTemplateConfig(String pluginDirectory, String pluginName, String functionName, @Nullable Class<?> clazz) {
        String configFileName = pluginDirectory + File.separator + pluginName + File.separator + functionName + File.separator + CONFIG_FILE;
        try {
            String config = KernelPluginFactory.getFileContents(configFileName, clazz);
            return PromptTemplateConfig.parseFromJson(config);
        }
        catch (Exception e) {
            if (e instanceof SKException) {
                LOGGER.error("Failed to parse config file " + configFileName, (Throwable)e);
                throw new SKException("Failed to parse config file " + configFileName, e);
            }
            LOGGER.debug("No config for " + functionName + " in " + pluginName);
            return null;
        }
    }

    static {
        PRIMATIVE_CLASS_NAMES.put("void", Void.TYPE);
        PRIMATIVE_CLASS_NAMES.put("int", Integer.TYPE);
        PRIMATIVE_CLASS_NAMES.put("double", Double.TYPE);
        PRIMATIVE_CLASS_NAMES.put("boolean", Boolean.TYPE);
        PRIMATIVE_CLASS_NAMES.put("float", Float.TYPE);
        PRIMATIVE_CLASS_NAMES.put("long", Long.TYPE);
        PRIMATIVE_CLASS_NAMES.put("short", Short.TYPE);
        PRIMATIVE_CLASS_NAMES.put("byte", Byte.TYPE);
        PRIMATIVE_CLASS_NAMES.put("char", Character.TYPE);
        COMMON_CLASS_NAMES.put("integer", Integer.TYPE);
        COMMON_CLASS_NAMES.put("string", String.class);
        COMMON_CLASS_NAMES.put("list", ArrayList.class);
        COMMON_CLASS_NAMES.put("map", HashMap.class);
        COMMON_CLASS_NAMES.put("set", HashSet.class);
        BOXED_FROM_PRIMATIVE.put(Void.TYPE, Void.class);
        BOXED_FROM_PRIMATIVE.put(Integer.TYPE, Integer.class);
        BOXED_FROM_PRIMATIVE.put(Double.TYPE, Double.class);
        BOXED_FROM_PRIMATIVE.put(Boolean.TYPE, Boolean.class);
        BOXED_FROM_PRIMATIVE.put(Float.TYPE, Float.class);
        BOXED_FROM_PRIMATIVE.put(Long.TYPE, Long.class);
        BOXED_FROM_PRIMATIVE.put(Short.TYPE, Short.class);
        BOXED_FROM_PRIMATIVE.put(Byte.TYPE, Byte.class);
        BOXED_FROM_PRIMATIVE.put(Character.TYPE, Character.class);
    }
}

