/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks;

import com.microsoft.semantickernel.contextvariables.ContextVariableTypes;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.implementation.Verify;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.Block;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.BlockTypes;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.TextRendering;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.ValBlock;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.VarBlock;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionArguments;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedArgBlock
extends Block
implements TextRendering {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamedArgBlock.class);
    private final String name;
    @Nullable
    private final String value;
    private final VarBlock argNameAsVarBlock;
    @Nullable
    private final VarBlock varBlock;
    @Nullable
    private final ValBlock valBlock;

    public NamedArgBlock(String content, String name, String value) {
        super(content.trim(), BlockTypes.NAMED_ARG);
        this.name = name.trim();
        this.value = value.trim();
        this.argNameAsVarBlock = new VarBlock('$' + name);
        if (value.startsWith(String.valueOf('$'))) {
            this.varBlock = new VarBlock(value);
            this.valBlock = null;
        } else {
            this.valBlock = new ValBlock(value);
            this.varBlock = null;
        }
    }

    protected NamedArgBlock(String content, String name, @Nullable String value, VarBlock argNameAsVarBlock, @Nullable VarBlock varBlock, @Nullable ValBlock valBlock) {
        super(content, BlockTypes.NAMED_ARG);
        this.name = name;
        this.value = value;
        this.argNameAsVarBlock = argNameAsVarBlock;
        this.varBlock = varBlock;
        this.valBlock = valBlock;
    }

    public static NamedArgBlock from(String content) {
        ValBlock valBlock;
        VarBlock varBlock;
        String name = NamedArgBlock.tryGetName(content);
        if (name == null) {
            throw new SKException("Unable to extract name from: " + content);
        }
        String value = NamedArgBlock.tryGetValue(content);
        VarBlock argNameAsVarBlock = new VarBlock('$' + name);
        if (value == null) {
            throw new SKException("Unable to extract value from: " + content);
        }
        if (value.startsWith(String.valueOf('$'))) {
            varBlock = new VarBlock(value);
            valBlock = null;
        } else {
            valBlock = new ValBlock(value);
            varBlock = null;
        }
        return new NamedArgBlock(content, name, value, argNameAsVarBlock, varBlock, valBlock);
    }

    @Nullable
    public static String tryGetName(String text) {
        return NamedArgBlock.splitAndGetPart(text, 0);
    }

    @Nullable
    public static String tryGetValue(String text) {
        return NamedArgBlock.splitAndGetPart(text, 1);
    }

    @Nullable
    private static String splitAndGetPart(String text, int x) {
        if (Verify.isNullOrEmpty(text)) {
            return null;
        }
        String[] argBlockParts = text.split(String.valueOf('='));
        if (argBlockParts.length == 2) {
            return argBlockParts[x].trim();
        }
        return null;
    }

    @Override
    public boolean isValid() {
        if (Verify.isNullOrEmpty(this.name)) {
            LOGGER.error("A named argument must have a name");
            return false;
        }
        if (this.valBlock != null && !this.valBlock.isValid()) {
            LOGGER.error("There was an issue with the named argument value for '" + this.name);
            return false;
        }
        if (this.varBlock != null && !this.varBlock.isValid()) {
            LOGGER.error("There was an issue with the named argument value for '" + this.name);
            return false;
        }
        if (this.valBlock == null && this.varBlock == null) {
            LOGGER.error("A named argument must have a value");
            return false;
        }
        return this.argNameAsVarBlock.isValid();
    }

    @Override
    public String render(ContextVariableTypes types, @Nullable KernelFunctionArguments variables) {
        return this.getContent();
    }

    @Nullable
    public VarBlock getVarBlock() {
        return this.varBlock;
    }

    public String getName() {
        return this.name;
    }

    public String getValue(ContextVariableTypes types, KernelFunctionArguments arguments) {
        boolean valueIsValidVarBlock;
        boolean valueIsValidValBlock;
        boolean bl = valueIsValidValBlock = this.valBlock != null && this.valBlock.isValid();
        if (valueIsValidValBlock) {
            return this.valBlock.render(types, arguments);
        }
        boolean bl2 = valueIsValidVarBlock = this.varBlock != null && this.varBlock.isValid();
        if (valueIsValidVarBlock) {
            return this.varBlock.render(types, arguments);
        }
        return "";
    }
}

