/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.implementation.templateengine.tokenizer;

import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.implementation.Verify;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.Block;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.FunctionIdBlock;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.NamedArgBlock;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.ValBlock;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.VarBlock;
import com.microsoft.semantickernel.templateengine.semantickernel.TemplateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class CodeTokenizer {
    private static boolean isVarPrefix(char c) {
        return c == '$';
    }

    private static boolean IsBlankSpace(char c) {
        return Character.isWhitespace(c);
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'';
    }

    private static boolean CanBeEscaped(char c) {
        return c == '\"' || c == '\'' || c == '\\';
    }

    @Nullable
    private static NamedArgBlock getNamedArg(String tokenContent) {
        String name = NamedArgBlock.tryGetName(tokenContent);
        String value = NamedArgBlock.tryGetValue(tokenContent);
        if (Verify.isNullOrEmpty(name) || Verify.isNullOrEmpty(value)) {
            return null;
        }
        NamedArgBlock block = new NamedArgBlock(tokenContent, name, value);
        if (block.isValid()) {
            return block;
        }
        return null;
    }

    public List<Block> tokenize(String text) {
        if (text == null) {
            return new ArrayList<Block>();
        }
        if ((text = text.trim()).isEmpty()) {
            return Collections.unmodifiableList(new ArrayList());
        }
        TokenTypes currentTokenType = TokenTypes.None;
        StringBuilder currentTokenContent = new StringBuilder();
        char textValueDelimiter = '\u0000';
        ArrayList<Block> blocks = new ArrayList<Block>();
        char nextChar = text.charAt(0);
        boolean spaceSeparatorFound = false;
        boolean namedArgSeparatorFound = false;
        char namedArgValuePrefix = '\u0000';
        if (text.length() == 1) {
            switch (nextChar) {
                case '$': {
                    blocks.add(new VarBlock(text));
                    break;
                }
                case '\"': 
                case '\'': {
                    blocks.add(new ValBlock(text));
                    break;
                }
                default: {
                    blocks.add(new FunctionIdBlock(text));
                }
            }
            return blocks;
        }
        boolean skipNextChar = false;
        for (int nextCharCursor = 1; nextCharCursor < text.length(); ++nextCharCursor) {
            char currentChar = nextChar;
            nextChar = text.charAt(nextCharCursor);
            if (skipNextChar) {
                skipNextChar = false;
                continue;
            }
            if (nextCharCursor == 1) {
                if (CodeTokenizer.isVarPrefix(currentChar)) {
                    currentTokenType = TokenTypes.Variable;
                } else if (CodeTokenizer.isQuote(currentChar)) {
                    currentTokenType = TokenTypes.Value;
                    textValueDelimiter = currentChar;
                } else {
                    currentTokenType = TokenTypes.FunctionId;
                }
                currentTokenContent.append(currentChar);
                continue;
            }
            if (currentTokenType == TokenTypes.Value || currentTokenType == TokenTypes.NamedArg && CodeTokenizer.isQuote(namedArgValuePrefix)) {
                if (currentChar == '\\' && CodeTokenizer.CanBeEscaped(nextChar)) {
                    currentTokenContent.append(nextChar);
                    skipNextChar = true;
                    continue;
                }
                currentTokenContent.append(currentChar);
                if (currentChar == textValueDelimiter) {
                    blocks.add(new ValBlock(currentTokenContent.toString()));
                    currentTokenContent = new StringBuilder();
                    currentTokenType = TokenTypes.None;
                    spaceSeparatorFound = false;
                    continue;
                }
                if (currentChar != namedArgValuePrefix || currentTokenType != TokenTypes.NamedArg) continue;
                blocks.add(NamedArgBlock.from(currentTokenContent.toString()));
                currentTokenContent = new StringBuilder();
                currentTokenType = TokenTypes.None;
                spaceSeparatorFound = false;
                namedArgSeparatorFound = false;
                namedArgValuePrefix = '\u0000';
                continue;
            }
            if (CodeTokenizer.IsBlankSpace(currentChar)) {
                if (currentTokenType == TokenTypes.Variable) {
                    blocks.add(new VarBlock(currentTokenContent.toString()));
                    currentTokenContent = new StringBuilder();
                } else if (currentTokenType == TokenTypes.FunctionId) {
                    String tokenContent = currentTokenContent.toString();
                    NamedArgBlock namedArg = CodeTokenizer.getNamedArg(tokenContent);
                    if (namedArg != null) {
                        blocks.add(namedArg);
                    } else {
                        blocks.add(new FunctionIdBlock(tokenContent));
                    }
                    currentTokenContent = new StringBuilder();
                    currentTokenType = TokenTypes.None;
                } else if (currentTokenType == TokenTypes.NamedArg && namedArgSeparatorFound && namedArgValuePrefix != '\u0000') {
                    blocks.add(NamedArgBlock.from(currentTokenContent.toString()));
                    currentTokenContent = new StringBuilder();
                    namedArgSeparatorFound = false;
                    namedArgValuePrefix = '\u0000';
                    currentTokenType = TokenTypes.None;
                }
                spaceSeparatorFound = true;
                currentTokenType = TokenTypes.None;
                continue;
            }
            if (!(currentTokenType != TokenTypes.NamedArg || namedArgSeparatorFound && namedArgValuePrefix != '\u0000')) {
                if (!namedArgSeparatorFound) {
                    if (currentChar == '=') {
                        namedArgSeparatorFound = true;
                    }
                } else {
                    namedArgValuePrefix = currentChar;
                    if (!CodeTokenizer.isQuote(namedArgValuePrefix) && namedArgValuePrefix != '$') {
                        throw new SKException("Named argument values need to be prefixed with a quote or $");
                    }
                }
                currentTokenContent.append(currentChar);
                continue;
            }
            currentTokenContent.append(currentChar);
            if (currentTokenType != TokenTypes.None) continue;
            if (!spaceSeparatorFound) {
                throw new TemplateException(TemplateException.ErrorCodes.SYNTAX_ERROR, "Tokens must be separated by one space least");
            }
            if (CodeTokenizer.isQuote(currentChar)) {
                currentTokenType = TokenTypes.Value;
                textValueDelimiter = currentChar;
                continue;
            }
            currentTokenType = CodeTokenizer.isVarPrefix(currentChar) ? TokenTypes.Variable : (blocks.isEmpty() ? TokenTypes.FunctionId : TokenTypes.NamedArg);
        }
        currentTokenContent.append(nextChar);
        switch (currentTokenType) {
            case Value: {
                blocks.add(new ValBlock(currentTokenContent.toString()));
                break;
            }
            case Variable: {
                blocks.add(new VarBlock(currentTokenContent.toString()));
                break;
            }
            case FunctionId: {
                NamedArgBlock namedArg = CodeTokenizer.getNamedArg(currentTokenContent.toString());
                if (namedArg != null) {
                    blocks.add(namedArg);
                    break;
                }
                blocks.add(new FunctionIdBlock(currentTokenContent.toString()));
                break;
            }
            case NamedArg: {
                blocks.add(NamedArgBlock.from(currentTokenContent.toString()));
                break;
            }
            case None: {
                throw new TemplateException(TemplateException.ErrorCodes.SYNTAX_ERROR, "Tokens must be separated by one space least");
            }
        }
        return blocks;
    }

    private static enum TokenTypes {
        None(0),
        Value(1),
        Variable(2),
        FunctionId(3),
        NamedArg(4);


        private TokenTypes(int i) {
        }
    }
}

