/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.contextvariables;

import com.microsoft.semantickernel.contextvariables.ContextVariable;
import com.microsoft.semantickernel.contextvariables.ContextVariableType;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.converters.BooleanVariableContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.converters.CharacterVariableContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.converters.ChatHistoryVariableContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.converters.CollectionVariableContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.converters.CompletionUsageContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.converters.DateTimeContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.converters.InstantContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.converters.NumberVariableContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.converters.PrimitiveBooleanVariableContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.converters.StringVariableContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.converters.TextContentVariableContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.converters.VoidVariableContextVariableTypeConverter;
import com.microsoft.semantickernel.exceptions.SKException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ContextVariableTypes {
    private static final ContextVariableTypes DEFAULT_TYPES;
    private final Map<Class<?>, ContextVariableType<?>> variableTypes;

    public ContextVariableTypes(List<ContextVariableTypeConverter<?>> converters) {
        this.variableTypes = new HashMap();
        converters.forEach(this::putConverter);
    }

    public ContextVariableTypes() {
        this.variableTypes = new HashMap();
    }

    public ContextVariableTypes(ContextVariableTypes contextVariableTypes) {
        this.variableTypes = new HashMap(contextVariableTypes.variableTypes);
    }

    public static void addGlobalConverter(ContextVariableTypeConverter<?> conveter) {
        DEFAULT_TYPES.putConverter(conveter);
    }

    public static <T> ContextVariableType<T> getGlobalVariableTypeForClass(Class<T> aClass) {
        return DEFAULT_TYPES.getVariableTypeForClass(aClass);
    }

    @Nullable
    public static <T> T convert(@Nullable Object s, Class<T> clazz) {
        if (s instanceof ContextVariable && ((ContextVariable)s).getType().getClazz().isAssignableFrom(clazz)) {
            return ((ContextVariable)s).getValue();
        }
        if (s != null && clazz.isAssignableFrom(s.getClass())) {
            return clazz.cast(s);
        }
        return null;
    }

    public <T> void putConverter(ContextVariableTypeConverter<T> contextVariableTypeConverter) {
        this.variableTypes.put(contextVariableTypeConverter.getType(), new ContextVariableType<T>(contextVariableTypeConverter, contextVariableTypeConverter.getType()));
    }

    public <T> ContextVariableType<T> getVariableTypeForClass(Class<T> aClass) {
        try {
            return this.getVariableTypeForClassInternal(aClass);
        }
        catch (Exception e) {
            return DEFAULT_TYPES.getVariableTypeForClassInternal(aClass);
        }
    }

    public <T> ContextVariableType<T> getVariableTypeForSuperClass(Class<T> aClass) {
        try {
            return this.getVariableTypeForSuperClassInternal(aClass);
        }
        catch (Exception e) {
            return DEFAULT_TYPES.getVariableTypeForSuperClassInternal(aClass);
        }
    }

    private <T> ContextVariableType<T> getVariableTypeForClassInternal(Class<T> aClass) {
        ContextVariableType<?> contextVariableType = this.variableTypes.get(aClass);
        if (contextVariableType != null) {
            return contextVariableType;
        }
        return this.variableTypes.values().stream().filter(c -> c.getClazz().isAssignableFrom(aClass)).findFirst().orElseThrow(() -> new SKException("Unknown context variable type: " + aClass.getName()));
    }

    private <T> ContextVariableType<T> getVariableTypeForSuperClassInternal(Class<T> aClass) {
        ContextVariableType<?> contextVariableType = this.variableTypes.get(aClass);
        if (contextVariableType != null) {
            return contextVariableType;
        }
        return this.variableTypes.values().stream().filter(c -> aClass.isAssignableFrom(c.getClazz())).findFirst().orElseThrow(() -> new SKException("Unknown context variable type: " + aClass.getName()));
    }

    public void putConverters(ContextVariableTypes contextVariableTypes) {
        this.variableTypes.putAll(contextVariableTypes.variableTypes);
    }

    public <T> ContextVariable<T> contextVariableOf(T value) {
        if (value instanceof ContextVariable) {
            return (ContextVariable)value;
        }
        ContextVariableType<?> type = this.getVariableTypeForClass(value.getClass());
        if (type == null) {
            throw new SKException("Unknown type: " + value.getClass());
        }
        return type.of(value);
    }

    static {
        List<ContextVariableTypeConverter<?>> types = Arrays.asList(new CharacterVariableContextVariableTypeConverter(), new ChatHistoryVariableContextVariableTypeConverter(), new TextContentVariableContextVariableTypeConverter(), new StringVariableContextVariableTypeConverter(), new CollectionVariableContextVariableTypeConverter(), new VoidVariableContextVariableTypeConverter(), new ContextVariableTypeConverter<Void>(Void.TYPE, s -> null, s -> null, s -> null), new DateTimeContextVariableTypeConverter(), new InstantContextVariableTypeConverter(), new CompletionUsageContextVariableTypeConverter(), new BooleanVariableContextVariableTypeConverter(), new PrimitiveBooleanVariableContextVariableTypeConverter(), new NumberVariableContextVariableTypeConverter<Byte>(Byte.class, Byte::parseByte, Number::byteValue), new NumberVariableContextVariableTypeConverter<Byte>(Byte.TYPE, Byte::parseByte, Number::byteValue), new NumberVariableContextVariableTypeConverter<Integer>(Integer.class, Integer::parseInt, Number::intValue), new NumberVariableContextVariableTypeConverter<Integer>(Integer.TYPE, Integer::parseInt, Number::intValue), new NumberVariableContextVariableTypeConverter<Long>(Long.class, Long::parseLong, Number::longValue), new NumberVariableContextVariableTypeConverter<Long>(Long.TYPE, Long::parseLong, Number::longValue), new NumberVariableContextVariableTypeConverter<Double>(Double.class, Double::parseDouble, Number::doubleValue), new NumberVariableContextVariableTypeConverter<Double>(Double.TYPE, Double::parseDouble, Number::doubleValue), new NumberVariableContextVariableTypeConverter<Float>(Float.class, Float::parseFloat, Number::floatValue), new NumberVariableContextVariableTypeConverter<Float>(Float.TYPE, Float::parseFloat, Number::floatValue), new NumberVariableContextVariableTypeConverter<Short>(Short.class, Short::parseShort, Number::shortValue), new NumberVariableContextVariableTypeConverter<Short>(Short.TYPE, Short::parseShort, Number::shortValue));
        DEFAULT_TYPES = new ContextVariableTypes(types);
    }
}

