/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.contextvariables;

import com.microsoft.semantickernel.contextvariables.ContextVariable;
import com.microsoft.semantickernel.contextvariables.ContextVariableType;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypes;
import com.microsoft.semantickernel.exceptions.SKException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextVariableTypeConverter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextVariableTypeConverter.class);
    private final Class<T> clazz;
    private final Function<Object, T> fromObject;
    private final ToPromptStringFunction<T> toPromptString;
    private final Function<String, T> fromPromptString;
    private final List<Converter<T, ?>> toObjects;

    public ContextVariableTypeConverter(Class<T> clazz, Function<Object, T> fromObject, Function<T, String> toPromptString, Function<String, T> fromPromptString) {
        this(clazz, fromObject, toPromptString, fromPromptString, Collections.emptyList());
    }

    public ContextVariableTypeConverter(Class<T> clazz, Function<Object, T> fromObject, ToPromptStringFunction<T> toPromptString, Function<String, T> fromPromptString) {
        this(clazz, fromObject, toPromptString, fromPromptString, Collections.emptyList());
    }

    public ContextVariableTypeConverter(Class<T> clazz, Function<Object, T> fromObject, ToPromptStringFunction<T> toPromptString, Function<String, T> fromPromptString, List<Converter<T, ?>> toObjects) {
        this.clazz = clazz;
        this.fromObject = fromObject;
        this.toPromptString = toPromptString;
        this.fromPromptString = fromPromptString;
        this.toObjects = new ArrayList(toObjects);
    }

    public ContextVariableTypeConverter(Class<T> clazz, Function<Object, T> fromObject, Function<T, String> toPromptString, Function<String, T> fromPromptString, List<Converter<T, ?>> toObjects) {
        this.clazz = clazz;
        this.fromObject = fromObject;
        this.toPromptString = (types, t) -> (String)toPromptString.apply(t);
        this.fromPromptString = fromPromptString;
        this.toObjects = new ArrayList(toObjects);
    }

    @Nullable
    public <U> U toObject(ContextVariableTypes types, @Nullable Object t, Class<U> clazz) {
        if (t == null) {
            return null;
        }
        Optional<Converter> converter = this.toObjects.stream().filter(c -> c.getTargetType().equals(clazz)).findFirst();
        if (converter.isPresent()) {
            return converter.get().toObject(t);
        }
        converter = this.toObjects.stream().filter(c -> clazz.isAssignableFrom(c.getTargetType())).findFirst();
        if (converter.isPresent()) {
            return converter.get().toObject(t);
        }
        LOGGER.warn("No converter found for {} to {}", t.getClass(), clazz);
        return null;
    }

    @Nullable
    public T fromObject(@Nullable Object s) {
        if (s == null) {
            return null;
        }
        if (s instanceof ContextVariable) {
            return this.fromObject.apply(((ContextVariable)s).getValue());
        }
        return this.fromObject.apply(s);
    }

    public String toPromptString(ContextVariableTypes types, @Nullable T t) {
        if (t == null) {
            return "";
        }
        return this.toPromptString.toPromptString(types, t);
    }

    @Nullable
    public T fromPromptString(@Nullable String t) {
        if (t == null) {
            return null;
        }
        return this.fromPromptString.apply(t);
    }

    public Class<T> getType() {
        return this.clazz;
    }

    public static <T> Builder<T> builder(Class<T> clazz) {
        return new Builder<T>(clazz);
    }

    @Nullable
    public static String escapeXmlString(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return StringEscapeUtils.escapeXml11((String)value);
    }

    public static class Builder<T> {
        private final Class<T> clazz;
        private Function<Object, T> fromObject;
        private ToPromptStringFunction<T> toPromptString;
        private Function<String, T> fromPromptString;

        @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
        public Builder(Class<T> clazz) {
            this.clazz = clazz;
            this.fromObject = x -> {
                throw new UnsupportedOperationException("fromObject not implemented");
            };
            this.toPromptString = (a, b) -> {
                throw new UnsupportedOperationException("toPromptString not implemented");
            };
            this.fromPromptString = x -> {
                throw new UnsupportedOperationException("fromPromptString not implemented");
            };
        }

        public Builder<T> proxyGlobalType() {
            ContextVariableType<T> existingType = ContextVariableTypes.getGlobalVariableTypeForClass(this.clazz);
            if (existingType == null) {
                throw new SKException("Asked to proxy a global type that does not exist: " + this.clazz.getName());
            }
            return this.proxyType(existingType.getConverter());
        }

        public Builder<T> proxyType(ContextVariableTypeConverter<T> proxy) {
            this.fromObject = ((ContextVariableTypeConverter)proxy).fromObject;
            this.toPromptString = ((ContextVariableTypeConverter)proxy).toPromptString;
            this.fromPromptString = ((ContextVariableTypeConverter)proxy).fromPromptString;
            return this;
        }

        public Builder<T> fromObject(Function<Object, T> fromObject) {
            this.fromObject = fromObject;
            return this;
        }

        public Builder<T> toPromptString(Function<T, String> toPromptString) {
            this.toPromptString = (ignore, a) -> (String)toPromptString.apply(a);
            return this;
        }

        public Builder<T> fromPromptString(Function<String, T> fromPromptString) {
            this.fromPromptString = fromPromptString;
            return this;
        }

        public ContextVariableTypeConverter<T> build() {
            return new ContextVariableTypeConverter<T>(this.clazz, this.fromObject, this.toPromptString, this.fromPromptString);
        }
    }

    public static abstract class DefaultConverter<T, U>
    implements Converter<T, U> {
        private final Class<U> targetType;

        protected DefaultConverter(Class<T> sourceType, Class<U> targetType) {
            this.targetType = targetType;
        }

        @Override
        public Class<U> getTargetType() {
            return this.targetType;
        }
    }

    public static class NoopConverter<T>
    extends ContextVariableTypeConverter<T> {
        public NoopConverter(Class<T> clazz) {
            super(clazz, (Object x) -> x, (T x) -> {
                throw new RuntimeException("Noop converter should not be called");
            }, (String x) -> {
                throw new RuntimeException("Noop converter should not be called");
            });
        }
    }

    public static interface Converter<T, U> {
        public U toObject(T var1);

        public Class<U> getTargetType();
    }

    public static interface ToPromptStringFunction<T> {
        public String toPromptString(ContextVariableTypes var1, T var2);
    }
}

