/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.integration.core.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.spring.integration.core.converter.AzureMessageConverter;
import com.microsoft.azure.spring.integration.core.converter.ConversionException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public abstract class AbstractAzureMessageConverter<T>
implements AzureMessageConverter<T> {
    private static ObjectMapper objectMapper = new ObjectMapper();

    protected static byte[] toPayload(Object object) {
        try {
            return objectMapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new ConversionException("Failed to write JSON: " + object, e);
        }
    }

    private static <U> U fromPayload(byte[] payload, Class<U> payloadType) {
        try {
            return (U)objectMapper.readerFor(payloadType).readValue(payload);
        }
        catch (IOException e) {
            throw new ConversionException("Failed to read JSON: " + Arrays.toString(payload), e);
        }
    }

    @Override
    public T fromMessage(@NonNull Message<?> message, @NonNull Class<T> targetClass) {
        T azureMessage = this.internalFromMessage(message, targetClass);
        this.setCustomHeaders(message.getHeaders(), azureMessage);
        return azureMessage;
    }

    @Override
    public <U> Message<U> toMessage(@NonNull T azureMessage, Map<String, Object> headers, @NonNull Class<U> targetPayloadClass) {
        HashMap<String, Object> mergedHeaders = new HashMap<String, Object>();
        mergedHeaders.putAll(this.buildCustomHeaders(azureMessage));
        mergedHeaders.putAll(headers);
        return this.internalToMessage(azureMessage, mergedHeaders, targetPayloadClass);
    }

    protected abstract byte[] getPayload(T var1);

    protected abstract T fromString(String var1);

    protected abstract T fromByte(byte[] var1);

    protected void setCustomHeaders(MessageHeaders headers, T azureMessage) {
    }

    protected Map<String, Object> buildCustomHeaders(T azureMessage) {
        return new HashMap<String, Object>();
    }

    private T internalFromMessage(Message<?> message, Class<T> targetClass) {
        Object payload = message.getPayload();
        if (targetClass.isInstance(payload)) {
            return targetClass.cast(payload);
        }
        if (payload instanceof String) {
            return this.fromString((String)payload);
        }
        if (payload instanceof byte[]) {
            return this.fromByte((byte[])payload);
        }
        return this.fromByte(AbstractAzureMessageConverter.toPayload(payload));
    }

    private <U> Message<?> internalToMessage(T azureMessage, Map<String, Object> headers, Class<U> targetPayloadClass) {
        byte[] payload = this.getPayload(azureMessage);
        if (targetPayloadClass.isInstance(azureMessage)) {
            return MessageBuilder.withPayload(azureMessage).copyHeaders(headers).build();
        }
        if (targetPayloadClass == String.class) {
            return MessageBuilder.withPayload((Object)new String(payload)).copyHeaders(headers).build();
        }
        if (targetPayloadClass == byte[].class) {
            return MessageBuilder.withPayload((Object)payload).copyHeaders(headers).build();
        }
        return MessageBuilder.withPayload(AbstractAzureMessageConverter.fromPayload(payload, targetPayloadClass)).copyHeaders(headers).build();
    }
}

