/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.integration.core.api;

import com.microsoft.azure.spring.integration.core.api.CheckpointMode;
import java.time.Duration;

public class CheckpointConfig {
    private final CheckpointMode checkpointMode;
    private final int checkpointCount;
    private final Duration checkpointInterval;

    public CheckpointConfig(CheckpointMode checkpointMode, int checkpointCount, Duration checkpointInterval) {
        this.checkpointMode = checkpointMode;
        this.checkpointCount = checkpointCount;
        this.checkpointInterval = checkpointInterval;
    }

    public static CheckpointConfigBuilder builder() {
        return new CheckpointConfigBuilder();
    }

    public CheckpointMode getCheckpointMode() {
        return this.checkpointMode;
    }

    public int getCheckpointCount() {
        return this.checkpointCount;
    }

    public Duration getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public String toString() {
        return "CheckpointConfig{checkpointMode=" + (Object)((Object)this.checkpointMode) + ", checkpointCount=" + this.checkpointCount + ", checkpointInterval=" + this.checkpointInterval + '}';
    }

    public static class CheckpointConfigBuilder {
        private CheckpointMode checkpointMode;
        private int checkpointCount;
        private Duration checkpointInterval;

        public CheckpointConfigBuilder checkpointMode(CheckpointMode checkpointMode) {
            this.checkpointMode = checkpointMode;
            return this;
        }

        public CheckpointConfigBuilder checkpointCount(int checkpointCount) {
            this.checkpointCount = checkpointCount;
            return this;
        }

        public CheckpointConfigBuilder checkpointInterval(Duration checkpointInterval) {
            this.checkpointInterval = checkpointInterval;
            return this;
        }

        public CheckpointConfig build() {
            return new CheckpointConfig(this.checkpointMode, this.checkpointCount, this.checkpointInterval);
        }
    }
}

