/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.integration.core;

import com.microsoft.azure.spring.integration.core.AzureSendFailureException;
import com.microsoft.azure.spring.integration.core.api.PartitionSupplier;
import com.microsoft.azure.spring.integration.core.api.SendOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.MessageTimeoutException;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractMessageProducingHandler;
import org.springframework.integration.support.DefaultErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class DefaultMessageHandler
extends AbstractMessageProducingHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultMessageHandler.class);
    private static final long DEFAULT_SEND_TIMEOUT = 10000L;
    private final String destination;
    private final SendOperation sendOperation;
    private boolean sync = false;
    private ListenableFutureCallback<Void> sendCallback;
    private EvaluationContext evaluationContext;
    private Expression sendTimeoutExpression = new ValueExpression((Object)10000L);
    private ErrorMessageStrategy errorMessageStrategy = new DefaultErrorMessageStrategy();
    private Expression partitionKeyExpression;
    private MessageChannel sendFailureChannel;
    private String sendFailureChannelName;

    public DefaultMessageHandler(String destination, @NonNull SendOperation sendOperation) {
        Assert.hasText((String)destination, (String)"destination can't be null or empty");
        this.destination = destination;
        this.sendOperation = sendOperation;
    }

    protected void onInit() {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        log.info("Started DefaultMessageHandler with properties: {}", this.buildPropertiesMap());
    }

    protected void handleMessageInternal(Message<?> message) {
        PartitionSupplier partitionSupplier = this.toPartitionSupplier(message);
        String destination = this.toDestination(message);
        CompletableFuture<Void> future = this.sendOperation.sendAsync(destination, message, partitionSupplier);
        if (this.sync) {
            this.waitingSendResponse(future, message);
            return;
        }
        this.handleSendResponseAsync(message, future);
    }

    private void handleSendResponseAsync(Message<?> message, CompletableFuture<?> future) {
        future.handle((t, ex) -> {
            if (ex != null) {
                if (log.isWarnEnabled()) {
                    log.warn("{} sent failed in async mode due to {}", (Object)message, (Object)ex.getMessage());
                }
                if (this.sendCallback != null) {
                    this.sendCallback.onFailure(ex);
                }
                if (this.getSendFailureChannel() != null) {
                    this.messagingTemplate.send((Object)this.getSendFailureChannel(), (Message)this.getErrorMessageStrategy().buildErrorMessage((Throwable)((Object)new AzureSendFailureException(message, (Throwable)ex)), null));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("{} sent successfully in async mode", (Object)message);
                }
                if (this.sendCallback != null) {
                    this.sendCallback.onSuccess((Object)((Void)t));
                }
            }
            return null;
        });
    }

    private void waitingSendResponse(CompletableFuture future, Message<?> message) {
        Long sendTimeout = (Long)this.sendTimeoutExpression.getValue(this.evaluationContext, message, Long.class);
        if (sendTimeout < 0L) {
            try {
                future.get();
            }
            catch (Exception e) {
                throw new MessageDeliveryException(e.getMessage());
            }
        }
        try {
            future.get(sendTimeout, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled()) {
                log.debug("{} sent successfully in sync mode", message);
            }
        }
        catch (TimeoutException e) {
            throw new MessageTimeoutException(message, "Timeout waiting for send event hub response", (Throwable)e);
        }
        catch (Exception e) {
            throw new MessageDeliveryException(e.getMessage());
        }
    }

    public void setSync(boolean sync) {
        this.sync = sync;
        log.info("DefaultMessageHandler sync becomes: {}", (Object)sync);
    }

    public void setSendTimeout(long sendTimeout) {
        this.setSendTimeoutExpression((Expression)new ValueExpression((Object)sendTimeout));
    }

    public void setSendTimeoutExpression(Expression sendTimeoutExpression) {
        Assert.notNull((Object)sendTimeoutExpression, (String)"'sendTimeoutExpression' must not be null");
        this.sendTimeoutExpression = sendTimeoutExpression;
        log.info("DefaultMessageHandler syncTimeout becomes: {}", (Object)sendTimeoutExpression);
    }

    public void setPartitionKey(String partitionKey) {
        this.setPartitionKeyExpression((Expression)new LiteralExpression(partitionKey));
    }

    public void setPartitionKeyExpression(Expression partitionKeyExpression) {
        this.partitionKeyExpression = partitionKeyExpression;
    }

    public void setPartitionKeyExpressionString(String partitionKeyExpression) {
        this.setPartitionKeyExpression(EXPRESSION_PARSER.parseExpression(partitionKeyExpression));
    }

    private String toDestination(Message<?> message) {
        if (message.getHeaders().containsKey((Object)"azure_name")) {
            return (String)message.getHeaders().get((Object)"azure_name", String.class);
        }
        return this.destination;
    }

    private PartitionSupplier toPartitionSupplier(Message<?> message) {
        PartitionSupplier partitionSupplier = new PartitionSupplier();
        String partitionKey = (String)message.getHeaders().get((Object)"azure_partition_key", String.class);
        if (!StringUtils.hasText((String)partitionKey) && this.partitionKeyExpression != null) {
            partitionKey = (String)this.partitionKeyExpression.getValue(this.evaluationContext, message, String.class);
        }
        if (StringUtils.hasText((String)partitionKey)) {
            partitionSupplier.setPartitionKey(partitionKey);
        }
        if (message.getHeaders().containsKey((Object)"azure_partition_id")) {
            partitionSupplier.setPartitionId((String)message.getHeaders().get((Object)"azure_partition_id", String.class));
        }
        return partitionSupplier;
    }

    private Map<String, Object> buildPropertiesMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("sync", this.sync);
        properties.put("sendTimeout", this.sendTimeoutExpression);
        properties.put("destination", this.destination);
        return properties;
    }

    public void setSendCallback(ListenableFutureCallback<Void> callback) {
        this.sendCallback = callback;
    }

    public Expression getSendTimeoutExpression() {
        return this.sendTimeoutExpression;
    }

    public void setSendFailureChannel(MessageChannel sendFailureChannel) {
        this.sendFailureChannel = sendFailureChannel;
    }

    protected MessageChannel getSendFailureChannel() {
        if (this.sendFailureChannel != null) {
            return this.sendFailureChannel;
        }
        if (this.sendFailureChannelName != null) {
            this.sendFailureChannel = (MessageChannel)this.getChannelResolver().resolveDestination(this.sendFailureChannelName);
            return this.sendFailureChannel;
        }
        return null;
    }

    public void setSendFailureChannelName(String sendFailureChannelName) {
        this.sendFailureChannelName = sendFailureChannelName;
    }

    public void setErrorMessageStrategy(ErrorMessageStrategy errorMessageStrategy) {
        Assert.notNull((Object)errorMessageStrategy, (String)"'errorMessageStrategy' must not be null");
        this.errorMessageStrategy = errorMessageStrategy;
    }

    protected ErrorMessageStrategy getErrorMessageStrategy() {
        return this.errorMessageStrategy;
    }
}

